/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.blaze.feature;

import insane96mcp.enhancedai.modules.blaze.ai.EABlazeAttackGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import insane96mcp.insanelib.config.MinMax;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Blaze Attack", description="Make blazes fire faster/more fireballs")
public class BlazeAttack
extends Feature {
    private final MinMax.Config timeBetweenFireballsConfig;
    private final MinMax.Config fireballsShotConfig;
    private final MinMax.Config rechargeTimeConfig;
    private final MinMax.Config chargeTimeConfig;
    private final MinMax.Config fireballsPerShotConfig;
    private final MinMax.Config inaccuracyConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public MinMax timeBetweenFireballs = new MinMax(4.0, 10.0);
    public MinMax fireballsShot = new MinMax(3.0, 8.0);
    public MinMax rechargeTime = new MinMax(60.0, 100.0);
    public MinMax chargeTime = new MinMax(30.0, 60.0);
    public MinMax fireballsPerShot = new MinMax(1.0, 2.0);
    public MinMax inaccuracy = new MinMax(2.0, 14.0);
    public Blacklist entityBlacklist;

    public BlazeAttack(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.timeBetweenFireballsConfig = new MinMax.Config(Config.builder, "Time Between Fireballs", "How many ticks pass between shooting fireballs. Vanilla is 6").setMinMax(1.0, 300.0, this.timeBetweenFireballs).build();
        this.fireballsShotConfig = new MinMax.Config(Config.builder, "Fireballs shot", "How many fireballs blazes shoot. Vanilla is 3").setMinMax(1.0, 64.0, this.fireballsShot).build();
        this.rechargeTimeConfig = new MinMax.Config(Config.builder, "Recharge time", "Time (in ticks) taken by the blaze to recharge (before setting himself on fire). Vanilla is 100").setMinMax(1.0, 600.0, this.rechargeTime).build();
        this.chargeTimeConfig = new MinMax.Config(Config.builder, "Charge time", "Time (in ticks) taken by the blaze to charge (while on fire before shooting fireballs). Vanilla is 60").setMinMax(1.0, 600.0, this.chargeTime).build();
        this.fireballsPerShotConfig = new MinMax.Config(Config.builder, "Fireballs Per Shot", "How many fireballs are shot per shot. Vanilla is 1").setMinMax(1.0, 8.0, this.fireballsPerShot).build();
        this.inaccuracyConfig = new MinMax.Config(Config.builder, "Inaccuracy", "The higher the more spread up shots will be. Setting both to -1 will use the vanilla behaviour").setMinMax(-1.0, 32.0, this.inaccuracy).build();
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the new Blaze Attack AI").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.timeBetweenFireballs = this.timeBetweenFireballsConfig.get();
        this.fireballsShot = this.fireballsShotConfig.get();
        this.rechargeTime = this.rechargeTimeConfig.get();
        this.chargeTime = this.chargeTimeConfig.get();
        this.fireballsPerShot = this.fireballsPerShotConfig.get();
        this.inaccuracy = this.inaccuracyConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Blaze)) {
            return;
        }
        Blaze blaze = (Blaze)entity;
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)blaze)) {
            return;
        }
        CompoundTag persistentData = blaze.getPersistentData();
        int timeBetweenFireballs = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:time_between_fireballs", this.timeBetweenFireballs.getIntRandBetween(blaze.m_21187_()));
        int fireballsShot = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:fireballs_shot", this.fireballsShot.getIntRandBetween(blaze.m_21187_()));
        int rechargeTime = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:recharge_time", this.rechargeTime.getIntRandBetween(blaze.m_21187_()));
        int chargeTime = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:charge_time", this.chargeTime.getIntRandBetween(blaze.m_21187_()));
        int fireballsPerShot = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:fireballs_per_shot", this.fireballsPerShot.getIntRandBetween(blaze.m_21187_()));
        int inaccuracy = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:inaccuracy", this.inaccuracy.getIntRandBetween(blaze.m_21187_()));
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        blaze.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Blaze.BlazeAttackGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)blaze.f_21345_).m_25363_(arg_0));
        blaze.f_21345_.m_25352_(4, (Goal)new EABlazeAttackGoal(blaze).setTimeBetweenFireballs(timeBetweenFireballs).setFireballShot(fireballsShot).setRechargeTime(rechargeTime).setChargeTime(chargeTime).setFireballsPerShot(fireballsPerShot).setInaccuracy(inaccuracy));
    }
}

