/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.ClimbLaddersGoal;
import insane96mcp.enhancedai.modules.base.ai.FindLaddersGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Movement", description="Makes mobs be able to move in more ways, like climbing or swim.")
public class Movement
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> allowClimbingConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> targetLaddersConfig;
    private final ForgeConfigSpec.ConfigValue<Double> swimSpeedMultiplierConfig;
    public boolean allowClimbing = false;
    public boolean targetLadders = false;
    public double swimSpeedMultiplier = 2.5;
    final UUID UUID_SWIM_SPEED_MULTIPLIER = UUID.fromString("6d2cb27e-e5e3-41b9-8108-f74131a90cce");

    public Movement(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.allowClimbingConfig = Config.builder.comment("If true, mobs will be able to climb (up and down)").define("Allow Climbing", this.allowClimbing);
        this.targetLaddersConfig = Config.builder.comment("If true, mobs try to find climbable blocks to reach the target").define("Target Ladders", this.targetLadders);
        this.swimSpeedMultiplierConfig = Config.builder.comment("How faster mobs can swim. Setting to 0 will leave the swim speed as vanilla. I recommend using mods like Mobs Properties Randomness to have more control over the attribute.").defineInRange("Swim Speed Multiplier", this.swimSpeedMultiplier, 0.0, 4.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.allowClimbing = (Boolean)this.allowClimbingConfig.get();
        this.targetLadders = (Boolean)this.targetLaddersConfig.get();
        this.swimSpeedMultiplier = (Double)this.swimSpeedMultiplierConfig.get();
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (this.allowClimbing) {
            mob.f_21345_.m_25352_(3, (Goal)new ClimbLaddersGoal(mob));
        }
        if (this.targetLadders) {
            mob.f_21346_.m_25352_(0, (Goal)new FindLaddersGoal(mob));
        }
        if (this.swimSpeedMultiplier != 0.0) {
            MCUtils.applyModifier((LivingEntity)mob, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)this.UUID_SWIM_SPEED_MULTIPLIER, (String)"Enhanced AI Swim Speed Multiplier", (double)this.swimSpeedMultiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
    }
}

