/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.AvoidExplosionGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Avoid Explosions", description="Mobs will run away from exploding creepers / TNT")
public class AvoidExplosions
extends Feature {
    private final ForgeConfigSpec.DoubleValue runSpeedNearConfig;
    private final ForgeConfigSpec.DoubleValue runSpeedFarConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public double runSpeedNear = 1.4;
    public double runSpeedFar = 1.2;
    public Blacklist entityBlacklist;

    public AvoidExplosions(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.runSpeedNearConfig = Config.builder.comment("Speed multiplier when the mob runs from explosions and it's within 7 blocks from him.").defineInRange("Flee speed Multiplier Near", this.runSpeedNear, 0.0, 10.0);
        this.runSpeedFarConfig = Config.builder.comment("Speed multiplier when the mob runs from explosions and it's farther than 7 blocks from him.").defineInRange("Flee speed Multiplier Far", this.runSpeedFar, 0.0, 10.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Avoid Explosions AI").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.runSpeedNear = (Double)this.runSpeedNearConfig.get();
        this.runSpeedFar = (Double)this.runSpeedFarConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.addAvoidAI(event);
        this.alertTNT(event);
    }

    private void addAvoidAI(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob creatureEntity = (PathfinderMob)entity;
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)creatureEntity)) {
            return;
        }
        creatureEntity.f_21345_.m_25352_(1, (Goal)new AvoidExplosionGoal(creatureEntity, this.runSpeedNear, this.runSpeedFar));
    }

    private void alertTNT(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PrimedTnt)) {
            return;
        }
        PrimedTnt tnt = (PrimedTnt)entity;
        List creaturesNearby = tnt.f_19853_.m_45976_(PathfinderMob.class, tnt.m_142469_().m_82400_(8.0));
        for (PathfinderMob creatureEntity : creaturesNearby) {
            creatureEntity.f_21345_.f_25345_.forEach(prioritizedGoal -> {
                Goal patt3107$temp = prioritizedGoal.m_26015_();
                if (patt3107$temp instanceof AvoidExplosionGoal) {
                    AvoidExplosionGoal avoidExplosionGoal = (AvoidExplosionGoal)patt3107$temp;
                    avoidExplosionGoal.run((Entity)tnt, 8.0);
                }
            });
        }
    }
}

