/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;

@Label(name="Attacking")
public class Attacking
extends Feature {
    private final ForgeConfigSpec.BooleanValue meleeAttacksAttributeBasedConfig;
    public boolean meleeAttacksAttributeBased = false;

    public Attacking(Module module) {
        super(Config.builder, module, true);
        this.pushConfig(Config.builder);
        this.meleeAttacksAttributeBasedConfig = Config.builder.comment("If true melee monsters (zombies, etc) will attack based off the forge:attack_range attribute. Increasing it will make mobs attack for farther away. Be aware that the attack doesn't check if there are block between the target and the mob so might result in mobs attacking through walls with high values").define("Melee Attacks Attribute Based", this.meleeAttacksAttributeBased);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.meleeAttacksAttributeBased = (Boolean)this.meleeAttacksAttributeBasedConfig.get();
    }

    public static void attackRangeAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)ForgeMod.ATTACK_RANGE.get())) continue;
            event.add(entityType, (Attribute)ForgeMod.ATTACK_RANGE.get(), (double)entityType.m_20678_() * 2.0);
        }
    }

    public boolean shouldChangeAttackRange() {
        return this.isEnabled() && this.meleeAttacksAttributeBased;
    }
}

