/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal.feature;

import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Animal Attacking", description="Make animals fight back and no longer flee when attacked")
public class AnimalAttacking
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> animalsFightBackConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> noMoreFleeConfig;
    private final ForgeConfigSpec.ConfigValue<Double> speedMultiplierConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public boolean animalsFightBack = true;
    public boolean noMoreFlee = true;
    public double speedMultiplier = 1.35;
    public Blacklist entityBlacklist;
    private static final double BASE_ATTACK_DAMAGE = 4.0;

    public AnimalAttacking(Module module) {
        super(Config.builder, module, true, false);
        super.pushConfig(Config.builder);
        this.animalsFightBackConfig = Config.builder.comment("If true, when attacked, animals will call other animals for help and attack back. Animals have a slightly bigger range to attack. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to increase the damage. Base damage is " + String.format("%.1f", 4.0)).define("Animals Fight back", this.animalsFightBack);
        this.noMoreFleeConfig = Config.builder.comment("If true, when attacked, animals will no longer flee.").define("Animals No Longer Flee", this.noMoreFlee);
        this.speedMultiplierConfig = Config.builder.comment("Movement speed multiplier when attacking.").defineInRange("Movement Speed Multiplier", this.speedMultiplier, 0.0, 4.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't be affected by this feature").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.animalsFightBack = (Boolean)this.animalsFightBackConfig.get();
        this.noMoreFlee = (Boolean)this.noMoreFleeConfig.get();
        this.speedMultiplier = (Double)this.speedMultiplierConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, Attributes.f_22281_)) continue;
            event.add(entityType, Attributes.f_22281_, 4.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        Animal animal;
        Entity entity;
        if (!this.isEnabled() || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal) || this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(animal = (Animal)entity))) {
            return;
        }
        CompoundTag persistentData = animal.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", this.speedMultiplier);
        if (this.animalsFightBack) {
            animal.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)animal, new Class[0]).m_26044_(new Class[0]));
            animal.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)animal, movementSpeedMultiplier, false));
            AttributeInstance kbAttribute = animal.m_21051_(Attributes.f_22282_);
            if (kbAttribute != null) {
                kbAttribute.m_22125_(new AttributeModifier("Animal knockback", 3.5, AttributeModifier.Operation.ADDITION));
            }
        }
        if (this.noMoreFlee) {
            ArrayList<Object> goalsToRemove = new ArrayList<Object>();
            for (WrappedGoal prioritizedGoal : animal.f_21345_.f_25345_) {
                Goal goal = prioritizedGoal.m_26015_();
                if (!(goal instanceof PanicGoal)) continue;
                PanicGoal goal2 = (PanicGoal)goal;
                goalsToRemove.add(goal2);
            }
            goalsToRemove.forEach((Consumer<Object>)((Consumer<Goal>)arg_0 -> ((GoalSelector)animal.f_21345_).m_25363_(arg_0)));
        }
    }
}

