/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.client.KeyHandler;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.forge.ClientEventHandler;
import com.teamderpy.shouldersurfing.plugin.PluginLoader;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="shouldersurfing")
public class ShoulderSurfingForge {
    public ShoulderSurfingForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC, "shouldersurfing.toml");
            modEventBus.addListener(this::modConfigLoadingEvent);
            modEventBus.addListener(this::modConfigReloadingEvent);
        });
        modLoadingContext.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::keyInputEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::preRenderPlayerEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::clientTickEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, ClientEventHandler::preRenderGuiOverlayEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::computeCameraAnglesEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::renderLevelStageEvent);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_CAMERA_LEFT);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_CAMERA_RIGHT);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_CAMERA_IN);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_CAMERA_OUT);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_CAMERA_UP);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_CAMERA_DOWN);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_SWAP_SHOULDER);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEYBIND_TOGGLE_SHOULDER_SURFING);
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        PluginLoader.getInstance().loadPlugins();
    }

    @SubscribeEvent
    public void modConfigLoadingEvent(ModConfigEvent.Loading event) {
        ShoulderInstance.getInstance().changePerspective(Config.CLIENT.getDefaultPerspective());
    }

    @SubscribeEvent
    public void modConfigReloadingEvent(ModConfigEvent.Reloading event) {
        Config.onConfigReload(event.getConfig());
    }
}

