/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.setup.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Fixes", description="A few fixes")
public class FixFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> fixFollowRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> removeZombiesBonusHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> fixJumpMovementFactorConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> slowdownOnlyConfig;
    public boolean fixFollowRange = true;
    public boolean removeZombiesBonusHealth = true;
    public boolean fixJumpMovementFactor = true;
    public boolean slowdownOnly = true;

    public FixFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.fixFollowRangeConfig = Config.builder.comment("If true, mobs will have their follow range fixed. https://bugs.mojang.com/browse/MC-145656").define("Fix Follow Range", this.fixFollowRange);
        this.removeZombiesBonusHealthConfig = Config.builder.comment("Removes the random bonus health given to Leader Zombies. In vanilla it's useless since doesn't work. https://minecraft.fandom.com/wiki/Attribute#Vanilla_modifiers").define("Remove Zombies Bonus Health", this.removeZombiesBonusHealth);
        this.fixJumpMovementFactorConfig = Config.builder.comment("When affected by slowness the player can still jump really far away. When true, jumps length will be calculated based off player's movement speed.").define("Fix Jump Movement Factor", this.fixJumpMovementFactor);
        this.slowdownOnlyConfig = Config.builder.comment("The fix for Jump Movement Factor is applied only when the player is slowed down. If false, the player will jump really farther when going faster.").define("Fix Jump Movement Factor Slowdown Only", this.slowdownOnly);
        Config.builder.pop();
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
        this.fixFollowRange = (Boolean)this.fixFollowRangeConfig.get();
        this.removeZombiesBonusHealth = (Boolean)this.removeZombiesBonusHealthConfig.get();
        this.fixJumpMovementFactor = (Boolean)this.fixJumpMovementFactorConfig.get();
        this.slowdownOnly = (Boolean)this.slowdownOnlyConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.fixFollowRange(event.getEntity());
        this.removeZombiesBonusHealth(event.getEntity());
    }

    private void removeZombiesBonusHealth(Entity entity) {
        if (!this.removeZombiesBonusHealth) {
            return;
        }
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (zombie.m_21051_(Attributes.f_22276_) == null) {
            return;
        }
        Set modifiers = zombie.m_21051_(Attributes.f_22276_).m_22122_();
        for (AttributeModifier attributeModifier : modifiers) {
            if (!attributeModifier.m_22214_().equals("Leader zombie bonus")) continue;
            zombie.m_21051_(Attributes.f_22276_).m_22120_(attributeModifier.m_22209_());
        }
    }

    private void fixFollowRange(Entity entity) {
        if (!this.fixFollowRange) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mobEntity = (Mob)entity;
        AttributeInstance followRangeAttribute = mobEntity.m_21051_(Attributes.f_22277_);
        if (followRangeAttribute != null) {
            for (WrappedGoal pGoal : mobEntity.f_21346_.f_25345_) {
                Goal goal = pGoal.m_26015_();
                if (!(goal instanceof NearestAttackableTargetGoal)) continue;
                NearestAttackableTargetGoal nearestAttackableTargetGoal = (NearestAttackableTargetGoal)goal;
                nearestAttackableTargetGoal.f_26051_.m_26883_(mobEntity.m_21133_(Attributes.f_22277_));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onUpdate(TickEvent.PlayerTickEvent event) {
        double playerSpeedRatio;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.fixJumpMovementFactor) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        float baseJMF = 0.02f;
        if (event.player.m_20142_()) {
            baseJMF += 0.006f;
        }
        if ((playerSpeedRatio = MCUtils.getMovementSpeedRatio(event.player)) > 1.0 && this.slowdownOnly) {
            return;
        }
        event.player.f_20887_ = (float)(playerSpeedRatio * (double)baseJMF);
    }
}

