/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.extensions.PxJoint;

public class PxFixedJoint
extends PxJoint {
    protected PxFixedJoint() {
    }

    public static PxFixedJoint wrapPointer(long address) {
        return address != 0L ? new PxFixedJoint(address) : null;
    }

    protected PxFixedJoint(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        PxFixedJoint._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public void setProjectionLinearTolerance(float tolerance) {
        this.checkNotNull();
        PxFixedJoint._setProjectionLinearTolerance(this.address, tolerance);
    }

    private static native void _setProjectionLinearTolerance(long var0, float var2);

    public float getProjectionLinearTolerance() {
        this.checkNotNull();
        return PxFixedJoint._getProjectionLinearTolerance(this.address);
    }

    private static native float _getProjectionLinearTolerance(long var0);

    public void setProjectionAngularTolerance(float tolerance) {
        this.checkNotNull();
        PxFixedJoint._setProjectionAngularTolerance(this.address, tolerance);
    }

    private static native void _setProjectionAngularTolerance(long var0, float var2);

    public float getProjectionAngularTolerance() {
        this.checkNotNull();
        return PxFixedJoint._getProjectionAngularTolerance(this.address);
    }

    private static native float _getProjectionAngularTolerance(long var0);
}

