/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render.shader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;

public class ShaderResourceProvider
implements ResourceProvider {
    private static final String NAMESPACE = "physicsmod";

    public Resource m_142591_(final ResourceLocation resourceLocation) throws IOException {
        return new Resource(){
            @Nullable
            InputStream inputStream;

            public void close() throws IOException {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }

            public ResourceLocation m_7843_() {
                return resourceLocation;
            }

            public InputStream m_6679_() {
                try {
                    this.inputStream = ShaderResourceProvider.this.getResourceStream(resourceLocation);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", iOException);
                }
                return this.inputStream;
            }

            public boolean m_142564_() {
                return false;
            }

            @Nullable
            public <T> T m_5507_(MetadataSectionSerializer<T> metadataSectionSerializer) {
                return null;
            }

            public String m_7816_() {
                return resourceLocation.toString();
            }
        };
    }

    public InputStream getResourceStream(ResourceLocation resourceLocation) throws IOException {
        InputStream inputStream = this.processResourceAsStream(resourceLocation);
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(resourceLocation.m_135815_());
    }

    protected InputStream processResourceAsStream(ResourceLocation resourceLocation) {
        PackType packType = PackType.CLIENT_RESOURCES;
        String string = ShaderResourceProvider.createPath(packType, resourceLocation);
        try {
            URL url = ShaderResourceProvider.class.getResource(string);
            if (ShaderResourceProvider.isResourceUrlValid(string, url)) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            return ShaderResourceProvider.class.getResourceAsStream(string);
        }
        return null;
    }

    private static String createPath(PackType packType, ResourceLocation resourceLocation) {
        return "/" + packType.m_10305_() + "/physicsmod/" + resourceLocation.m_135815_();
    }

    private static boolean isResourceUrlValid(String string, @Nullable URL url) throws IOException {
        return url != null && (url.getProtocol().equals("jar") || FolderPackResources.m_10273_((File)new File(url.getFile()), (String)string));
    }
}

