/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Pack;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Vector2f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.org.joml.Vector3i;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.smoke.ParticleInfo;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.diebuddies.physics.smoke.SmokeShader;
import net.diebuddies.physics.smoke.SmokeShadowTransformer;
import net.diebuddies.render.MainRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SmokeRenderer {
    private MainRenderer mainRenderer;
    private Matrix4f invProjectionMatrix = new Matrix4f();
    private com.mojang.math.Vector3f tmpColor = new com.mojang.math.Vector3f();
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    public static SmokeShader smokeShader;
    public static SmokeShader smokeShadowShader;
    public static Texture smokeDepthCopy;
    public static VAO smokeVAO;
    private float[] smokepos = new float[400];
    private float[] smokeposnew = new float[400];
    private byte[] smokelight = new byte[400];
    private int count;
    private SmokeShadowTransformer shadowTransformer;
    private boolean needsSmokeUpdate = false;

    public SmokeRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
        this.shadowTransformer = ConfigClient.smokeShadowTransformer;
    }

    public void render(PhysicsWorld physics, ClientLevel level, PoseStack rotationModelStack, Vec3 cameraPos) {
    }

    private void updateSmokeInstances(SmokeDomain smokeDomain, Vec3 cameraPos) {
        if (smokeVAO == null) {
            this.createSmokeVAO(PhysicsMod.smoke);
        }
        PhysicsWorld physics = smokeDomain.getWorld();
        Vector3d physicsOffset = physics.getOffset();
        List<IRigidBody> smokeParticles = smokeDomain.getAllParticles();
        this.checkSmokeArrays(smokeParticles.size() * 4);
        this.count = 0;
        for (int i = 0; i < smokeParticles.size(); ++i) {
            IRigidBody body = smokeParticles.get(i);
            if (body.isDestroyed()) continue;
            this.prepareSmokeInstances(physics, physics.getLevel(), cameraPos, body.getEntity(), body, physicsOffset.x, physicsOffset.y, physicsOffset.z, this.count);
            ++this.count;
        }
        smokeVAO.bind();
        smokeVAO.updateAttribute(Data.SMOKE_LIGHT, this.smokelight, this.count * 4);
        smokeVAO.updateAttribute(Data.SMOKE_POS, this.smokepos, this.count * 4);
        smokeVAO.updateAttribute(Data.SMOKE_POS_NEW, this.smokeposnew, this.count * 4);
    }

    private void checkSmokeArrays(int neededSize) {
        int size;
        boolean changed = false;
        for (size = this.smokelight.length; neededSize > size; size *= 2) {
            changed = true;
        }
        if (changed) {
            this.smokelight = new byte[size];
            this.smokepos = new float[size];
            this.smokeposnew = new float[size];
        }
    }

    private void prepareSmokeInstances(PhysicsWorld physics, Level level, Vec3 view, PhysicsEntity particle, IRigidBody body, double ox, double oy, double oz, int offset) {
        Matrix4d oldTransformation = particle.getOldTransformation();
        Matrix4d currentTransformation = particle.getTransformation();
        this.blockPos.m_122169_(currentTransformation.m30() + ox, currentTransformation.m31() + oy, currentTransformation.m32() + oz);
        int brightness = particle.getLight(level, this.blockPos);
        int mulOffset = offset * 4;
        byte scale = (byte)(Math.remapClamp(particle.scale, 0.25, 5.0, 0.0, 1.0) * 255.0);
        this.smokelight[mulOffset] = (byte)(particle.color & 0xFF);
        this.smokelight[mulOffset + 1] = (byte)(particle.color >> 8 & 0xFF);
        this.smokelight[mulOffset + 2] = (byte)(brightness >> 4 & 0xF | brightness >> 16 & 0xF0);
        this.smokelight[mulOffset + 3] = scale;
        double animationScale = particle.getDespawnScale(level);
        this.smokepos[mulOffset] = (float)oldTransformation.m30();
        this.smokepos[mulOffset + 1] = (float)oldTransformation.m31();
        this.smokepos[mulOffset + 2] = (float)oldTransformation.m32();
        this.smokepos[mulOffset + 3] = java.lang.Math.min(1.0f, (float)animationScale);
        this.smokeposnew[mulOffset] = (float)currentTransformation.m30();
        this.smokeposnew[mulOffset + 1] = (float)currentTransformation.m31();
        this.smokeposnew[mulOffset + 2] = (float)currentTransformation.m32();
        this.smokeposnew[mulOffset + 3] = ((ParticleInfo)body.getUserData()).averagedDensity;
    }

    private void createSmokeVAO(Mesh mesh) {
        int size = mesh.indices.size();
        if (smokeVAO == null) {
            net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
            this.mainRenderer.checkArrays(size);
            for (int i = 0; i < size; ++i) {
                Vector3i index = mesh.indices.get(i);
                Vector3d p = mesh.positions.get(index.x - 1);
                Vector2f uv = mesh.uvs.get(index.y - 1);
                Vector3f normal = mesh.normals.get(index.z - 1);
                this.mainRenderer.mcol[i] = -1;
                int cp = i * 3;
                this.mainRenderer.mpos[cp] = (float)p.x;
                this.mainRenderer.mpos[cp + 1] = (float)p.y;
                this.mainRenderer.mpos[cp + 2] = (float)p.z;
                int cu = i * 2;
                this.mainRenderer.muv[cu] = uv.x;
                this.mainRenderer.muv[cu + 1] = uv.y;
                this.mainRenderer.mnormals[i] = Pack.normal(normal.x, normal.y, normal.z);
            }
            openglMesh.set(this.mainRenderer.mpos, Data.POSITION);
            openglMesh.set(this.mainRenderer.mcol, Data.COLOR);
            openglMesh.set(this.mainRenderer.muv, Data.TEX_COORD);
            openglMesh.set(this.mainRenderer.mnormals, Data.NORMAL);
            openglMesh.set(this.smokelight, Data.SMOKE_LIGHT);
            openglMesh.set(this.smokepos, Data.SMOKE_POS);
            openglMesh.set(this.smokeposnew, Data.SMOKE_POS_NEW);
            openglMesh.setSize(Data.POSITION, size * 3);
            openglMesh.setSize(Data.COLOR, size);
            openglMesh.setSize(Data.TEX_COORD, size * 2);
            openglMesh.setSize(Data.NORMAL, size);
            openglMesh.setSize(Data.INDEX, size);
            smokeVAO = openglMesh.constructVAO(Usage.DYNAMIC);
        }
    }

    public static void destroy() {
        if (smokeShader != null) {
            smokeShader.destroy();
        }
        if (smokeShadowShader != null) {
            smokeShadowShader.destroy();
        }
        if (smokeVAO != null) {
            smokeVAO.destroy();
        }
        if (smokeDepthCopy != null) {
            smokeDepthCopy.destroy();
        }
    }

    private /* synthetic */ void lambda$render$0(SmokeDomain domain) {
        this.needsSmokeUpdate = true;
    }
}

