/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.IrisNormalMatrix;
import net.diebuddies.compat.IrisPBR;
import net.diebuddies.compat.Optifine;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.mixins.MixinShaderInstance;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.org.joml.FrustumIntersection;
import net.diebuddies.org.joml.Math;
import net.diebuddies.org.joml.Matrix3d;
import net.diebuddies.org.joml.Matrix3f;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Matrix4f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.render.ClothRenderer;
import net.diebuddies.render.DebugRenderer;
import net.diebuddies.render.LiquidRenderer;
import net.diebuddies.render.OceanRenderer;
import net.diebuddies.render.PhysicsUpdater;
import net.diebuddies.render.SmokeRenderer;
import net.diebuddies.render.SnowRenderer;
import net.diebuddies.render.TransparencyRenderer;
import net.diebuddies.render.shader.ParallaxShader;
import net.diebuddies.render.shader.ParallaxSlideShader;
import net.diebuddies.render.shader.SolidPhysicsShader;
import net.diebuddies.util.DoublyLinkedList;
import net.diebuddies.util.HttpRequest;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryUtil;

public class MainRenderer {
    private static final int DEFAULT_SIZE = 200;
    private static final Matrix4f IDENTITY_4_BY_4 = new Matrix4f();
    private static final float INVERT_COLOR = 0.003921569f;
    public static final Vector3d DIFFUSE_LIGHT_0 = new Vector3d(0.2, 1.0, -0.7).normalize();
    public static final Vector3d DIFFUSE_LIGHT_1 = new Vector3d(-0.2, 1.0, 0.7).normalize();
    public static final Vector3d NETHER_DIFFUSE_LIGHT_0 = new Vector3d(0.2, 1.0, -0.7).normalize();
    public static final Vector3d NETHER_DIFFUSE_LIGHT_1 = new Vector3d(-0.2, -1.0, 0.7).normalize();
    public Vector3d lightDirection0 = new Vector3d();
    public Vector3d lightDirection1 = new Vector3d();
    public int size = 200;
    public float[] mpos = new float[this.size * 3];
    public int[] mcol = new int[this.size];
    public float[] muv = new float[this.size * 2];
    public int[] mnormals = new int[this.size];
    public float[] mmidtexcoord = new float[this.size * 2];
    public int[] mtangent = new int[this.size];
    public FrustumIntersection frustumInt = new FrustumIntersection();
    private Matrix4f viewProjectionMatrix = new Matrix4f();
    private Matrix4f projectionMatrix = new Matrix4f();
    private Matrix4f viewMatrix = new Matrix4f();
    public Matrix4f lastTextureMatrix;
    private Matrix4d transformation = new Matrix4d();
    private Matrix3d normalMatrix = new Matrix3d();
    private Vector3d pos = new Vector3d();
    private Matrix4f tmp = new Matrix4f();
    private Matrix3f cameraNormalMatrix = new Matrix3f();
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    private Matrix4d currentPose = new Matrix4d();
    private boolean resetAttributes;
    private int lastBrightness;
    public int normalLocation = -1;
    public int specularLocation = -1;
    private volatile int failedVerificationCount;
    public long tickCountdown = 120000000000L;
    private long lastVerifTime;
    private PhysicsUpdater physicsUpdater = new PhysicsUpdater();
    private DebugRenderer debugRenderer = new DebugRenderer(this);
    private SmokeRenderer smokeRenderer = new SmokeRenderer(this);
    public OceanRenderer oceanRenderer;
    private SnowRenderer snowRenderer = new SnowRenderer(this);
    private LiquidRenderer liquidRenderer = new LiquidRenderer(this);
    private ClothRenderer clothRenderer;
    private TransparencyRenderer transparencyRenderer;
    private static ParallaxShader parallaxShader;
    private static ParallaxSlideShader parallaxSlideShader;
    public static SolidPhysicsShader solidPhysicsShader;
    public static FloatBuffer matrixBuffer;
    public static FloatBuffer vector4Buffer;
    public static FloatBuffer vector3Buffer;

    public MainRenderer() {
        this.oceanRenderer = new OceanRenderer(this);
        this.transparencyRenderer = new TransparencyRenderer(this);
        this.clothRenderer = new ClothRenderer(this);
        if (matrixBuffer == null) {
            matrixBuffer = MemoryUtil.memAllocFloat((int)16);
            vector4Buffer = MemoryUtil.memAllocFloat((int)4);
            vector3Buffer = MemoryUtil.memAllocFloat((int)3);
        }
    }

    public void renderAll(ClientLevel level, RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, com.mojang.math.Matrix4f projectionMatrix) {
        RenderSystem.m_187554_();
        this.verifyAndUtility();
        StarterClient.setMatrix(this.projectionMatrix, projectionMatrix);
        StarterClient.setMatrix(this.viewMatrix, viewMatrixStack.m_85850_().m_85861_());
        this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
        this.frustumInt.set(this.viewProjectionMatrix, true);
        PhysicsMod.projectionMatrix.m_162210_(projectionMatrix);
        PhysicsMod.viewMatrix.m_162210_(viewMatrixStack.m_85850_().m_85861_());
        if (level != null) {
            Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            PhysicsMod mod = PhysicsMod.getInstance((Level)level);
            PhysicsWorld physics = mod.getPhysicsWorld();
            physics.updateLastSeen();
            this.physicsUpdater.updatePhysics(mod, level, view, physics);
            if (physics.getBodies().size() > 0 || physics.getRagdolls().size() > 0 || physics.getVerletSimulations().size() > 0 || physics.getSnowWorld().getChunks().size() > 0 || physics.getSmokeDomain().getAllParticles().size() > 0 || PhysicsMod.clothRenderFast.size() > 0) {
                PerformanceTracker.startNoFlush("blocks_mobs_particles_rendering");
                blockLayerIn.m_110185_();
                this.bindProperShader();
                RenderSystem.m_157425_((com.mojang.math.Matrix4f)projectionMatrix);
                PoseStack matrixStackIn = RenderSystem.m_157191_();
                RenderSystem.m_69482_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                matrixStackIn.m_85836_();
                matrixStackIn.m_166854_(viewMatrixStack.m_85850_().m_85861_());
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.m_69388_((int)33984);
                RenderSystem.m_69493_();
                this.setupShader(RenderSystem.m_157196_());
                VAO.storePreviouslyBoundState();
                StarterClient.setMatrix(this.tmp, matrixStackIn.m_85850_().m_85861_()).normal(this.cameraNormalMatrix);
                this.lastTextureMatrix = null;
                this.resetAttributes = true;
                Vector3d physicsOffset = physics.getOffset();
                double offsetX = physicsOffset.x - view.f_82479_;
                double offsetY = physicsOffset.y - view.f_82480_;
                double offsetZ = physicsOffset.z - view.f_82481_;
                boolean isShadowPass = StarterClient.iris && Iris.isExtending() && Iris.isShadowPass() || StarterClient.optifabric && Optifine.isShadowPass();
                this.createPhysicsModels(physics);
                physics.bindForRendering();
                DoublyLinkedList<IRigidBody> bodies = physics.getBodies();
                Iterator<IRigidBody> it = bodies.iterator();
                int size = bodies.size();
                for (int i = 0; i < size; ++i) {
                    IRigidBody body = it.next();
                    PhysicsEntity entity = body.getEntity();
                    if (entity.models == null) continue;
                    this.setTransformation(physics, body, entity, isShadowPass);
                    this.render(physics, level, matrixStackIn, view, offsetX, offsetY, offsetZ, body, entity, false);
                }
                StateTracker.unbindVertexArray();
                PerformanceTracker.end("blocks_mobs_particles_rendering");
                this.snowRenderer.render(physics, level, matrixStackIn, view);
                this.smokeRenderer.render(physics, level, matrixStackIn, view);
                if (StarterClient.optifabric) {
                    BufferUploader.m_166835_();
                }
                this.resetAttributes = true;
                this.transparencyRenderer.render(physics, level, matrixStackIn, view);
                if (RenderSystem.m_157196_().f_173310_ != null) {
                    RenderSystem.m_157196_().f_173310_.m_5679_(RenderSystem.m_157207_());
                }
                VAO.restorePreviouslyBoundState();
                RenderSystem.m_157196_().m_173362_();
                this.debugRenderer.render(physics, level, matrixStackIn, view);
                matrixStackIn.m_85849_();
                RenderSystem.m_69388_((int)33984);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69481_();
                blockLayerIn.m_110188_();
                RenderSystem.m_157182_();
                BufferUploader.m_166835_();
            }
        }
    }

    public void bindProperShader() {
        boolean useCustomShader = true;
        if (StarterClient.iris && Iris.isExtending()) {
            useCustomShader = false;
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            useCustomShader = false;
        }
        if (useCustomShader) {
            if (solidPhysicsShader == null) {
                try {
                    solidPhysicsShader = new SolidPhysicsShader();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            RenderSystem.m_157427_(() -> solidPhysicsShader);
        } else {
            RenderSystem.m_157427_(GameRenderer::m_172658_);
            if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                Optifine.useEntityShader();
            }
        }
    }

    private void createPhysicsModels(PhysicsWorld physics) {
        Set<PhysicsEntity> bodies = physics.getQueueForModelCreation();
        Iterator<PhysicsEntity> it = bodies.iterator();
        int size = bodies.size();
        block0: for (int i = 0; i < size; ++i) {
            PhysicsEntity entity = it.next();
            List<Model> models = entity.models;
            if (entity.models == null) continue;
            int modelsSize = models.size();
            for (int j = 0; j < modelsSize; ++j) {
                Model model = models.get(j);
                boolean shade = entity.shade;
                Mesh mesh = model.mesh;
                if (mesh == null || mesh.indices.size() < 3) continue block0;
                if (model.memorySegment != null) continue;
                model.createModelMemorySegment(physics, shade);
            }
        }
        bodies.clear();
    }

    public void setTransformation(PhysicsWorld physics, IRigidBody body, PhysicsEntity entity, boolean isShadowPass) {
        if (isShadowPass) {
            return;
        }
        if (body.hasTransformationChanged()) {
            MatrixUtil.slerpNoScale(entity, physics.getRenderPercent(), entity.getRenderTransformation());
        } else {
            entity.getRenderTransformation().set(entity.getTransformation());
        }
    }

    public void render(PhysicsWorld physics, ClientLevel level, PoseStack matrixStackIn, Vec3 view, double offsetX, double offsetY, double offsetZ, IRigidBody body, PhysicsEntity particle, boolean renderTransparency) {
        List<Model> models = particle.models;
        Mesh mesh = models.get((int)0).mesh;
        if (mesh == null || mesh.indices.size() < 3) {
            return;
        }
        double animationScale = particle.getDespawnScale((Level)level);
        boolean alphaRender = false;
        if (particle.getAnimationType() == AnimationType.Vanish) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)animationScale));
            if (animationScale < 1.0) {
                alphaRender = true;
            }
            animationScale = 1.0;
        } else if (particle.getAnimationType() == AnimationType.Shrink_and_Vanish) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)animationScale));
            if (animationScale < 1.0) {
                alphaRender = true;
            }
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.transformation.set(particle.getRenderTransformation());
        this.transformation.m30(this.transformation.m30() + offsetX);
        this.transformation.m31(this.transformation.m31() + offsetY);
        this.transformation.m32(this.transformation.m32() + offsetZ);
        this.transformation.getTranslation(this.pos);
        if (!renderTransparency && !this.frustumInt.testSphere((float)this.pos.x, (float)this.pos.y, (float)this.pos.z, (float)particle.getBoundingSphereRadius())) {
            return;
        }
        if (alphaRender && !renderTransparency) {
            this.transparencyRenderer.addTransparentObject(body, this.pos.lengthSquared());
            return;
        }
        if (particle.backfaceCulling) {
            RenderSystem.m_69481_();
        } else {
            RenderSystem.m_69464_();
        }
        double scaleX = (animationScale *= particle.scale) * particle.scalePhysics.x;
        double scaleY = animationScale * particle.scalePhysics.y;
        double scaleZ = animationScale * particle.scalePhysics.z;
        this.transformation.scale((float)scaleX, (float)scaleY, (float)scaleZ);
        ShaderInstance shader = RenderSystem.m_157196_();
        this.blockPos.m_122169_(this.pos.x + view.f_82479_, this.pos.y + view.f_82480_, this.pos.z + view.f_82481_);
        StarterClient.setMatrix(this.currentPose, matrixStackIn.m_85850_().m_85861_());
        this.currentPose.mulAffine(this.transformation);
        this.setupModelViewMatrix(shader, this.currentPose, this.cameraNormalMatrix, particle.shade);
        this.setupLighting(this.transformation, shader, level, particle.shade);
        int size = models.size();
        for (int j = 0; j < size; ++j) {
            Model model = models.get(j);
            int glID = model.textureID;
            RenderSystem.m_157453_((int)0, (int)glID);
            RenderSystem.m_69388_((int)33984);
            RenderSystem.m_69396_((int)glID);
            this.setupPBRTextures();
            RenderSystem.m_69388_((int)33984);
            if (model.animationSprite != null && StarterClient.sodium) {
                Sodium.markSpriteActive(model.animationSprite);
            }
            this.renderFast(physics, level, particle, model, this.blockPos);
        }
    }

    public void setupModelViewMatrix(ShaderInstance shader, Matrix4d transformation, @Nullable Matrix3f cameraNormalMatrix, boolean shade) {
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(transformation);
        } else {
            int location = shader.f_173308_.m_166752_();
            if (location != -1) {
                GL32C.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)transformation.get(matrixBuffer));
            }
        }
        if (StarterClient.irisNormalMatrix) {
            IrisNormalMatrix.setNormalMatrix(shader, transformation);
        }
    }

    public void setupLighting(Matrix4d transformation, ShaderInstance shader, ClientLevel level, boolean shade) {
        if (shader.f_173313_ != null) {
            if (shade) {
                Matrix3d lightMatrix = transformation.normal(this.normalMatrix).invert();
                if (shader.f_173313_ != null || shader.f_173314_ != null) {
                    if (level.m_104583_().m_108885_()) {
                        lightMatrix.transform(NETHER_DIFFUSE_LIGHT_0, this.lightDirection0);
                        lightMatrix.transform(NETHER_DIFFUSE_LIGHT_1, this.lightDirection1);
                    } else {
                        lightMatrix.transform(DIFFUSE_LIGHT_0, this.lightDirection0);
                        lightMatrix.transform(DIFFUSE_LIGHT_1, this.lightDirection1);
                    }
                    RenderSystem.f_157150_[0].m_122245_((float)this.lightDirection0.x, (float)this.lightDirection0.y, (float)this.lightDirection0.z);
                    RenderSystem.f_157150_[1].m_122245_((float)this.lightDirection1.x, (float)this.lightDirection1.y, (float)this.lightDirection1.z);
                }
            } else if (shader.f_173313_ != null || shader.f_173314_ != null) {
                if (level.m_104583_().m_108885_()) {
                    RenderSystem.f_157150_[0].m_122245_((float)MainRenderer.NETHER_DIFFUSE_LIGHT_0.x, (float)MainRenderer.NETHER_DIFFUSE_LIGHT_0.y, (float)MainRenderer.NETHER_DIFFUSE_LIGHT_0.z);
                    RenderSystem.f_157150_[1].m_122245_((float)MainRenderer.NETHER_DIFFUSE_LIGHT_1.x, (float)MainRenderer.NETHER_DIFFUSE_LIGHT_1.y, (float)MainRenderer.NETHER_DIFFUSE_LIGHT_1.z);
                } else {
                    RenderSystem.f_157150_[0].m_122245_((float)MainRenderer.DIFFUSE_LIGHT_0.x, (float)MainRenderer.DIFFUSE_LIGHT_0.y, (float)MainRenderer.DIFFUSE_LIGHT_0.z);
                    RenderSystem.f_157150_[1].m_122245_((float)MainRenderer.DIFFUSE_LIGHT_0.x, (float)MainRenderer.DIFFUSE_LIGHT_0.y, (float)MainRenderer.DIFFUSE_LIGHT_0.z);
                }
            }
        }
    }

    public void setupPBRTextures() {
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            int before = RenderSystem.m_157203_((int)0);
            Optifine.bindPBRTexture(before);
            RenderSystem.m_69388_((int)33984);
            RenderSystem.m_69493_();
            RenderSystem.m_69396_((int)before);
        } else if (StarterClient.irisPBR) {
            if (this.normalLocation != -1) {
                RenderSystem.m_69388_((int)(33984 + this.normalLocation));
                RenderSystem.m_69493_();
                RenderSystem.m_69396_((int)IrisPBR.getNormalTextureID());
            }
            if (this.specularLocation != -1) {
                RenderSystem.m_69388_((int)(33984 + this.specularLocation));
                RenderSystem.m_69493_();
                RenderSystem.m_69396_((int)IrisPBR.getSpecularTextureID());
            }
            RenderSystem.m_69388_((int)33984);
        }
    }

    private void renderFast(PhysicsWorld physics, ClientLevel level, PhysicsEntity particle, Model model, BlockPos.MutableBlockPos blockPos) {
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        int size = mesh.indices.size();
        if (size < 3) {
            return;
        }
        int brightness = particle.getLight((Level)level, blockPos);
        if (this.resetAttributes) {
            GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(brightness & 0xF0), (int)(brightness >> 16 & 0xF0));
            GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
            this.resetAttributes = false;
        } else if (this.lastBrightness != brightness) {
            GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(brightness & 0xF0), (int)(brightness >> 16 & 0xF0));
        }
        this.lastBrightness = brightness;
        ShaderInstance shader = RenderSystem.m_157196_();
        float[] shaderColor = RenderSystem.m_157197_();
        float b = (float)(particle.color & 0xFF) / 255.0f;
        float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
        float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
        shaderColor[0] = shaderColor[0] * r;
        shaderColor[1] = shaderColor[1] * g;
        shaderColor[2] = shaderColor[2] * b;
        this.setupShaderUniforms(shader, model.textureMatrix);
        ArenaBuffer.MemorySegment segment = model.memorySegment;
        GL32C.glDrawArrays((int)4, (int)(segment.offset / physics.format.getStride()), (int)(segment.size / physics.format.getStride()));
    }

    public void setupShaderUniforms(ShaderInstance shader) {
        this.setupShaderUniforms(shader, null);
    }

    public void setupShaderUniforms(ShaderInstance shader, @Nullable Matrix4f textureMatrix) {
        long pointer;
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            FloatBuffer lightBuffer;
            int location;
            if (shader.f_173313_ != null) {
                Vector3f light0 = RenderSystem.f_157150_[0];
                location = shader.f_173313_.m_166752_();
                if (location != -1) {
                    lightBuffer = vector3Buffer;
                    pointer = MemoryUtil.memAddress((FloatBuffer)lightBuffer);
                    MemoryUtil.memPutFloat((long)pointer, (float)light0.m_122239_());
                    MemoryUtil.memPutFloat((long)(pointer + 4L), (float)light0.m_122260_());
                    MemoryUtil.memPutFloat((long)(pointer + 8L), (float)light0.m_122269_());
                    GL32C.glUniform3fv((int)location, (FloatBuffer)lightBuffer);
                }
            }
            if (shader.f_173314_ != null) {
                Vector3f light1 = RenderSystem.f_157150_[1];
                location = shader.f_173314_.m_166752_();
                if (location != -1) {
                    lightBuffer = vector3Buffer;
                    pointer = MemoryUtil.memAddress((FloatBuffer)lightBuffer);
                    MemoryUtil.memPutFloat((long)pointer, (float)light1.m_122239_());
                    MemoryUtil.memPutFloat((long)(pointer + 4L), (float)light1.m_122260_());
                    MemoryUtil.memPutFloat((long)(pointer + 8L), (float)light1.m_122269_());
                    GL32C.glUniform3fv((int)location, (FloatBuffer)lightBuffer);
                }
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setColorModulator(RenderSystem.m_157197_());
            Matrix4f upload = IDENTITY_4_BY_4;
            if (textureMatrix != null) {
                upload = textureMatrix;
            }
            if (upload != this.lastTextureMatrix) {
                Optifine.setTextureMatrix(upload);
                this.lastTextureMatrix = upload;
            }
        } else {
            int location;
            int location2;
            if (shader.f_173312_ != null && (location2 = shader.f_173312_.m_166752_()) != -1) {
                float[] shaderColor = RenderSystem.m_157197_();
                FloatBuffer colorBuffer = vector4Buffer;
                pointer = MemoryUtil.memAddress((FloatBuffer)colorBuffer);
                MemoryUtil.memPutFloat((long)pointer, (float)shaderColor[0]);
                MemoryUtil.memPutFloat((long)(pointer + 4L), (float)shaderColor[1]);
                MemoryUtil.memPutFloat((long)(pointer + 8L), (float)shaderColor[2]);
                MemoryUtil.memPutFloat((long)(pointer + 12L), (float)shaderColor[3]);
                GL32C.glUniform4fv((int)location2, (FloatBuffer)colorBuffer);
            }
            if (shader.f_173310_ != null && (location = shader.f_173310_.m_166752_()) != -1) {
                Matrix4f upload = IDENTITY_4_BY_4;
                if (textureMatrix != null) {
                    upload = textureMatrix;
                }
                if (upload != this.lastTextureMatrix) {
                    GL32C.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)upload.get(matrixBuffer));
                    this.lastTextureMatrix = upload;
                }
            }
        }
    }

    public void setupShader(ShaderInstance shader) {
        Minecraft.m_91087_().f_91063_.m_109155_().m_118087_();
        for (int n = 0; n < 8; ++n) {
            int o = RenderSystem.m_157203_((int)n);
            shader.m_173350_("Sampler" + n, (Object)o);
        }
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(RenderSystem.m_157190_());
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(RenderSystem.m_157192_());
        }
        if (shader.f_173312_ != null) {
            shader.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shader.f_173315_ != null) {
            shader.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shader.f_173316_ != null) {
            shader.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shader.f_173317_ != null) {
            shader.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shader.f_173310_ != null) {
            shader.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shader.f_173319_ != null) {
            shader.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shader.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shader.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        RenderSystem.m_157461_((ShaderInstance)shader);
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            shader.m_173363_();
        }
        if (StarterClient.iris) {
            List<String> samplerNames = ((MixinShaderInstance)RenderSystem.m_157196_()).getSamplerNames();
            this.normalLocation = -1;
            this.specularLocation = -1;
            for (int i = 0; i < samplerNames.size(); ++i) {
                String sampler = samplerNames.get(i);
                if (sampler.equals("normals")) {
                    this.normalLocation = i;
                    continue;
                }
                if (!sampler.equals("specular")) continue;
                this.specularLocation = i;
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(RenderSystem.m_157190_());
            Optifine.setProjectionMatrix(RenderSystem.m_157192_());
            Optifine.setTextureMatrix(RenderSystem.m_157207_());
            Optifine.setColorModulator(RenderSystem.m_157197_());
        }
    }

    public void checkArrays(int neededSize) {
        boolean changed = false;
        while (neededSize > this.size) {
            this.size *= 2;
            changed = true;
        }
        if (changed) {
            this.mpos = new float[this.size * 3];
            this.mcol = new int[this.size];
            this.muv = new float[this.size * 2];
            this.mnormals = new int[this.size];
            this.mmidtexcoord = new float[this.size * 2];
            this.mtangent = new int[this.size];
        }
    }

    public void renderCloth(ClientLevel level, RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, com.mojang.math.Matrix4f projectionMatrix) {
        this.clothRenderer.render(level, blockLayerIn, viewMatrixStack, xIn, yIn, zInm, projectionMatrix);
    }

    public void renderLiquid(ClientLevel level, RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, com.mojang.math.Matrix4f projectionMatrix) {
        this.liquidRenderer.render(level, blockLayerIn, viewMatrixStack, xIn, yIn, zInm, projectionMatrix);
    }

    public void verifyAndUtility() {
        if (StarterClient.updateMessage != null && !StarterClient.updateMessage.isBlank() && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.Serializer.m_130701_((String)StarterClient.updateMessage), false);
            StarterClient.updateMessage = "";
        }
        if (StarterClient.customMessage != null && !StarterClient.customMessage.isBlank() && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.Serializer.m_130701_((String)StarterClient.customMessage), false);
            StarterClient.customMessage = "";
        }
    }

    public static ParallaxShader getParallaxShader() {
        if (parallaxShader == null) {
            try {
                parallaxShader = new ParallaxShader();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return parallaxShader;
    }

    public static ParallaxSlideShader getParallaxSlideShader() {
        if (parallaxSlideShader == null) {
            try {
                parallaxSlideShader = new ParallaxSlideShader();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return parallaxSlideShader;
    }

    public static void destroy() {
        if (solidPhysicsShader != null) {
            solidPhysicsShader.close();
        }
        if (parallaxShader != null) {
            parallaxShader.close();
        }
        if (parallaxSlideShader != null) {
            parallaxSlideShader.close();
        }
        SmokeRenderer.destroy();
        TransparencyRenderer.destroy();
        OceanRenderer.destroy();
        if (matrixBuffer != null) {
            MemoryUtil.memFree((Buffer)matrixBuffer);
        }
        if (vector4Buffer != null) {
            MemoryUtil.memFree((Buffer)vector4Buffer);
        }
        if (vector3Buffer != null) {
            MemoryUtil.memFree((Buffer)vector3Buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$verifyAndUtility$1(String mcName) {
        try {
            String result = HttpRequest.get("http://verify.minecraftphysicsmod.com/verify?code=" + ConfigClient.verificationCode + "&name=" + mcName);
            boolean verified = result.contains(ConfigClient.verificationCode + "verified");
            this.failedVerificationCount = verified ? 0 : ++this.failedVerificationCount;
        }
        catch (Exception e) {
            e.printStackTrace();
            ++this.failedVerificationCount;
        }
        finally {
            if (this.failedVerificationCount >= 5) {
                Minecraft.m_91332_((CrashReport)new CrashReport("unverified physics mod copy", new Throwable("couldn't verify copy")));
            }
        }
    }
}

