/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.DoorRagdoll;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.vines.Adjustable;
import net.diebuddies.physics.vines.DynamicSetting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class DoorSetting
extends DynamicSetting {
    @Adjustable(id="Hitbox scale", min=0.1, max=10.0, step=0.01, translationId="physicsmod.prop.door.hitboxscale")
    public Vector3f hitboxScale;
    @Adjustable(id="Stiffness", min=0.1, max=5000.0, step=0.1, translationId="physicsmod.prop.door.stiffness")
    public float stiffness;
    @Adjustable(id="Damping", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.door.damping")
    public float damping;
    @Adjustable(id="Collision", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.door.collision")
    public boolean collision;

    public DoorSetting(Vector3f hitboxScale, float stiffness, float damping, boolean linkedPhysics, boolean collision) {
        this.collision = collision;
        this.hitboxScale = hitboxScale;
        this.stiffness = stiffness;
        this.damping = damping;
        this.linkedPhysics = linkedPhysics;
    }

    public DoorSetting() {
        this.collision = true;
        this.hitboxScale = new Vector3f(0.85f);
        this.stiffness = 1580.0f;
        this.damping = 8.0f;
        this.linkedPhysics = true;
    }

    @Override
    public DynamicRagdoll createRagdoll(PhysicsMod mod, BlockState current, BlockPos pos, Long2ObjectMap<BlockState> availableBlocks) {
        if (current.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            availableBlocks.remove(ChunkHelper.calcRelativeIndex(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            return null;
        }
        DoorRagdoll ragdoll = new DoorRagdoll();
        ragdoll.hitboxScale = this.hitboxScale;
        ragdoll.collision = this.collision;
        ragdoll.hookedEntity = this.createPart(mod, ragdoll, current, pos.m_123342_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.createPart(mod, ragdoll, (BlockState)current.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), pos.m_123342_(), pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        ragdoll.addConnection(1, 0, true);
        ragdoll.stiffness = this.stiffness;
        ragdoll.damping = this.damping;
        ragdoll.linkedPhysics = this.linkedPhysics;
        Vector3d hookPos = new Vector3d();
        hookPos.y = 0.5;
        Direction direction = (Direction)current.m_61143_((Property)DoorBlock.f_52726_);
        boolean open = (Boolean)current.m_61143_((Property)DoorBlock.f_52727_) == false;
        boolean hinge = current.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
        Direction result = null;
        switch (direction) {
            default: {
                result = open ? Direction.EAST : (hinge ? Direction.NORTH : Direction.SOUTH);
                break;
            }
            case SOUTH: {
                result = open ? Direction.SOUTH : (hinge ? Direction.EAST : Direction.WEST);
                break;
            }
            case WEST: {
                result = open ? Direction.WEST : (hinge ? Direction.SOUTH : Direction.NORTH);
                break;
            }
            case NORTH: {
                result = open ? Direction.NORTH : (hinge ? Direction.WEST : Direction.EAST);
            }
        }
        switch (result) {
            default: {
                hookPos.z = 0.90625;
                hookPos.x = hinge ? 0.90625 : 0.09375;
                break;
            }
            case SOUTH: {
                hookPos.z = 0.09375;
                hookPos.x = hinge ? 0.09375 : 0.90625;
                break;
            }
            case WEST: {
                hookPos.x = 0.90625;
                hookPos.z = hinge ? 0.09375 : 0.90625;
                break;
            }
            case EAST: {
                hookPos.x = 0.09375;
                double d = hookPos.z = hinge ? 0.90625 : 0.09375;
            }
        }
        if (!open) {
            switch (result) {
                default: {
                    hookPos.x = 1.0 - hookPos.x;
                    break;
                }
                case SOUTH: {
                    hookPos.x = 1.0 - hookPos.x;
                    break;
                }
                case WEST: {
                    hookPos.z = 1.0 - hookPos.z;
                    break;
                }
                case EAST: {
                    hookPos.z = 1.0 - hookPos.z;
                }
            }
        }
        Vector3d offset = ragdoll.hookedEntity.models.get((int)0).mesh.offset;
        hookPos.x -= offset.x % 1.0;
        hookPos.y -= offset.y % 1.0;
        hookPos.z -= offset.z % 1.0;
        ragdoll.hook = hookPos;
        availableBlocks.remove(ChunkHelper.calcRelativeIndex(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        return ragdoll;
    }

    @Override
    public boolean isValid(BlockState state) {
        return state.m_61138_((Property)DoorBlock.f_52726_) && state.m_61138_((Property)DoorBlock.f_52727_) && state.m_61138_((Property)DoorBlock.f_52728_) && state.m_61138_((Property)DoorBlock.f_52730_);
    }

    @Override
    public Block defaultBlock() {
        return Blocks.f_50154_;
    }
}

