/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.org.joml.Vector3i;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletSimulationData;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WorldConstraint
implements VerletConstraint {
    public static final double CONTACT_FRICTION = 0.6;
    private Entity entity;
    private Level level;
    private Map<Vector3i, List<AABB>> bodies;
    private Vector3i tmpInt = new Vector3i();
    private VerletHelper helper = new VerletHelper();
    private float preferUpMovement;

    public WorldConstraint(Level level, float preferUpMovement) {
        this.preferUpMovement = preferUpMovement;
        this.level = level;
    }

    public WorldConstraint(Entity entity, float preferUpMovement) {
        this.preferUpMovement = preferUpMovement;
        this.entity = entity;
    }

    public WorldConstraint(Entity entity) {
        this(entity, 0.7f);
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        this.checkVerletCollisions(simulation);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        VerletSimulationData data = simulation.getData();
        if (data.points.size() == 0) {
            return false;
        }
        if (this.entity != null) {
            this.level = this.entity.m_20193_();
        }
        PhysicsWorld physics = PhysicsMod.getInstance(this.level).getPhysicsWorld();
        VerletPoint start = data.points.get(0);
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(start.position.x + data.offset.x, start.position.y + data.offset.y, start.position.z + data.offset.z);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(start.position.x + data.offset.x, start.position.y + data.offset.y, start.position.z + data.offset.z);
        for (int i = 0; i < data.points.size(); ++i) {
            VerletPoint point = data.points.get(i);
            int x = Mth.m_14107_((double)(point.position.x + data.offset.x));
            int y = Mth.m_14107_((double)(point.position.y + data.offset.y));
            int z = Mth.m_14107_((double)(point.position.z + data.offset.z));
            if (x < min.m_123341_()) {
                min.m_142451_(x);
            } else if (x > max.m_123341_()) {
                max.m_142451_(x);
            }
            if (y < min.m_123342_()) {
                min.m_142448_(y);
            } else if (y > max.m_123342_()) {
                max.m_142448_(y);
            }
            if (z < min.m_123343_()) {
                min.m_142443_(z);
                continue;
            }
            if (z <= max.m_123343_()) continue;
            max.m_142443_(z);
        }
        this.bodies = new Object2ObjectOpenHashMap();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(0, 0, 0);
        if (max.m_123341_() - min.m_123341_() > 10) {
            return false;
        }
        if (max.m_123342_() - min.m_123342_() > 10) {
            return false;
        }
        if (max.m_123343_() - min.m_123343_() > 10) {
            return false;
        }
        for (int x = min.m_123341_() - 1; x <= max.m_123341_() + 1; ++x) {
            for (int y = min.m_123342_() - 1; y <= max.m_123342_() + 1; ++y) {
                for (int z = min.m_123343_() - 1; z <= max.m_123343_() + 1; ++z) {
                    VoxelShape voxelShape;
                    currentPos.m_122178_(x, y, z);
                    BlockState state = physics.getWorld().m_8055_((BlockPos)currentPos);
                    if (state.m_60734_() == Blocks.f_50016_ || (voxelShape = state.m_60812_((BlockGetter)physics.getWorld(), (BlockPos)currentPos)).m_83281_() || VineHelper.getSetting(state) != null) continue;
                    for (AABB aabb : voxelShape.m_83299_()) {
                        this.addToSuroundings(new AABB(aabb.f_82288_ + (double)x - data.offset.x, aabb.f_82289_ + (double)y - data.offset.y, aabb.f_82290_ + (double)z - data.offset.z, aabb.f_82291_ + (double)x - data.offset.x, aabb.f_82292_ + (double)y - data.offset.y, aabb.f_82293_ + (double)z - data.offset.z), x, y, z, this.bodies);
                    }
                }
            }
        }
        return false;
    }

    private void addToSuroundings(AABB box, int x, int y, int z, Map<Vector3i, List<AABB>> bodies) {
        for (int xi = -1; xi <= 1; ++xi) {
            for (int yi = -1; yi <= 1; ++yi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    ObjectArrayList boxes = bodies.get(this.tmpInt.set(x + xi, y + yi, z + zi));
                    if (boxes == null) {
                        boxes = new ObjectArrayList();
                        bodies.put(new Vector3i(this.tmpInt), (List<AABB>)boxes);
                    }
                    boxes.add((AABB)box);
                }
            }
        }
    }

    private void checkVerletCollisions(VerletSimulation simulation) {
        VerletSimulationData data = simulation.getData();
        double enlarge = 0.05;
        block0: for (VerletPoint point : data.points) {
            int z;
            int y;
            int x;
            List<AABB> boxes;
            if (point.locked || (boxes = this.bodies.get(this.tmpInt.set(x = Mth.m_14107_((double)(point.position.x + data.offset.x)), y = Mth.m_14107_((double)(point.position.y + data.offset.y)), z = Mth.m_14107_((double)(point.position.z + data.offset.z))))) == null) continue;
            for (int i = 0; i < boxes.size(); ++i) {
                AABB box = boxes.get(i);
                if (!this.helper.movePointOutOfBox(point.position, this.preferUpMovement, (double)((float)(box.f_82288_ - enlarge)), (double)((float)(box.f_82289_ - enlarge)), (double)((float)(box.f_82290_ - enlarge)), (double)((float)(box.f_82291_ + enlarge)), (double)((float)(box.f_82292_ + enlarge)), (double)((float)(box.f_82293_ + enlarge)))) continue;
                point.friction = 0.6;
                continue block0;
            }
        }
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

