/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.SimplePoolVector3d;
import net.diebuddies.org.joml.Math;
import net.diebuddies.org.joml.Vector2d;
import net.diebuddies.org.joml.Vector2f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector4f;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletTriangle;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class RenderConstraint
implements VerletConstraint {
    private static final Vector3d UP_VECTOR = new Vector3d(0.0, 1.0, 0.0);
    private static Vector3d tmp1 = new Vector3d();
    private static Vector3d tmp2 = new Vector3d();
    private static Vector3d tmp3 = new Vector3d();
    private static SimplePoolVector3d vectorPool;
    private static ObjectArrayList<Vector3d> vertices;
    private static IntArrayList lineData;
    private static IntArrayList indices;

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double renderPercent, VerletSimulation simulation) {
        int i;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        int brightness = simulation.brightness;
        List<VerletQuad> quads = simulation.getQuads();
        List<VerletTriangle> triangles = simulation.getTriangles();
        List<VerletLine> lines = simulation.getLines();
        List<VerletPoint> points = simulation.getPoints();
        for (i = 0; i < points.size(); ++i) {
            points.get(i).updateRenderPosition(renderPercent);
        }
        if (simulation.getQuads().size() > 0 || simulation.getTriangles().size() > 0) {
            if (StarterClient.iris && Iris.isExtending() || StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
                for (i = 0; i < quads.size(); ++i) {
                    VerletQuad quad = quads.get(i);
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.point1.bufferNormal, brightness, quad.point1.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.point2.bufferNormal, brightness, quad.point2.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.point3.bufferNormal, brightness, quad.point3.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.point4.bufferNormal, brightness, quad.point4.rgba);
                        continue;
                    }
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.bufferNormal, brightness, quad.point1.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.bufferNormal, brightness, quad.point2.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.bufferNormal, brightness, quad.point3.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.bufferNormal, brightness, quad.point4.rgba);
                }
                for (i = 0; i < triangles.size(); ++i) {
                    VerletTriangle triangle = triangles.get(i);
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point1.renderPosition, triangle.point1.uv, triangle.point1.bufferNormal, brightness, triangle.point1.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point2.renderPosition, triangle.point2.uv, triangle.point2.bufferNormal, brightness, triangle.point2.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point3.renderPosition, triangle.point3.uv, triangle.point3.bufferNormal, brightness, triangle.point3.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point3.renderPosition, triangle.point3.uv, triangle.point3.bufferNormal, brightness, triangle.point3.rgba);
                        continue;
                    }
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point1.renderPosition, triangle.point1.uv, triangle.bufferNormal, brightness, triangle.point1.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point2.renderPosition, triangle.point2.uv, triangle.bufferNormal, brightness, triangle.point2.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point3.renderPosition, triangle.point3.uv, triangle.bufferNormal, brightness, triangle.point3.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point3.renderPosition, triangle.point3.uv, triangle.bufferNormal, brightness, triangle.point3.rgba);
                }
                tesselator.m_85914_();
            } else {
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
                for (i = 0; i < quads.size(); ++i) {
                    VerletQuad quad = quads.get(i);
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.point4.bufferNormal, brightness, quad.point4.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.point3.bufferNormal, brightness, quad.point3.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.point2.bufferNormal, brightness, quad.point2.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.point1.bufferNormal, brightness, quad.point1.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.point4.bufferNormal, brightness, quad.point4.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.point2.bufferNormal, brightness, quad.point2.rgba);
                        continue;
                    }
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.bufferNormal, brightness, quad.point4.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.bufferNormal, brightness, quad.point3.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.bufferNormal, brightness, quad.point2.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.bufferNormal, brightness, quad.point1.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.bufferNormal, brightness, quad.point4.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.bufferNormal, brightness, quad.point2.rgba);
                }
                for (i = 0; i < triangles.size(); ++i) {
                    VerletTriangle triangle = triangles.get(i);
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point3.renderPosition, triangle.point3.uv, triangle.point3.bufferNormal, brightness, triangle.point3.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point2.renderPosition, triangle.point2.uv, triangle.point2.bufferNormal, brightness, triangle.point2.rgba);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point1.renderPosition, triangle.point1.uv, triangle.point1.bufferNormal, brightness, triangle.point1.rgba);
                        continue;
                    }
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point3.renderPosition, triangle.point3.uv, triangle.bufferNormal, brightness, triangle.point3.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point2.renderPosition, triangle.point2.uv, triangle.bufferNormal, brightness, triangle.point2.rgba);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, triangle.point1.renderPosition, triangle.point1.uv, triangle.bufferNormal, brightness, triangle.point1.rgba);
                }
                tesselator.m_85914_();
            }
        }
        if (lines.size() > 0) {
            if (vectorPool == null) {
                vectorPool = new SimplePoolVector3d(128);
            }
            this.renderFromFrenetFrame(tesselator, bufferbuilder, lines, this.circleShape(5), brightness, 0.02, renderPercent);
            vectorPool.reset();
        }
    }

    private void debugRenderClothNormals(VerletSimulation simulation) {
        for (VerletPoint point : simulation.getPoints()) {
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            float length = 0.175f;
            Vector3d p = point.renderPosition;
            Vector3d normal = point.bufferNormal;
            bufferbuilder.m_5483_((double)((float)p.x), (double)((float)p.y), (double)((float)p.z)).m_7421_(point.uv.x, point.uv.y).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)((float)p.x) + normal.x * (double)length, (double)((float)p.y) + normal.y * (double)length, (double)((float)p.z) + normal.z * (double)length).m_7421_(point.uv.x, point.uv.y).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5752_();
            tessellator.m_85914_();
        }
    }

    private void renderFromFrenetFrame(Tesselator tesselator, BufferBuilder bufferbuilder, List<VerletLine> spline, List<Vector2d> shape, int brightness, double radius, double renderPercent) {
        int j;
        vertices.clear();
        lineData.clear();
        indices.clear();
        int vertexSegments = shape.size();
        int size = spline.size();
        Vector3d tangent = vectorPool.get();
        Vector3d binormal = vectorPool.get();
        Vector3d normal = vectorPool.get();
        for (int i = 0; i <= size; ++i) {
            Vector3d nextPoint;
            Vector3d point;
            VerletLine line = spline.get(Math.min(i, size - 1));
            if (size == i) {
                point = tmp1.set(line.point1.renderPosition);
                nextPoint = tmp2.set(line.point2.renderPosition);
                Vector3d dir = nextPoint.sub(point, tmp3);
                point.set(nextPoint);
                nextPoint.add(dir);
            } else {
                point = tmp1.set(line.point1.renderPosition);
                nextPoint = tmp2.set(line.point2.renderPosition);
            }
            this.normalize(nextPoint.sub(point, tangent));
            this.normalize(tangent.cross(UP_VECTOR, binormal));
            this.normalize(binormal.cross(tangent, normal));
            for (j = vertexSegments - 1; j >= 0; --j) {
                Vector2d shapePos = shape.get(j);
                vertices.add((Object)vectorPool.get(point.x + (normal.x * shapePos.x + binormal.x * shapePos.y) * radius, point.y + (normal.y * shapePos.x + binormal.y * shapePos.y) * radius, point.z + (normal.z * shapePos.x + binormal.z * shapePos.y) * radius));
                lineData.add(i);
            }
        }
        int indexOffset = 0;
        int iterations = vertices.size() / vertexSegments - 1;
        boolean closeEnds = true;
        for (int i = 0; i < iterations; ++i) {
            for (j = 0; j < vertexSegments; ++j) {
                int index1 = i * vertexSegments + j + indexOffset;
                int index2 = i * vertexSegments + (j + 1) % vertexSegments + indexOffset;
                indices.add(index1);
                indices.add(index1 + vertexSegments);
                indices.add(index2);
                indices.add(index2);
                indices.add(index1 + vertexSegments);
                indices.add(index2 + vertexSegments);
            }
        }
        if (closeEnds) {
            VerletLine startLine = spline.get(0);
            VerletLine endLine = spline.get(spline.size() - 1);
            Vector3d start = startLine.point1.renderPosition;
            Vector3d end = endLine.point2.renderPosition;
            if (vertices.size() % shape.size() == 0) {
                vertices.add((Object)vectorPool.get(start.x, start.y, start.z));
                vertices.add((Object)vectorPool.get(end.x, end.y, end.z));
                lineData.add(0);
                lineData.add(spline.size() - 1);
            } else {
                ((Vector3d)vertices.get(vertices.size() - 2)).set(start.x, start.y, start.z);
                ((Vector3d)vertices.get(vertices.size() - 1)).set(end.x, end.y, end.z);
                lineData.add(0);
                lineData.add(spline.size() - 1);
            }
            int indexStart = vertices.size() - 2;
            int indexEnd = vertices.size() - 1;
            int startEnd = vertices.size() - 2 - vertexSegments;
            for (int j2 = 0; j2 < vertexSegments; ++j2) {
                indices.add(j2);
                indices.add((j2 + 1) % vertexSegments);
                indices.add(indexStart);
                indices.add(startEnd + j2);
                indices.add(indexEnd);
                indices.add(startEnd + (j2 + 1) % vertexSegments);
            }
        }
        if (StarterClient.iris && Iris.isExtending() || StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        } else {
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
        }
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.getInt(i);
            Vector3d position = (Vector3d)vertices.get(index);
            index = indices.getInt(i / 3 * 3);
            int lineIndex = lineData.getInt(index);
            VerletLine line = spline.get(Math.min(lineIndex, size - 1));
            VerletPoint point = lineIndex == size ? line.point2 : line.point1;
            this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, position, point.uv, point.bufferNormal, brightness, point.rgba);
            if (!StarterClient.iris || !Iris.isExtending() || i % 3 != 0) continue;
            this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, position, point.uv, point.bufferNormal, brightness, point.rgba);
        }
        tesselator.m_85914_();
    }

    private void bufferVertex(VertexConsumer bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, Vector4f rgba) {
        bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, rgba.x, rgba.y, rgba.z, rgba.w, uv.x, uv.y, OverlayTexture.f_118083_, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
    }

    private void normalize(Vector3d v) {
        double lengthSquared = v.x * v.x + v.y * v.y + v.z * v.z;
        if (lengthSquared != 0.0) {
            double invLength = Math.invsqrt(lengthSquared);
            v.x *= invLength;
            v.y *= invLength;
            v.z *= invLength;
        }
    }

    public List<Vector2d> circleShape(int segments) {
        ObjectArrayList circle = new ObjectArrayList();
        for (int i = 0; i < segments; ++i) {
            double angle = java.lang.Math.PI * 2 * (double)i / (double)segments;
            Vector2d circlePoint = new Vector2d(Math.cos(angle), Math.sin(angle));
            circle.add(circlePoint);
        }
        return circle;
    }

    public List<Vector2d> starShape(double spikeRadius, int segments) {
        ObjectArrayList circle = new ObjectArrayList();
        double radius = 1.0 - spikeRadius;
        for (int i = 0; i < segments; ++i) {
            radius = i % 2 == 0 ? 1.0 + spikeRadius : 1.0 - spikeRadius;
            double angle = java.lang.Math.PI * 2 * (double)i / (double)segments;
            Vector2d circlePoint = new Vector2d(Math.cos(angle) * radius, Math.sin(angle) * radius);
            circle.add(circlePoint);
        }
        return circle;
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    static {
        vertices = new ObjectArrayList();
        lineData = new IntArrayList();
        indices = new IntArrayList();
    }
}

