/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Quaternionf;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;

public class OceanPhysicsDisplacementConstraint
extends RenderConstraint {
    private Entity entity;
    private Matrix4d gravityTransformation;
    private Vector3d gravity;
    private Quaternionf tmpRot = new Quaternionf();

    public OceanPhysicsDisplacementConstraint(Entity entity) {
        this.entity = entity;
        this.gravityTransformation = new Matrix4d();
        this.gravity = new Vector3d();
    }

    @Override
    public void render(PoseStack matrixStack, double renderPercent, VerletSimulation simulation) {
        super.render(matrixStack, renderPercent, simulation);
    }

    private void calculateGravityTransformation(double renderPercent) {
        float actualYRot = 0.0f;
        Entity vehicle = this.entity.m_20202_();
        EntityOcean entityOcean = (EntityOcean)this.entity;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            actualYRot = Mth.m_14189_((float)((float)renderPercent), (float)living.f_20884_, (float)living.f_20883_);
        } else {
            actualYRot = this.entity.m_5675_((float)renderPercent);
        }
        float currentYRot = (float)(-Math.toRadians(actualYRot - (float)Math.PI));
        double forwardZ = Math.cos(currentYRot);
        double forwardX = Math.sin(currentYRot);
        double leftX = forwardZ;
        double leftZ = -forwardX;
        double roll = entityOcean.getPhysicsRoll((float)renderPercent);
        double pitch = entityOcean.getPhysicsPitch((float)renderPercent);
        float diffRot = 0.0f;
        if (vehicle != null && vehicle instanceof Boat) {
            diffRot = vehicle.m_5675_((float)renderPercent) - actualYRot;
        }
        this.gravityTransformation.identity();
        this.gravityTransformation.rotate(this.tmpRot.rotationY(-diffRot));
        this.gravityTransformation.rotate(this.tmpRot.rotationAxis((float)(-roll), (float)forwardX, 0.0f, (float)forwardZ));
        this.gravityTransformation.rotate(this.tmpRot.rotationAxis((float)pitch, (float)leftX, 0.0f, (float)leftZ));
        this.gravityTransformation.invert();
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        super.updateBefore(delta, simulation);
        this.gravity.set(simulation.getGravity());
        this.gravityTransformation.transformDirection(simulation.getGravity());
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        super.updateAfter(delta, simulation);
        simulation.setGravity(this.gravity);
    }
}

