/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.diebuddies.bridge.ReflectionsForge;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Matrix4f;
import net.diebuddies.org.joml.Quaternionf;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.verlet.ModelPartParent;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;

public class ModelPartConstraint
implements VerletConstraint {
    private LivingEntity entity;
    private Model model;
    public boolean changeInstantly;
    private boolean lastCrouch;
    private VerletHelper helper = new VerletHelper();
    private List<ModelCube> modelCubes;
    private ModelCube attachedTo;
    private double initialFriction;
    private PoseStack modelMatrix = new PoseStack();
    private PoseStack headMatrix = new PoseStack();
    private CustomTransformation customTransformation;
    private boolean isHead;
    private Vector3d invPoint = new Vector3d();
    private Matrix4d transform = new Matrix4d();
    private Matrix4d invTransform = new Matrix4d();
    private Vector3d tmp = new Vector3d();
    private Matrix4d partTransformation = new Matrix4d();
    private Matrix4d oldPartTransformation;
    private Matrix4d currentPartTransformation = new Matrix4d();
    private Matrix4d tmpMat = new Matrix4d();
    private static Matrix4d elytraFix = new Matrix4d();
    private Quaternionf tmpQuat = new Quaternionf();

    public ModelPartConstraint(VerletSimulation simulation, Set<String> ignoreParts, @Nullable LivingEntity entity, String attachedToName, Model model) {
        this.entity = entity;
        this.model = model;
        this.lastCrouch = entity == null ? false : entity.m_6047_();
        this.initialFriction = simulation.getFriction();
        this.modelCubes = new ObjectArrayList();
        for (ModelPart part : ClothConstants.getModelParts(model)) {
            String name = ((ModelPartParent)part).physicsmod$getName();
            if (attachedToName.equals(name)) {
                this.attachedTo = new ModelCube();
                this.attachedTo.part = part;
                this.attachedTo.pose = part.m_171308_();
            }
            if (ignoreParts.contains(name)) continue;
            ModelCube modelCube = new ModelCube();
            modelCube.part = part;
            this.modelCubes.add(modelCube);
        }
        this.isHead = entity == Minecraft.m_91087_().f_91074_;
    }

    private void storePoses() {
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            ModelCube modelCube = this.modelCubes.get(i);
            modelCube.pose = modelCube.part.m_171308_();
            modelCube.updateHitbox();
        }
        this.attachedTo.pose = this.attachedTo.part.m_171308_();
        this.attachedTo.updateHitbox();
    }

    public static ModelPart getPart(Model model, String name) {
        for (ModelPart part : ClothConstants.getModelParts(model)) {
            if (!name.equals(((ModelPartParent)part).physicsmod$getName())) continue;
            return part;
        }
        return null;
    }

    public static boolean exists(EntityModel<LivingEntity> model, String name) {
        for (ModelPart part : ClothConstants.getModelParts(model)) {
            if (!name.equals(((ModelPartParent)part).physicsmod$getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        if (this.entity != null) {
            this.changeInstantly = this.lastCrouch != this.entity.m_6047_();
            this.lastCrouch = this.entity.m_6047_();
        }
        this.modelMatrix.m_85836_();
        if (this.entity != null) {
            ModelPartConstraint.entityTransformation(this.modelMatrix, simulation, this.entity, this.model, 1.0f);
        } else if (this.customTransformation != null) {
            this.customTransformation.doTransformation(this.modelMatrix);
        }
        this.storePoses();
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            ModelCube modelCube = this.modelCubes.get(i);
            StarterClient.setMatrix(modelCube.transform, this.modelMatrix.m_85850_().m_85861_());
            this.translateAndRotate(modelCube.transform, modelCube.pose);
        }
        this.modelPartTransformation(this.modelMatrix);
        if (this.oldPartTransformation != null) {
            this.oldPartTransformation.set(this.partTransformation);
        }
        StarterClient.setMatrix(this.partTransformation, this.modelMatrix.m_85850_().m_85861_());
        if (this.oldPartTransformation == null) {
            this.oldPartTransformation = new Matrix4d();
            this.oldPartTransformation.set(this.partTransformation);
        }
        simulation.setTransformation(this.partTransformation);
        this.modelMatrix.m_85849_();
        if (this.entity != null) {
            if (this.entity.m_5842_()) {
                OceanWorld oceanWorld = PhysicsMod.getInstance(this.entity.f_19853_).getPhysicsWorld().getOceanWorld();
                Vector3d waveForce = oceanWorld.calculateWaveForce(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                Vector3d gravity = simulation.getGravity();
                gravity.set(ConfigClient.getBuoyancy(this.entity.m_20193_().m_46472_().m_135782_()));
                if (waveForce != null) {
                    double forceStrength = 10.0;
                    gravity.add(waveForce.x * forceStrength, 0.0, waveForce.z * forceStrength);
                }
                simulation.setFriction(0.7f);
            } else {
                simulation.getGravity().set(ConfigClient.getGravity(this.entity.m_20193_().m_46472_().m_135782_()));
                simulation.setFriction(this.initialFriction);
            }
        }
        return this.changeInstantly;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            this.modelCubes.get(i).updateTransformation();
        }
    }

    private void updateFixedPoints(VerletSimulation simulation, Matrix4d currentPartTransformation) {
        List<VerletPoint> points = simulation.getPoints();
        double lengthDiff = 1000.0;
        ColladaMesh mesh = simulation.cloth.mesh;
        int size = mesh.positions.size();
        List<Vector3f> positions = mesh.positions;
        for (int i = 0; i < points.size() && i < size; ++i) {
            Vector3f pos;
            VerletPoint point = points.get(i);
            if (point.locked) {
                pos = positions.get(i);
                this.tmp.set(pos.x, pos.y, pos.z);
                currentPartTransformation.transformPosition(this.tmp);
                if (this.tmp.distanceSquared(point.position) > lengthDiff) {
                    simulation.destroyed = true;
                }
                point.position.set(this.tmp);
                if (!this.changeInstantly) continue;
                point.prevPosition.set(point.position);
                continue;
            }
            if (point.softRestriction == null) continue;
            pos = positions.get(i);
            this.tmp.set(pos.x, pos.y, pos.z);
            currentPartTransformation.transformPosition(this.tmp);
            point.softRestriction.set(this.tmp);
        }
    }

    private void updateFixedPoints(double percent, VerletSimulation simulation) {
        this.updateFixedPoints(simulation, MatrixUtil.slerp(this.oldPartTransformation, this.partTransformation, percent, this.currentPartTransformation));
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
        if (this.isHead) {
            this.modelMatrix.m_85836_();
            if (this.entity != null) {
                ModelPartConstraint.entityTransformation(this.modelMatrix, simulation, this.entity, null, (float)delta);
            } else if (this.customTransformation != null) {
                this.customTransformation.doTransformation(this.modelMatrix);
            }
            StarterClient.setMatrix(this.attachedTo.transform, this.modelMatrix.m_85850_().m_85861_());
            this.attachedTo.pose = this.attachedTo.part.m_171308_();
            this.translateAndRotate(this.attachedTo.transform, this.attachedTo.pose);
            this.currentPartTransformation.set(this.attachedTo.transform);
            List<VerletPoint> points = simulation.getPoints();
            ColladaMesh mesh = simulation.cloth.mesh;
            int size = mesh.positions.size();
            List<Vector3f> positions = mesh.positions;
            for (int i = 0; i < points.size() && i < size; ++i) {
                VerletPoint point = points.get(i);
                if (!point.locked) continue;
                Vector3f pos = positions.get(i);
                this.tmp.set(pos.x, pos.y, pos.z);
                this.currentPartTransformation.transformPosition(this.tmp);
                point.bufferPosition.set(this.tmp);
                point.bufferPrevPosition.set(this.tmp);
            }
            this.modelMatrix.m_85849_();
        }
    }

    @Override
    public void preSubStep(double percent, VerletSimulation simulation) {
        this.updateFixedPoints(percent, simulation);
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        this.doCollisionCheck(percent, simulation);
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    public void modelPartTransformation(PoseStack modelMatrix) {
        StarterClient.setMatrix(this.tmpMat, modelMatrix.m_85850_().m_85861_());
        this.translateAndRotate(this.tmpMat, this.attachedTo.pose);
        StarterClient.setMojangMatrix(modelMatrix.m_85850_().m_85861_(), this.tmpMat);
    }

    public static void modelPartTransformation(ModelPart part, PoseStack modelMatrix) {
        part.m_104299_(modelMatrix);
    }

    public static void entityTransformation(PoseStack modelMatrix, VerletSimulation simulation, LivingEntity entity, Model model, float tickDelta) {
        Direction direction;
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        double px = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_());
        double py = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_());
        double pz = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_());
        if (simulation.getOffset() != null) {
            px -= simulation.getOffset().x;
            py -= simulation.getOffset().y;
            pz -= simulation.getOffset().z;
        } else {
            px = 0.0;
            py = 0.0;
            pz = 0.0;
        }
        Vec3 positionOffset = renderer.m_7860_((Entity)entity, tickDelta);
        modelMatrix.m_85837_(positionOffset.f_82479_ + px, positionOffset.f_82480_ + py, positionOffset.f_82481_ + pz);
        float yaw = Mth.m_14189_((float)tickDelta, (float)entity.f_20884_, (float)entity.f_20883_);
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float eyeHeight = entity.m_20236_(Pose.STANDING) - 0.1f;
            modelMatrix.m_85837_((double)((float)(-direction.m_122429_()) * eyeHeight), 0.0, (double)((float)(-direction.m_122431_()) * eyeHeight));
        }
        StarterClient.setMatrix(elytraFix, modelMatrix.m_85850_().m_85861_());
        try {
            ReflectionsForge.setupRotations.invoke((Object)renderer, entity, modelMatrix, Float.valueOf(tickDelta), Float.valueOf(yaw), Float.valueOf(tickDelta));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (!Float.isFinite(modelMatrix.m_85850_().m_85861_().m_162226_())) {
            StarterClient.setMojangMatrix(modelMatrix.m_85850_().m_85861_(), elytraFix);
        }
        modelMatrix.m_85841_(-1.0f, -1.0f, 1.0f);
        modelMatrix.m_85841_(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.m_85837_(0.0, (double)-1.501f, 0.0);
        if (model != null) {
            float bodyRot = Mth.m_14189_((float)tickDelta, (float)entity.f_20884_, (float)entity.f_20883_);
            float headRot = Mth.m_14189_((float)tickDelta, (float)entity.f_20886_, (float)entity.f_20885_);
            float headBodyDiff = headRot - bodyRot;
            if (entity.m_20159_() && entity.m_20202_() instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)entity.m_20202_();
                bodyRot = Mth.m_14189_((float)tickDelta, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
                headBodyDiff = headRot - bodyRot;
                float diffWrapped = Mth.m_14177_((float)headBodyDiff);
                if (diffWrapped < -85.0f) {
                    diffWrapped = -85.0f;
                }
                if (diffWrapped >= 85.0f) {
                    diffWrapped = 85.0f;
                }
                bodyRot = headRot - diffWrapped;
                if (diffWrapped * diffWrapped > 2500.0f) {
                    bodyRot += diffWrapped * 0.2f;
                }
                headBodyDiff = headRot - bodyRot;
            }
            float xRot = Mth.m_14179_((float)tickDelta, (float)entity.f_19860_, (float)entity.m_146909_());
            if (LivingEntityRenderer.m_194453_((LivingEntity)entity)) {
                xRot *= -1.0f;
                headBodyDiff *= -1.0f;
            }
            float bob = (float)entity.f_19797_ + tickDelta;
            float animationSpeed = 0.0f;
            float animationPosition = 0.0f;
            if (!entity.m_20159_() && entity.m_6084_()) {
                animationSpeed = Mth.m_14179_((float)tickDelta, (float)entity.f_20923_, (float)entity.f_20924_);
                animationPosition = entity.f_20925_ - entity.f_20924_ * (1.0f - tickDelta);
                if (entity.m_6162_()) {
                    animationPosition *= 3.0f;
                }
                if (animationSpeed > 1.0f) {
                    animationSpeed = 1.0f;
                }
            }
            if (model instanceof EntityModel) {
                EntityModel entityModel = (EntityModel)model;
                entityModel.m_6839_((Entity)entity, animationPosition, animationSpeed, tickDelta);
                entityModel.m_6973_((Entity)entity, animationPosition, animationSpeed, bob, headBodyDiff, xRot);
            }
        }
    }

    public static void entityTransformation(PoseStack modelMatrix, LivingEntity entity, float tickDelta) {
        Direction direction;
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        Vec3 positionOffset = renderer.m_7860_((Entity)entity, tickDelta);
        modelMatrix.m_85837_(positionOffset.f_82479_, positionOffset.f_82480_, positionOffset.f_82481_);
        float yaw = Mth.m_14189_((float)tickDelta, (float)entity.f_20884_, (float)entity.f_20883_);
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float eyeHeight = entity.m_20236_(Pose.STANDING) - 0.1f;
            modelMatrix.m_85837_((double)((float)(-direction.m_122429_()) * eyeHeight), 0.0, (double)((float)(-direction.m_122431_()) * eyeHeight));
        }
        try {
            ReflectionsForge.setupRotations.invoke((Object)renderer, entity, modelMatrix, Float.valueOf(tickDelta), Float.valueOf(yaw), Float.valueOf(tickDelta));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        modelMatrix.m_85841_(-1.0f, -1.0f, 1.0f);
        modelMatrix.m_85841_(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.m_85837_(0.0, (double)-1.501f, 0.0);
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            ModelCube modelCube = this.modelCubes.get(i);
            ModelPart part = modelCube.part;
            if (part == null || part.f_104212_.isEmpty()) continue;
            modelCube.getTransform(percent, this.transform);
            this.transform.invert(this.invTransform);
            float enlarge = 0.075f;
            float minX = modelCube.minX - enlarge;
            float minY = modelCube.minY - enlarge;
            float minZ = modelCube.minZ - enlarge;
            float maxX = modelCube.maxX + enlarge;
            float maxY = modelCube.maxY + enlarge;
            float maxZ = modelCube.maxZ + enlarge;
            List<VerletPoint> points = simulation.getPoints();
            for (int j = 0; j < points.size(); ++j) {
                VerletPoint point = points.get(j);
                if (point.locked) continue;
                this.invTransform.transformPosition(this.invPoint.set(point.position));
                if (!this.helper.movePointOutOfBox(this.invPoint, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                point.position.set(this.transform.transformPosition(this.invPoint));
                if (!this.changeInstantly) continue;
                point.prevPosition.set(point.position);
            }
        }
    }

    public void translateAndRotate(Matrix4d transform, PartPose pose) {
        transform.translate(pose.f_171405_ / 16.0f, pose.f_171406_ / 16.0f, pose.f_171407_ / 16.0f);
        if (pose.f_171410_ != 0.0f) {
            transform.rotate(this.tmpQuat.rotationZ(pose.f_171410_));
        }
        if (pose.f_171409_ != 0.0f) {
            transform.rotate(this.tmpQuat.rotationY(pose.f_171409_));
        }
        if (pose.f_171408_ != 0.0f) {
            transform.rotate(this.tmpQuat.rotationX(pose.f_171408_));
        }
    }

    public void translateAndRotate(Matrix4f transform, PartPose pose) {
        transform.translate(pose.f_171405_ / 16.0f, pose.f_171406_ / 16.0f, pose.f_171407_ / 16.0f);
        if (pose.f_171410_ != 0.0f) {
            transform.rotate(this.tmpQuat.rotationZ(pose.f_171410_));
        }
        if (pose.f_171409_ != 0.0f) {
            transform.rotate(this.tmpQuat.rotationY(pose.f_171409_));
        }
        if (pose.f_171408_ != 0.0f) {
            transform.rotate(this.tmpQuat.rotationX(pose.f_171408_));
        }
    }

    public ModelCube getAttachedToPart() {
        return this.attachedTo;
    }

    public void setCustomTransformation(CustomTransformation customTransformation) {
        this.customTransformation = customTransformation;
    }

    public Matrix4d getCurrentPartTransformation(double percent) {
        if (this.changeInstantly) {
            return this.tmpMat.set(this.partTransformation);
        }
        return MatrixUtil.slerp(this.oldPartTransformation, this.partTransformation, percent, this.tmpMat);
    }

    public static interface CustomTransformation {
        public void doTransformation(PoseStack var1);
    }
}

