/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Quaterniond;
import net.diebuddies.org.joml.Quaterniondc;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3dc;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;

public class ModelCube {
    public PartPose pose;
    public ModelPart part;
    public Matrix4d transform;
    public Vector3d translation;
    public Vector3d lastTranslation;
    public Vector3d currentTranslation;
    public Vector3d scale;
    public Vector3d lastScale;
    public Vector3d currentScale;
    public Quaterniond rotation;
    public Quaterniond lastRotation;
    public Quaterniond currentRotation;
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;
    public boolean first = true;

    public ModelCube(ModelPart part) {
        this.part = part;
        this.transform = new Matrix4d();
        this.translation = new Vector3d();
        this.lastTranslation = new Vector3d();
        this.currentTranslation = new Vector3d();
        this.scale = new Vector3d();
        this.lastScale = new Vector3d();
        this.currentScale = new Vector3d();
        this.rotation = new Quaterniond();
        this.lastRotation = new Quaterniond();
        this.currentRotation = new Quaterniond();
    }

    public ModelCube() {
        this(null);
    }

    public void updateTransformation() {
        this.lastTranslation.set(this.translation);
        this.lastScale.set(this.scale);
        this.lastRotation.set(this.rotation);
        this.transform.getTranslation(this.translation);
        this.transform.getScale(this.scale);
        this.transform.getUnnormalizedRotation(this.rotation);
        if (this.first) {
            this.lastTranslation.set(this.translation);
            this.lastScale.set(this.scale);
            this.lastRotation.set(this.rotation);
            this.first = false;
        }
    }

    public Matrix4d getTransform(double percent, Matrix4d dst) {
        return dst.translationRotateScale((Vector3dc)this.lastTranslation.lerp(this.translation, percent, this.currentTranslation), (Quaterniondc)this.lastRotation.slerp(this.rotation, percent, this.currentRotation), this.lastScale.lerp(this.scale, percent, this.currentScale));
    }

    public void updateHitbox() {
        if (this.part == null || this.part.f_104212_.isEmpty()) {
            return;
        }
        ModelPart.Cube cuboid = (ModelPart.Cube)this.part.f_104212_.get(0);
        this.minX = cuboid.f_104335_ / 16.0f;
        this.minY = cuboid.f_104336_ / 16.0f;
        this.minZ = cuboid.f_104337_ / 16.0f;
        this.maxX = cuboid.f_104338_ / 16.0f;
        this.maxY = cuboid.f_104339_ / 16.0f;
        this.maxZ = cuboid.f_104340_ / 16.0f;
    }
}

