/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.util.HttpRequest;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;

public class ClothUpdater
implements Runnable {
    public static ConcurrentLinkedQueue<String> clothUpdates = new ConcurrentLinkedQueue();
    private Set<String> ignore = new ObjectOpenHashSet();
    private ConcurrentLinkedQueue<String> updates = new ConcurrentLinkedQueue();
    private Set<String> updated = new ObjectOpenHashSet();
    private int tickCount;

    public ClothUpdater() {
        Thread clothUpdater = new Thread(this);
        clothUpdater.setName("Cloth Updater Thread");
        clothUpdater.setDaemon(true);
        clothUpdater.start();
    }

    public void tick(@Nullable ClientLevel level) {
        if (PhysicsMod.reloadCloth) {
            ConfigCloth.save();
            PhysicsMod.loadCloth();
            PhysicsMod.reloadCloth = false;
        }
        String update = null;
        while ((update = clothUpdates.poll()) != null) {
            String[] data = update.split(";");
            String uuid = data[0];
            Map<String, ConfigCloth.ClothList> old = ConfigCloth.resetCustomization(uuid);
            boolean isPlayer = false;
            UUID playerUuid = ConfigCloth.getMinecraftUUID();
            if (playerUuid != null) {
                isPlayer = playerUuid.toString().equals(uuid);
            }
            if (isPlayer) {
                if (ConfigCloth.isChangingPlayer) continue;
                old = ConfigCloth.resetCustomization("physicsmod:yourself");
            }
            if (data.length != 2 || !data[1].equals("null")) {
                for (int i = 1; i < data.length; ++i) {
                    Cloth cloth = PhysicsMod.cloth.get(data[i]);
                    if (cloth == null) continue;
                    ConfigCloth.setCategory(uuid, cloth.rules.getCategory(), cloth.name);
                    if (!isPlayer) continue;
                    ConfigCloth.setCategory("physicsmod:yourself", cloth.rules.getCategory(), cloth.name);
                }
            }
            if (old == null) continue;
            for (ConfigCloth.ClothList list : old.values()) {
                for (String part : list.getClothPieces()) {
                    Cloth cloth = PhysicsMod.cloth.get(part);
                    if (cloth == null || !cloth.rules.isLocal()) continue;
                    ConfigCloth.setCategory(uuid, cloth.rules.getCategory(), cloth.name);
                    if (!isPlayer) continue;
                    ConfigCloth.setCategory("physicsmod:yourself", cloth.rules.getCategory(), cloth.name);
                }
            }
        }
        if (level != null) {
            ++this.tickCount;
            if (this.tickCount >= 600 && this.updates.isEmpty()) {
                for (AbstractClientPlayer player : level.m_6907_()) {
                    this.updates.add(player.m_20149_());
                }
                this.tickCount = 0;
            }
            for (AbstractClientPlayer player : level.m_6907_()) {
                String uuid = player.m_20149_();
                if (this.updated.contains(uuid)) continue;
                this.updated.add(uuid);
                this.updates.add(uuid);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            String update = null;
            while ((update = this.updates.poll()) != null) {
                if (this.ignore.contains(update)) continue;
                try {
                    String equipped = HttpRequest.get("http://customize.minecraftphysicsmod.com/equipped?uuid=" + update);
                    if (equipped.equalsIgnoreCase("nopro")) {
                        this.ignore.add(update);
                        continue;
                    }
                    clothUpdates.add(update + ";" + equipped);
                }
                catch (Exception e) {
                    StarterClient.logger.error("Couldn't fetch cloth for " + update);
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

