/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.smoke;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SmokeHelper {
    public static boolean addParticle(Level level, double x, double y, double z, float spawnChance) {
        boolean spawnSmoke = false;
        boolean inRange = false;
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        if (gameRenderer != null && spawnSmoke) {
            Vec3 view = gameRenderer.m_109153_().m_90583_();
            double distSquared = Vector3d.distanceSquared(view.f_82479_, view.f_82480_, view.f_82481_, x, y, z);
            if (distSquared < ConfigClient.smokePhysicsRange * ConfigClient.smokePhysicsRange) {
                inRange = true;
            }
        }
        if (spawnSmoke && inRange) {
            PhysicsMod mod = PhysicsMod.getInstance(level);
            SmokeDomain smokeDomain = mod.getPhysicsWorld().getSmokeDomain();
            while (spawnChance > 0.0f) {
                float fraction = spawnChance - (float)((int)spawnChance);
                if (spawnChance >= 1.0f || Math.random() < fraction) {
                    smokeDomain.spawnParticle(x, y, z, 1.0f);
                }
                spawnChance -= 1.0f;
            }
            return true;
        }
        return false;
    }
}

