/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.diebuddies.math.Math;
import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.TextAlignment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class ButtonRenderer
extends Animator {
    private TextAlignment alignment;
    private boolean renderTooltips = true;
    private ChatFormatting chatFormatting;
    private ResourceLocation image;

    public ButtonRenderer(TextAlignment alignment, ChatFormatting chatFormatting) {
        this.chatFormatting = chatFormatting;
        this.alignment = alignment;
    }

    public ButtonRenderer(TextAlignment alignment) {
        this(alignment, null);
    }

    public ButtonRenderer() {
        this(TextAlignment.CENTER);
    }

    @Override
    public boolean render(Animatable animatable, PoseStack matrices, int mouseX, int mouseY, float renderPercent, float delta) {
        AbstractWidget widget;
        boolean hovered = animatable.isInside(mouseX, mouseY);
        if (animatable instanceof MixinAbstractWidgetAccessor) {
            MixinAbstractWidgetAccessor accessor = (MixinAbstractWidgetAccessor)((Object)animatable);
            boolean wasHovered = accessor.getIsHovered();
            accessor.setIsHovered(hovered);
            if (!wasHovered && hovered) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12636_, (float)(Math.random() * 0.2f + 0.9f)));
            }
        }
        int color = BaseColors.BACKGROUND_COLOR;
        float x = animatable.getAnimX();
        float y = animatable.getAnimY();
        float width = animatable.getAnimWidth();
        float height = animatable.getAnimHeight();
        float depth = animatable.getAnimDepth();
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, (double)depth);
        depth = -2.0f;
        AbstractButton button = (AbstractButton)animatable;
        Matrix4f pose = matrices.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        ButtonRenderer.drawRect(bufferBuilder, pose, x, y, width, height, depth, color);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        if (this.image != null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.image);
            RenderSystem.m_157429_((float)animatable.getAnimRed(), (float)animatable.getAnimGreen(), (float)animatable.getAnimBlue(), (float)animatable.getAnimAlpha());
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            ButtonRenderer.drawRect(bufferBuilder, pose, x, y, width, height, depth, 0.0f, 1.0f, 0.0f, 1.0f);
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_69461_();
        FormattedCharSequence formattedCharSequence = (this.chatFormatting == null ? button.m_6035_() : button.m_6035_().m_6881_().m_130940_(this.chatFormatting)).m_7532_();
        Font font = Minecraft.m_91087_().f_91062_;
        float xText = x + 7.0f;
        if (this.alignment == TextAlignment.CENTER) {
            xText = x + width * 0.5f - (float)font.m_92724_(formattedCharSequence) * 0.5f;
        } else if (this.alignment == TextAlignment.RIGHT) {
            xText = x + width - (float)font.m_92724_(formattedCharSequence) - 7.0f;
        }
        ButtonRenderer.drawText(matrices, font, formattedCharSequence, Math.fastRound(xText), Math.fastRound(y + (height - 8.0f) / 2.0f));
        matrices.m_85849_();
        if (this.renderTooltips && animatable instanceof AbstractWidget && (widget = (AbstractWidget)animatable).m_198029_()) {
            widget.m_7428_(matrices, mouseX, mouseY);
        }
        return true;
    }

    public ButtonRenderer setRenderTooltips(boolean renderTooltips) {
        this.renderTooltips = renderTooltips;
        return this;
    }

    public boolean isRenderingTooltips() {
        return this.renderTooltips;
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public ButtonRenderer setImage(ResourceLocation image) {
        this.image = image;
        return this;
    }
}

