/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.gui;

import java.util.function.Consumer;
import net.diebuddies.physics.settings.gui.legacy.LegacyOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class TextOption
extends LegacyOption {
    private String name;
    private String value;
    private Consumer<String> consumer;
    private EditBox search;

    public TextOption(String name, String value, Consumer<String> consumer) {
        super(name);
        this.name = name;
        this.value = value;
        this.consumer = consumer;
    }

    @Override
    public AbstractWidget createButton(Options options, int x, int y, int width) {
        this.search = new EditBox(Minecraft.m_91087_().f_91062_, x, y, width, 20, (Component)new TextComponent(this.value));
        if (this.value == null || this.value.isEmpty()) {
            this.search.m_94167_("<" + this.name + ">");
        } else {
            this.search.m_94144_(this.value);
        }
        this.search.m_94151_(changedText -> {
            if (changedText.isEmpty()) {
                this.search.m_94167_("<" + this.name + ">");
            } else {
                this.search.m_94167_("");
            }
            this.consumer.accept((String)changedText);
        });
        return this.search;
    }

    public void setText(String text) {
        if (this.search != null) {
            if (text.isEmpty()) {
                this.search.m_94167_("<" + this.name + ">");
            } else {
                this.search.m_94167_("");
            }
            this.search.m_94144_(text);
        }
    }

    public String getText() {
        if (this.search != null) {
            return this.search.m_94155_();
        }
        return "";
    }
}

