/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigAnimations;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.CurveType;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.animation.CustomAnimationList;
import net.diebuddies.physics.settings.animation.ParticleDisplayScreen;
import net.diebuddies.physics.settings.gui.ButtonOption;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.ParticleOption;
import net.diebuddies.physics.settings.gui.SoundOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOption;
import net.diebuddies.physics.vines.AdjustableUtil;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class AnimationEditScreen
extends ParticleDisplayScreen {
    private CustomAnimationList list;
    private Animation setting;
    private long identifier;

    public AnimationEditScreen(Screen parent, Animation setting, long identifier) {
        super(parent, (Component)(setting != null ? new TranslatableComponent("physicsmod.menu.animation.edit.title") : new TranslatableComponent("physicsmod.menu.animation.add.title")));
        if (setting == null) {
            this.setting = new Animation("new", CurveType.Linear, 0.5);
            this.identifier = 0L;
            while (ConfigAnimations.animations.containsKey(this.identifier)) {
                ++this.identifier;
            }
        } else {
            this.setting = setting.copy();
            this.identifier = identifier;
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, CommonComponents.f_130656_, button -> this.m_7379_()));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> {
            Animation animation = (Animation)ConfigAnimations.animations.get(this.identifier);
            if (animation != null) {
                animation.set(this.setting);
            } else {
                ConfigAnimations.animations.put(this.identifier, (Object)this.setting);
            }
            ConfigAnimations.save();
            this.m_7379_();
        }));
        this.generateOptions();
        this.animation = this.setting;
        this.startAnimation();
    }

    private void generateOptions() {
        if (this.list != null) {
            this.f_96540_.remove((Object)this.list);
        }
        this.list = new CustomAnimationList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        List<LegacyOption> options = AdjustableUtil.generateOptions(this, this.setting, () -> this.generateOptions(), () -> this.startAnimation());
        int startIndex = 0;
        for (int i = 0; i < options.size(); ++i) {
            LegacyOption option = options.get(i);
            if (!(option instanceof LabelOption) && !(option instanceof ButtonOption) && !(option instanceof ParticleOption) && !(option instanceof SoundOption) && i > 3) continue;
            if (startIndex != i) {
                List<LegacyOption> subList = options.subList(startIndex, i);
                this.list.addSmall(subList.toArray(new LegacyOption[subList.size()]));
            }
            this.list.addBig(option);
            startIndex = i + 1;
        }
        if (startIndex != options.size()) {
            List<LegacyOption> subList = options.subList(startIndex, options.size());
            this.list.addSmall(subList.toArray(new LegacyOption[subList.size()]));
        }
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }
}

