/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.TextOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.util.HttpRequest;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.lwjgl.glfw.GLFW;

public class VerificationScreen
extends OptionsSubScreen {
    private static final String VERIFICATION_LINK = "https://www.patreon.com/oauth2/authorize?response_type=code&client_id=_inmbA4j4sQwg_nMJxQYXUwypouf0LHyd4CC6UD_Bjrx0sfG_s84mVziVembholp&redirect_uri=https://minecraftphysicsmod.com/verification&scope=identity%20identity.memberships";
    public static volatile boolean verified;
    private boolean localVerified = false;
    private LegacyOptionsList list;
    private String lastClipboard = "";
    private volatile boolean waitingForVerification;
    private volatile boolean queueNextVerification;
    private TextOption textfield;
    private volatile String errorMsg;
    private int count = 0;

    public VerificationScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent(""));
        try {
            this.lastClipboard = GLFW.glfwGetClipboardString((long)Minecraft.m_91087_().m_91268_().m_85439_());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.lastClipboard == null) {
            this.lastClipboard = "";
        }
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.addBig(new LabelOption(Language.m_128107_().m_6834_("physicsmod.gui.entercode")));
        this.textfield = new TextOption(Language.m_128107_().m_6834_("physicsmod.gui.code"), "", changed -> {
            if (!this.waitingForVerification) {
                this.verify((String)changed);
            } else {
                this.queueNextVerification = true;
            }
        });
        this.list.addBig(this.textfield);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 50, 90, 100, 20, (Component)new TranslatableComponent("physicsmod.gui.getcode"), button -> {
            this.errorMsg = null;
            PopupWidget.create(String.format(Language.m_128107_().m_6834_("physicsmod.menu.verification.popup"), VERIFICATION_LINK), (Screen)this, widget -> this.m_142416_((GuiEventListener)widget), widget -> this.m_169411_((GuiEventListener)widget), (Component)new TranslatableComponent("physicsmod.gui.opensite"), (Component)new TranslatableComponent("physicsmod.gui.copylink"), response -> {
                if (response == PopupWidget.PopupResponse.YES) {
                    Util.m_137581_().m_137646_(VERIFICATION_LINK);
                } else {
                    GLFW.glfwSetClipboardString((long)this.count, (CharSequence)VERIFICATION_LINK);
                }
            });
        }, (button, stack, i, j) -> {
            List list = this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent("physicsmod.gui.getcode.info"), 175);
            this.m_96617_(stack, list, i, j);
        }));
        this.f_96540_.add(this.list);
    }

    public static String getMinecraftName() {
        if (Minecraft.m_91087_().m_91094_() != null && Minecraft.m_91087_().m_91094_().m_92546_() != null) {
            return Minecraft.m_91087_().m_91094_().m_92546_();
        }
        return "";
    }

    private void verify(String changed) {
        this.waitingForVerification = true;
        this.queueNextVerification = false;
        if (changed.contains("https://") || changed.contains("http://")) {
            this.waitingForVerification = false;
            return;
        }
        String mcName = VerificationScreen.getMinecraftName();
        String uuid = ConfigCloth.getMinecraftUUIDString();
        String update = ConfigCloth.getPlayerUpdate();
        Thread thread = new Thread(() -> {
            try {
                String result = HttpRequest.get("http://verify.minecraftphysicsmod.com/verify?code=" + changed + "&name=" + mcName);
                verified = result.contains(changed + "verified");
                if (verified) {
                    ConfigClient.verificationCode = changed;
                    ConfigClient.save();
                    this.localVerified = true;
                    if (uuid != null) {
                        HttpRequest.post("http://customize.minecraftphysicsmod.com/update?uuid=" + uuid + "&token=" + ConfigClient.verificationCode, update);
                    }
                } else {
                    this.errorMsg = result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMsg = e.getMessage();
            }
            finally {
                this.waitingForVerification = false;
            }
        });
        thread.setName("Verification Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.localVerified) {
            Minecraft.m_91087_().m_91152_(this.f_96281_);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.queueNextVerification && !this.waitingForVerification) {
            this.verify(this.textfield.getText());
        }
        ++this.count;
        if (this.count > 10) {
            try {
                String clipboard = GLFW.glfwGetClipboardString((long)this.f_96541_.m_91268_().m_85439_());
                if (clipboard != null && !this.lastClipboard.equals(clipboard)) {
                    this.textfield.setText(clipboard);
                    this.lastClipboard = clipboard;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.count = 0;
        }
        if (this.waitingForVerification) {
            VerificationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)new TranslatableComponent("physicsmod.gui.verify"), (int)(this.f_96543_ / 2), (int)117, (int)0xFFFF55);
        } else if (this.errorMsg != null) {
            VerificationScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)("Error: " + this.errorMsg), (int)(this.f_96543_ / 2), (int)117, (int)0xFF5555);
        }
    }
}

