/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.ResourceManager;
import net.diebuddies.org.joml.Math;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.GeneralSettingsScreen;
import net.diebuddies.physics.settings.LiquidSettingsScreen;
import net.diebuddies.physics.settings.OceanSettingsScreen;
import net.diebuddies.physics.settings.ProjectileSettingsScreen;
import net.diebuddies.physics.settings.ServerSettingsScreen;
import net.diebuddies.physics.settings.SmokeSettingsScreen;
import net.diebuddies.physics.settings.SnowSettingsScreen;
import net.diebuddies.physics.settings.SoundSettingsScreen;
import net.diebuddies.physics.settings.WeatherSettingsScreen;
import net.diebuddies.physics.settings.animation.AnimationSettingsScreen;
import net.diebuddies.physics.settings.blocks.BlockSettingsScreen;
import net.diebuddies.physics.settings.cloth.ClothSettingsScreen;
import net.diebuddies.physics.settings.mobs.MobSettingsScreen;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BarRenderer;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.ButtonRenderer;
import net.diebuddies.physics.settings.ux.FocusSelector;
import net.diebuddies.physics.settings.ux.GUIResources;
import net.diebuddies.physics.settings.ux.ImageElement;
import net.diebuddies.physics.settings.ux.MainToolTipRenderer;
import net.diebuddies.physics.settings.ux.MouseParallaxAnimator;
import net.diebuddies.physics.settings.ux.ParallaxBackground;
import net.diebuddies.physics.settings.ux.Parallaxes;
import net.diebuddies.physics.settings.ux.ScrollAnimator;
import net.diebuddies.physics.settings.ux.TextAlignment;
import net.diebuddies.physics.settings.ux.WidthAnimator;
import net.diebuddies.physics.settings.vines.VineSettingsScreen;
import net.diebuddies.render.MainRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class PhysicsSettingsScreen
extends Screen {
    private static final int startingOffset = 17;
    private static final int offset = 30;
    private static final int buttonWidth = 120;
    private static final float widthMultiplier = 0.6f;
    private static final float widthSpeed = 0.5f;
    private static final int backButtonWidth = 70;
    private final Screen parent;
    private ScrollAnimator scrollAnimator;
    private FocusSelector focusSelector;
    private boolean renderedTooltip;
    private Button back;
    private Button updateAvailable;
    private ResourceManager resourceManager;
    private ParallaxBackground parallax;

    public PhysicsSettingsScreen(Screen parent) {
        super((Component)new TranslatableComponent("physicsmod.menu.physics.title"));
        this.parent = parent;
        this.resourceManager = new ResourceManager();
        ConfigClient.firstStartup = false;
        MainRenderer.getParallaxShader();
    }

    protected void m_7856_() {
        this.focusSelector = new FocusSelector();
        this.parallax = new ParallaxBackground(0.0f, 0.0f, this.f_96543_, this.f_96544_, this.focusSelector);
        this.m_169394_((Widget)this.parallax);
        int buttonHeight = 24;
        int count = 0;
        this.scrollAnimator = new ScrollAnimator(0.0f, 0.0f, 60.0f, this.f_96544_);
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.general.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new GeneralSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.general.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_GENERAL_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_GENERAL_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.114f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_GENERAL_LAYER_2, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_GENERAL_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.16f, false)))));
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.mobs.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new MobSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.mobs.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_MOBS_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_MOBS_MIDDLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_MOBS_FRONT, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.16f, false)))));
        Button blocks = (Button)this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.blocks.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new BlockSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.blocks.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_BLOCKS_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_BLOCKS_CLOUDS, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.103f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_BLOCKS_RUBBLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false)))));
        this.parallax.addImageElements(((Animatable)blocks).getAnimator(Parallaxes.class).elements);
        Button oceanButton = (Button)this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.ocean.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new OceanSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.ocean.title.main.info"), (Component)new TranslatableComponent("physicsmod.menu.physics.ocean.error"), true, (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_OCEAN_OLD, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.117f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_OCEAN_NEW, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true).setShader(MainRenderer.getParallaxSlideShader()))).addAnimator((Animator)new MouseParallaxAnimator(0.117f, false)))));
        if (oceanButton.f_93623_) {
            oceanButton.f_93623_ = !StarterClient.immersivePortals;
        }
        Button dynamicButton = (Button)this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.dynamicblocks.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new VineSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.dynamicblocks.title.main.info"), (Component)new TranslatableComponent("physicsmod.menu.physics.dynamicblocks.error"), true, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_DYNAMIC_BLOCKS_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_DYNAMIC_BLOCKS_MIDDLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_DYNAMIC_BLOCKS_FRONT, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false)))));
        if (dynamicButton.f_93623_) {
            dynamicButton.f_93623_ = !StarterClient.immersivePortals;
        }
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.cloth.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new ClothSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.cloth.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CLOTH_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CLOTH_MIDDLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.117f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CLOTH_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.13f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CLOTH_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.15f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CLOTH_LAYER_2, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.185f, false)))));
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.items.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new ProjectileSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.items.title.main.info"), null, true, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_PROJECTILES_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_PROJECTILES_MIDDLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_PROJECTILES_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.13f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_PROJECTILES_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.16f, false)))));
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.liquid.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new LiquidSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.liquid.title.main.info"), null, true, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_LIQUID_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_LIQUID_LAYER_2, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.114f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_LIQUID_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_LIQUID_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.16f, false)))));
        Button snowButton = (Button)this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.snow.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new SnowSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.snow.title.main.info"), (Component)new TranslatableComponent("physicsmod.menu.physics.snow.error"), true, (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_SNOW_OLD, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.117f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(GUIResources.PARALLAX_SNOW_NEW, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true).setShader(MainRenderer.getParallaxSlideShader()))).addAnimator((Animator)new MouseParallaxAnimator(0.117f, false)))));
        if (snowButton.f_93623_) {
            snowButton.f_93623_ = !StarterClient.immersivePortals;
        }
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.sound.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new SoundSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.sound.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_SOUND_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_SOUND_LAYER_2, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_SOUND_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_SOUND_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.16f, false)))));
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.animation.settings.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new AnimationSettingsScreen(this), (Component)new TranslatableComponent("physicsmod.menu.animation.settings.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_ANIMATIONS_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_ANIMATIONS_MIDDLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_ANIMATIONS_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_ANIMATIONS_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.13f, false)))));
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.smoke.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new SmokeSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.smoke.title.main.info"), null, true, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_SMOKE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.114f, false)))));
        this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.weather.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new WeatherSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.weather.title.main.info"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_WEATHER_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_WEATHER_LAYER_0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.123f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_WEATHER_LAYER_1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_WEATHER_LAYER_2, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.17f, false)))));
        Button serverButton = (Button)this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.collapse.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> new ServerSettingsScreen(this, this.f_96541_.f_91066_), (Component)new TranslatableComponent("physicsmod.menu.collapse.title.main.info"), (Component)new TranslatableComponent("physicsmod.menu.physics.collapse.error"), false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_COLLAPSE_BLOCKS_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_COLLAPSE_BLOCKS_MIDDLE, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.12f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_COLLAPSE_BLOCKS_FRONT, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false)))));
        if (serverButton.f_93623_) {
            serverButton.f_93623_ = Minecraft.m_91087_().m_91091_() || Minecraft.m_91087_().m_91089_() == null;
        }
        Button credits = (Button)this.m_142416_((GuiEventListener)this.createMenuButton((Component)new TranslatableComponent("physicsmod.menu.credits.title.main"), 0, 17 + 30 * count++, 120, buttonHeight, () -> null, (Component)new TranslatableComponent("physicsmod.credits"), null, false, (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CREDITS_BACKGROUND, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.107f, false))), (ImageElement)((Object)((Animatable)((Object)new ImageElement(this.resourceManager, GUIResources.PARALLAX_CREDITS_DRAGON, 0.0f, 0.0f, this.f_96543_, this.f_96544_, true))).addAnimator((Animator)new MouseParallaxAnimator(0.14f, false)))));
        ((Animatable)credits).getAnimator(BarRenderer.class).setBarColor(BaseColors.WARNING_COLOR).setHoveredColor(BaseColors.WARNING_COLOR);
        this.back = (Button)this.m_142416_((GuiEventListener)((Button)((Animatable)ButtonSettings.builderNoStyle(this.f_96543_ - 70, 17, 70, buttonHeight, (Component)new TranslatableComponent("physicsmod.gui.back"), button -> this.f_96541_.m_91152_(this.parent))).addAnimator(this.createRightSideAnimators())));
        int offsetCounter = 1;
        if (StarterClient.newUpdateAvailable) {
            this.updateAvailable = (Button)this.m_142416_((GuiEventListener)((Button)((Animatable)ButtonSettings.builderNoStyle(this.f_96543_ - 70, 17 + 30 * offsetCounter++, 70, buttonHeight, (Component)new TranslatableComponent("physicsmod.menu.main.update"), button -> Util.m_137581_().m_137646_("https://minecraftphysicsmod.com/"))).addAnimator(this.createWarningRightSideAnimators())));
        }
        this.m_142416_((GuiEventListener)((Button)((Animatable)ButtonSettings.builderNoStyle(this.f_96543_ - 70, 17 + 30 * offsetCounter++, 70, buttonHeight, (Component)new TranslatableComponent("physicsmod.menu.main.getpro"), button -> Util.m_137581_().m_137646_("https://minecraftphysicsmod.com/pro"))).addAnimator(this.createWarningRightSideAnimators()).addAnimator((Animator)new GetProAnimator(this.focusSelector))));
        this.scrollAnimator.setMinOffset(-(34 + 30 * count - this.f_96544_ - (30 - buttonHeight)));
        this.scrollAnimator.setMaxOffset(0.0f);
    }

    private List<Animator> createRightSideAnimators() {
        return Arrays.asList(new ButtonRenderer(TextAlignment.RIGHT, ChatFormatting.BOLD), new BarRenderer(BarRenderer.BarAlignment.LEFT, false, 2.4f), new WidthAnimator(0.6f, 0.5f, true));
    }

    private List<Animator> createWarningRightSideAnimators() {
        return Arrays.asList(new ButtonRenderer(TextAlignment.RIGHT, ChatFormatting.BOLD), new BarRenderer(BarRenderer.BarAlignment.LEFT, false, 2.4f).setBarColor(BaseColors.WARNING_COLOR).setHoveredColor(BaseColors.WARNING_COLOR), new WidthAnimator(0.6f, 0.5f, true));
    }

    public Button createMenuButton(Component title, int buttonX, int buttonY, int buttonWidth, int buttonHeight, Supplier<Screen> supplier, @Nullable Component activeTooltip, @Nullable Component inactiveTooltip, boolean requiresPro, ImageElement ... parallaxes) {
        boolean needsProButHasnt;
        boolean bl = needsProButHasnt = requiresPro;
        if (needsProButHasnt && activeTooltip != null) {
            inactiveTooltip = new TranslatableComponent("physicsmod.menu.main.prorequired").m_6881_().m_7220_(activeTooltip);
        }
        Component pActiveTooltip = activeTooltip;
        Component pInactiveTooltip = inactiveTooltip;
        Button menuButton = (Button)((Animatable)ButtonSettings.builderNoStyle(buttonX, buttonY, buttonWidth, buttonHeight, title, button -> {
            Screen screen = (Screen)supplier.get();
            if (screen != null) {
                this.f_96541_.m_91152_(screen);
            }
        }, (button, poseStack, i, j) -> this.renderTooltip((Animatable)button, poseStack, pActiveTooltip, pInactiveTooltip, buttonHeight))).addAnimator(this.scrollAnimator, new ButtonRenderer(TextAlignment.LEFT, ChatFormatting.BOLD), new BarRenderer(BarRenderer.BarAlignment.RIGHT, false, 2.4f), new WidthAnimator(0.6f, 0.5f), this.focusSelector, new ProRequirement(requiresPro), new Parallaxes(parallaxes));
        if (needsProButHasnt) {
            menuButton.f_93623_ = false;
        }
        return menuButton;
    }

    private void renderTooltip(Animatable animatable, PoseStack poseStack, @Nullable Component activeTooltip, @Nullable Component inactiveTooltip, int buttonHeight) {
        float x = 120.0f + (float)buttonHeight * 0.6f + 17.0f;
        if (this.renderedTooltip) {
            return;
        }
        boolean active = true;
        if (animatable instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)animatable;
            active = widget.f_93623_;
        }
        if (!active) {
            if (inactiveTooltip != null) {
                MainToolTipRenderer.renderToolTip(animatable, inactiveTooltip, poseStack, x, (float)this.f_96543_ - x - 17.0f, (float)(this.f_96544_ - 17), 2.4f);
                this.renderedTooltip = true;
            }
        } else if (activeTooltip != null) {
            MainToolTipRenderer.renderToolTip(animatable, activeTooltip, poseStack, x, (float)this.f_96543_ - x - 17.0f, (float)(this.f_96544_ - 17), 2.4f);
            this.renderedTooltip = true;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.scrollAnimator != null) {
            this.scrollAnimator.scroll((float)scrollAmount);
        }
        return true;
    }

    public boolean m_7933_(int key, int j, int k) {
        if (this.scrollAnimator != null) {
            if (key == 267) {
                this.scrollAnimator.scroll(-4.0f);
            }
            if (key == 266) {
                this.scrollAnimator.scroll(4.0f);
            }
        }
        return super.m_7933_(key, j, k);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseKey) {
        if (this.scrollAnimator != null && this.scrollAnimator.mouseClicked(mouseX, mouseY, mouseKey)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseKey);
    }

    public void m_7379_() {
        super.m_7379_();
        this.resourceManager.destroy();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderedTooltip = false;
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.back.m_198029_() || this.updateAvailable != null && this.updateAvailable.m_198029_()) {
            this.focusSelector.deselectAll();
        }
    }

    public class GetProAnimator
    extends Animator {
        private FocusSelector focusSelector;
        private boolean visible;
        private float baseX;
        private float baseWidth;
        private float oldX;
        private float currentX;

        public GetProAnimator(FocusSelector focusSelector) {
            this.focusSelector = focusSelector;
        }

        @Override
        public boolean render(Animatable animatable, PoseStack matrices, int mouseX, int mouseY, float renderPercent, float delta) {
            super.render(animatable, matrices, mouseX, mouseY, renderPercent, delta);
            this.visible = this.focusSelector.getFocusedElement() == null ? false : this.focusSelector.getFocusedElement().getAnimator(ProRequirement.class).requiresPro;
            float newX = Math.lerp(this.oldX, this.currentX, renderPercent);
            animatable.setAnimX(newX - animatable.getAnimator(WidthAnimator.class).getOffset());
            return false;
        }

        @Override
        public void tick(Animatable animatable) {
            super.tick(animatable);
            float target = this.baseX;
            if (!this.visible) {
                target += this.baseWidth;
            }
            this.oldX = this.currentX;
            this.currentX = Math.lerp(this.currentX, target, 0.5f);
        }

        @Override
        public void init(Animatable animatable) {
            super.init(animatable);
            this.baseX = animatable.getAnimX();
            this.baseWidth = animatable.getAnimWidth() + 14.400001f;
            this.oldX = this.baseX + this.baseWidth;
            this.currentX = this.baseX + this.baseWidth;
            animatable.setAnimX(this.baseX + this.baseWidth);
        }
    }

    public class ProRequirement
    extends Animator {
        public boolean requiresPro;

        public ProRequirement(boolean requiresPro) {
            this.requiresPro = requiresPro;
        }
    }
}

