/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.ocean.OceanLayer;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class OceanSettingsScreen
extends OptionsSubScreen {
    private final CycleOption<Boolean> PHYSICS_OCEAN = CycleOption.createOnOff("physicsmod.menu.ocean.oceanphysics", gameOptions -> ConfigClient.oceanPhysics, (gameOptions, option, value) -> {
        ConfigClient.oceanPhysics = value;
        Minecraft.m_91087_().f_91060_.m_109818_();
    });
    private final CycleOption<Boolean> PHYSICS_OCEAN_HITBOX = CycleOption.createOnOff("physicsmod.menu.ocean.hitbox", gameOptions -> ConfigClient.oceanAdjustHitbox, (gameOptions, option, value) -> {
        ConfigClient.oceanAdjustHitbox = value;
    }).setTooltip(minecraft -> graphicsStatus -> new TranslatableComponent("physicsmod.menu.ocean.hitbox.info"));
    private final CycleOption<Boolean> PHYSICS_OCEAN_RIPPLES = CycleOption.createOnOff("physicsmod.menu.ocean.ripples", gameOptions -> ConfigClient.oceanRipples, (gameOptions, option, value) -> {
        ConfigClient.oceanRipples = value;
        Minecraft.m_91087_().f_91060_.m_109818_();
    }).setTooltip(minecraft -> graphicsStatus -> new TranslatableComponent("physicsmod.menu.ocean.ripples.info"));
    private final ProgressOption PHYSICS_OCEAN_DETAIL = new ProgressOption("physicsmod.menu.ocean.detail", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.oceanDetail, (gameOptions, value) -> {
        ConfigClient.oceanDetail = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.detail", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_FOAM_AMOUNT = new ProgressOption("physicsmod.menu.ocean.foamamount", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.oceanFoamAmount, (gameOptions, value) -> {
        ConfigClient.oceanFoamAmount = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.foamamount", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_FOAM_OPACITY = new ProgressOption("physicsmod.menu.ocean.foamopacity", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.oceanFoamOpacity, (gameOptions, value) -> {
        ConfigClient.oceanFoamOpacity = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.foamopacity", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_BLOCK_RANGE = new ProgressOption("physicsmod.menu.ocean.blockrange", 2.0, 96.0, 1.0f, gameOptions -> ConfigClient.oceanBlockRange, (gameOptions, value) -> {
        ConfigClient.oceanBlockRange = value.byteValue();
        OceanLayer.updateRange(ConfigClient.oceanBlockRange);
        Minecraft.m_91087_().f_91060_.m_109818_();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.blockrange", Integer.toString((int)option.get((Options)gameOptions))), minecraft -> new TranslatableComponent("physicsmod.menu.ocean.blockrange.info"));
    private final ProgressOption PHYSICS_OCEAN_WEATHER_CLEAR = new ProgressOption("physicsmod.menu.ocean.weather.clear", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanWeatherClear, (gameOptions, value) -> {
        ConfigClient.oceanWeatherClear = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.weather.clear", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WEATHER_RAIN = new ProgressOption("physicsmod.menu.ocean.weather.rain", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanWeatherRain, (gameOptions, value) -> {
        ConfigClient.oceanWeatherRain = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.weather.rain", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WEATHER_THUNDER = new ProgressOption("physicsmod.menu.ocean.weather.thunder", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanWeatherThunder, (gameOptions, value) -> {
        ConfigClient.oceanWeatherThunder = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.weather.thunder", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WAVE_HEIGHT = new ProgressOption("physicsmod.menu.ocean.waveheight", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.oceanWaveHeightMultiplier, (gameOptions, value) -> {
        ConfigClient.oceanWaveHeightMultiplier = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.waveheight", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WAVE_SPEED = new ProgressOption("physicsmod.menu.ocean.wavespeed", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanBaseSpeed, (gameOptions, value) -> {
        ConfigClient.oceanBaseSpeed = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.wavespeed", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WAVE_HORIZONTAL_SCALE = new ProgressOption("physicsmod.menu.ocean.wavehorizontalscale", 0.1, 2.0, 0.01f, gameOptions -> ConfigClient.oceanHorizontalWaveScale, (gameOptions, value) -> {
        ConfigClient.oceanHorizontalWaveScale = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.wavehorizontalscale", String.format("%.2f", option.get((Options)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_PARTICLE_ALPHA = new ProgressOption("physicsmod.menu.ocean.particlealpha", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.oceanParticleAlpha, (gameOptions, value) -> {
        ConfigClient.oceanParticleAlpha = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.particlealpha", String.format("%.2f", option.get((Options)gameOptions))));
    private final CycleOption<Boolean> PHYSICS_OCEAN_STICKY = CycleOption.createOnOff("physicsmod.menu.ocean.sticky", gameOptions -> ConfigClient.oceanStickyEntities, (gameOptions, option, value) -> {
        ConfigClient.oceanStickyEntities = value;
    });
    private final CycleOption<Boolean> PHYSICS_OCEAN_PARTICLES = CycleOption.createOnOff("physicsmod.menu.ocean.particles", gameOptions -> ConfigClient.oceanParticles, (gameOptions, option, value) -> {
        ConfigClient.oceanParticles = value;
    });
    private LegacyOptionsList list;
    private Component title;

    public OceanSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TranslatableComponent("physicsmod.menu.ocean.title"));
        this.checkOceanWarning();
    }

    private void checkOceanWarning() {
        this.title = OceanWorld.getMaxOceanHeight() * 0.5f > (float)ConfigClient.oceanBlockRange ? new TranslatableComponent("physicsmod.menu.ocean.title.warning") : new TranslatableComponent("physicsmod.menu.ocean.title");
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.renderBackgroundWhenIngame = false;
        this.list.addSmall(this.PHYSICS_OCEAN, this.PHYSICS_OCEAN_HITBOX);
        this.list.addSmall(this.PHYSICS_OCEAN_FOAM_AMOUNT, this.PHYSICS_OCEAN_FOAM_OPACITY);
        this.list.addBig(this.PHYSICS_OCEAN_RIPPLES);
        this.list.addBig(this.PHYSICS_OCEAN_BLOCK_RANGE);
        this.list.addBig(new LabelOption(Language.m_128107_().m_6834_("physicsmod.menu.ocean.wavetitle")));
        this.list.addSmall(this.PHYSICS_OCEAN_DETAIL, this.PHYSICS_OCEAN_WAVE_HEIGHT);
        this.list.addSmall(this.PHYSICS_OCEAN_WAVE_SPEED, this.PHYSICS_OCEAN_WAVE_HORIZONTAL_SCALE);
        this.list.addBig(new LabelOption(Language.m_128107_().m_6834_("physicsmod.menu.ocean.entities")));
        this.list.addSmall(this.PHYSICS_OCEAN_PARTICLES, this.PHYSICS_OCEAN_PARTICLE_ALPHA);
        this.list.addBig(this.PHYSICS_OCEAN_STICKY);
        this.list.addBig(new LabelOption(Language.m_128107_().m_6834_("physicsmod.menu.ocean.weather")));
        this.list.addBig(this.PHYSICS_OCEAN_WEATHER_CLEAR);
        this.list.addBig(this.PHYSICS_OCEAN_WEATHER_RAIN);
        this.list.addBig(this.PHYSICS_OCEAN_WEATHER_THUNDER);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> {
            this.m_7379_();
            this.f_96541_.m_91152_(this.f_96281_);
        }));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)new TranslatableComponent("physicsmod.gui.reset"), button -> PopupWidget.create(Language.m_128107_().m_6834_("physicsmod.menu.ocean.reset"), (Screen)this, widget -> this.m_142416_((GuiEventListener)widget), widget -> this.m_169411_((GuiEventListener)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetOceanSettings();
                OceanLayer.updateRange(ConfigClient.oceanBlockRange);
                Minecraft.m_91087_().f_91060_.m_109818_();
                this.list.m_6702_().clear();
                this.f_96541_.m_91152_((Screen)new OceanSettingsScreen(this.f_96281_, this.f_96282_));
            } else {
                this.list.m_6702_().clear();
                this.f_96541_.m_91152_((Screen)new OceanSettingsScreen(this.f_96281_, this.f_96282_));
            }
        })));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        OceanSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.title, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }

    public void m_7379_() {
        ConfigClient.save();
        super.m_7379_();
    }
}

