/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ocean;

import io.github.douira.glsl_transformer_physics.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer_physics.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer_physics.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer_physics.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer_physics.ast.node.expression.binary.MultiplicationExpression;
import io.github.douira.glsl_transformer_physics.ast.node.expression.unary.FunctionCallExpression;
import io.github.douira.glsl_transformer_physics.ast.node.external_declaration.FunctionDefinition;
import io.github.douira.glsl_transformer_physics.ast.node.statement.CompoundStatement;
import io.github.douira.glsl_transformer_physics.ast.node.type.initializer.ExpressionInitializer;
import io.github.douira.glsl_transformer_physics.ast.print.PrintType;
import io.github.douira.glsl_transformer_physics.ast.query.Root;
import io.github.douira.glsl_transformer_physics.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer_physics.ast.transform.ASTParser;
import io.github.douira.glsl_transformer_physics.ast.transform.SingleASTTransformer;
import io.github.douira.glsl_transformer_physics.job_parameter.JobParameters;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.diebuddies.compat.Iris;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ShaderInjection {
    private static String position = "gl_Vertex";
    private static String normalMatrix = "gl_NormalMatrix";
    private static String modelViewProjectionMatrix = "gl_ModelViewProjectionMatrix";
    private static String outputColor0 = "gl_FragData[0]";
    private static String outputColor1 = "gl_FragData[1]";
    private static String outputColor2 = "gl_FragData[2]";
    private static String outputColor3 = "gl_FragData[3]";
    private static String outputColor4 = "gl_FragData[4]";
    private static String lmCoord = "(mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0)) * gl_MultiTexCoord1).xy";

    private static void setupOptifineInjection() {
        position = "vec4(vaPosition + chunkOffset, 1.0)";
        normalMatrix = "normalMatrix";
        modelViewProjectionMatrix = "(projectionMatrix * modelViewMatrix)";
        outputColor0 = "outColor0";
        outputColor1 = "outColor1";
        outputColor2 = "outColor2";
        outputColor3 = "outColor3";
        outputColor4 = "outColor4";
        lmCoord = "(mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0)) * vec4(vaUV2, 0.0, 1.0)).xy";
    }

    @Nullable
    public static String getVertexSource(String vertexSource) {
        if (StarterClient.optifabric) {
            ShaderInjection.setupOptifineInjection();
        }
        if (vertexSource == null) {
            return null;
        }
        return ShaderInjection.transformVertexOceanShader(ShaderInjection.evaluatePack(vertexSource), vertexSource);
    }

    private static ShaderPack evaluatePack(String source) {
        if (source.contains("Complementary Shaders by EminGT")) {
            return ShaderPack.COMPLEMENTARY;
        }
        if (source.contains("Complementary Reimagined by EminGT")) {
            return ShaderPack.COMPLEMENTARY_REIMAGINED;
        }
        return ShaderPack.OTHER;
    }

    @Nullable
    public static String getGeometrySource(String geometrySource) {
        if (StarterClient.optifabric) {
            ShaderInjection.setupOptifineInjection();
        }
        return null;
    }

    @Nullable
    public static String getFragmentSource(String fragmentSource, boolean shadowShader) {
        if (StarterClient.optifabric) {
            ShaderInjection.setupOptifineInjection();
        }
        if (fragmentSource == null) {
            return null;
        }
        if (!shadowShader) {
            if (StarterClient.iris) {
                Iris.oceanError = "";
            }
            return ShaderInjection.transformFragmentOceanShader(ShaderInjection.evaluatePack(fragmentSource), fragmentSource);
        }
        SingleASTTransformer transformer = new SingleASTTransformer();
        transformer.setTransformation((translationUnit, root) -> translationUnit.parseAndInjectNodes((ASTParser)transformer, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec3 physics_localPosition;", "in vec3 physics_foamColor;", "in float physics_localWaviness;"));
        transformer.setPrintType(PrintType.SIMPLE);
        return transformer.transform(fragmentSource);
    }

    private static void setTestFile(CallbackInfoReturnable<Optional<String>> info, String asset) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append('\n');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        info.setReturnValue(Optional.of(builder.toString()));
    }

    private static String transformVertexOceanShader(ShaderPack pack, String vertex) {
        SingleASTTransformer transformer = new SingleASTTransformer();
        vertex = StringUtils.replace((String)vertex, (String)position, (String)"physics_finalPosition");
        boolean addOptifineUV2 = StarterClient.optifabric && !vertex.contains("vaUV2");
        transformer.setTransformation((translationUnit, root) -> {
            List<String> oceanInjection = ShaderInjection.getOceanWaveInjection();
            oceanInjection.add("out vec3 physics_localPosition;");
            oceanInjection.add("out vec3 physics_foamColor;");
            oceanInjection.add("out float physics_localWaviness;");
            oceanInjection.add("vec4 physics_finalPosition;");
            if (addOptifineUV2) {
                oceanInjection.add("in ivec2 vaUV2;");
            }
            translationUnit.parseAndInjectNodes((ASTParser)transformer, ASTInjectionPoint.BEFORE_DECLARATIONS, oceanInjection.toArray(new String[oceanInjection.size()]));
            root.process(root.identifierIndex.getStream("ftransform"), identifier -> {
                ASTNode parent = identifier.getParent();
                if (parent instanceof FunctionCallExpression) {
                    parent.replaceByAndDelete(transformer.parseExpression((ASTNode)identifier, "(" + modelViewProjectionMatrix + " * physics_finalPosition)"));
                }
            });
            translationUnit.prependMain((ASTParser)transformer, "physics_foamColor = textureLod(physics_lightmap, " + lmCoord + ", 0).rgb;", "physics_localWaviness = texelFetch(physics_waviness, ivec2(" + position + ".xz) - physics_textureOffset, 0).r;", "physics_finalPosition = vec4(" + position + ".x, " + position + ".y + physics_waveHeight(" + position + ".xz, PHYSICS_ITERATIONS_OFFSET, physics_localWaviness, physics_gameTime), " + position + ".z, " + position + ".w);", "physics_localPosition = physics_finalPosition.xyz;");
        });
        transformer.setPrintType(PrintType.SIMPLE);
        return transformer.transform(vertex);
    }

    private static String transformFragmentOceanShader(ShaderPack pack, String fragment) {
        SingleASTTransformer transformer = new SingleASTTransformer();
        boolean injectNormalMatrix = StarterClient.optifabric && !fragment.contains(normalMatrix);
        transformer.setTransformation((translationUnit, root) -> {
            List<String> oceanInjection = ShaderInjection.getOceanWaveInjection();
            oceanInjection.add("in vec3 physics_localPosition;");
            oceanInjection.add("in vec3 physics_foamColor;");
            oceanInjection.add("in float physics_localWaviness;");
            oceanInjection.add("WavePixelData physics_waveData;");
            if (injectNormalMatrix) {
                oceanInjection.add("uniform mat3 normalMatrix;");
            }
            translationUnit.parseAndInjectNodes((ASTParser)transformer, ASTInjectionPoint.BEFORE_DECLARATIONS, oceanInjection.toArray(new String[oceanInjection.size()]));
            if (pack == ShaderPack.COMPLEMENTARY) {
                ShaderInjection.complementary(transformer, translationUnit, root);
            } else if (pack == ShaderPack.COMPLEMENTARY_REIMAGINED) {
                ShaderInjection.complementaryReimagined(transformer, translationUnit, root);
            } else if (pack == ShaderPack.OTHER) {
                ShaderInjection.other(transformer, translationUnit, root, fragment);
            }
        });
        transformer.setPrintType(PrintType.SIMPLE);
        return transformer.transform(fragment);
    }

    private static void printError() {
        if (StarterClient.iris) {
            Iris.oceanError = "This shader (or shaderpack settings) is not supported by ocean physics!";
        }
    }

    private static void complementary(SingleASTTransformer<JobParameters> transformer, TranslationUnit translationUnit, Root root) {
        CompoundStatement calcWaveNormal = translationUnit.getFunctionDefinitionBody("GetWaterNormal");
        if (calcWaveNormal == null) {
            ShaderInjection.printError();
            return;
        }
        translationUnit.prependMain((ASTParser)transformer, "physics_waveData = physics_wavePixel(physics_localPosition.xz, physics_localWaviness, physics_iterationsNormal, physics_gameTime);");
        translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
        calcWaveNormal.getStatements().clear();
        calcWaveNormal.getStatements().addAll(transformer.parseStatements(calcWaveNormal, "return normalize(" + normalMatrix + " * physics_waveData.normal);"));
        root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
        root.replaceReferenceExpressions(transformer, "VdotN", "dot(nViewPos, normalize(newNormal))");
        ShaderInjection.setVariable(root, transformer, "PHYSICS_NORMAL_STRENGTH", "1.4");
    }

    private static void complementaryReimagined(SingleASTTransformer<JobParameters> transformer, TranslationUnit translationUnit, Root root) {
        translationUnit.prependMain(transformer, "physics_waveData = physics_wavePixel(physics_localPosition.xz, physics_localWaviness, physics_iterationsNormal, physics_gameTime);", "vec3 physics_normal = normalize(" + normalMatrix + " * physics_waveData.normal);");
        translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
        root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
        CompoundStatement main = translationUnit.getMainDefinitionBody();
        root.process(root.identifierIndex.getStream("normalM"), identifier -> {
            ASTNode parent = identifier.getParent();
            FunctionDefinition functionDefintion = parent.getAncestor(FunctionDefinition.class);
            if (functionDefintion != null && functionDefintion.getBody() == main && parent instanceof ReferenceExpression) {
                parent.replaceByAndDelete(transformer.parseExpression((ASTNode)identifier, "physics_normal"));
            }
        });
        CompoundStatement getCustomMaterials = translationUnit.getFunctionDefinitionBody("GetCustomMaterials");
        if (getCustomMaterials != null) {
            getCustomMaterials.getChildren().clear();
        }
        root.process(root.identifierIndex.getStream("normalMap"), identifier -> {
            ASTNode parent = identifier.getParent();
            FunctionDefinition functionDefintion = parent.getAncestor(FunctionDefinition.class);
            if (functionDefintion != null && functionDefintion.getBody() == main && parent instanceof ReferenceExpression && parent.getParent() instanceof MultiplicationExpression) {
                parent.replaceByAndDelete(transformer.parseExpression((ASTNode)identifier, "physics_normal"));
            }
        });
        root.replaceReferenceExpressions(transformer, "yPosDif", "-2.0");
        ShaderInjection.setVariable(root, transformer, "PHYSICS_NORMAL_STRENGTH", "1.4");
    }

    private static void other(SingleASTTransformer<JobParameters> transformer, TranslationUnit translationUnit, Root root, String source) {
        CompoundStatement pbrLighting;
        ShaderInjection.setVariable(root, transformer, "PHYSICS_NORMAL_STRENGTH", "1.4");
        translationUnit.prependMain((ASTParser)transformer, "physics_waveData = physics_wavePixel(physics_localPosition.xz, physics_localWaviness, physics_iterationsNormal, physics_gameTime);");
        CompoundStatement calcWaveNormal = translationUnit.getFunctionDefinitionBody("GetWavesNormal");
        boolean ignoreNormalMatrix = false;
        if (calcWaveNormal != null) {
            root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
            ignoreNormalMatrix = root.replaceReferenceExpressionsReport(transformer, "tbn", "mat3(1.0)");
            if (ignoreNormalMatrix) {
                translationUnit.appendMain((ASTParser)transformer, "if (physics_waveData.foam > 0.2) { " + outputColor1 + " = vec4(physics_foamColor, 1.0);" + outputColor0 + " = vec4(EncodeNormal(normal), EncodeVec2(lmcoord.x, lmcoord.y), EncodeVec2(1.0, f0), 1.0); }");
            } else {
                translationUnit.appendMain((ASTParser)transformer, "if (physics_waveData.foam > 0.2) { " + outputColor4 + " = vec4(physics_foamColor, 1.0); " + outputColor2 + ".b = 7.0 / 255.0; }");
            }
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("calcBump")) != null) {
            root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
            translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("GetWaterNormal")) != null) {
            root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
            translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("getWaterNormal")) != null) {
            root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
            if (root.identifierIndex.get("tbnMatrixWorld").size() > 0) {
                ignoreNormalMatrix = true;
            } else {
                calcWaveNormal.getStatements().clear();
                calcWaveNormal.getStatements().addAll(transformer.parseStatements(calcWaveNormal, "newNormal = normalize(" + normalMatrix + " * physics_waveData.normal);"));
                translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
                return;
            }
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("getWaveHeight")) != null) {
            root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
            translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
            translationUnit.appendMain((ASTParser)transformer, outputColor1 + " = mix(" + outputColor1 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("get_normals")) != null) {
            translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("noiseNormals")) != null) {
            root.replaceReferenceExpressions(transformer, "tbn", "mat3(1.0)");
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("waterNormal")) != null) {
            if (source.contains("sceneDataB")) {
                translationUnit.appendMain((ASTParser)transformer, "translucentColor = clamp(mix(sceneColor, vec4(5.0 * physics_foamColor, 5.0), physics_waveData.foam), 0.0, 65535.0);");
                translationUnit.appendMain((ASTParser)transformer, "reflectionAux = packReflectionAux(mix(directLight * directCol, vec3(physics_foamColor), physics_waveData.foam), mix(albedo, vec3(1.0), physics_waveData.foam));");
            } else {
                translationUnit.appendMain((ASTParser)transformer, "sceneColor = mix(sceneColor, vec4(5.0 * physics_foamColor, 5.0), physics_waveData.foam);");
                translationUnit.appendMain((ASTParser)transformer, "lightingData = packReflectionAux(mix(directLight, vec3(physics_foamColor), physics_waveData.foam), mix(sceneTint.rgb, vec3(1.0), physics_waveData.foam));");
            }
            root.process(root.identifierIndex.getStream("waterNormal"), identifier -> {
                FunctionDefinition definition = identifier.getBranchAncestor(FunctionDefinition.class, FunctionDefinition::getFunctionPrototype);
                if (definition != null && definition.getFunctionPrototype().getParameters().size() == 0) {
                    CompoundStatement waterNormal = definition.getBody();
                    waterNormal.getStatements().clear();
                    waterNormal.getStatements().addAll(transformer.parseStatements(waterNormal, "return normalize(physics_waveData.normal);"));
                }
            });
            return;
        }
        if (calcWaveNormal == null && (calcWaveNormal = translationUnit.getFunctionDefinitionBody("getNormals")) != null) {
            ignoreNormalMatrix = true;
            translationUnit.appendMain((ASTParser)transformer, outputColor0 + " = mix(" + outputColor0 + ", vec4(physics_foamColor, 1.0), physics_waveData.foam);");
            root.replaceReferenceExpressions(transformer, "tbnMatrix", "mat3(1.0)");
            CompoundStatement waterwavesToNormal = translationUnit.getFunctionDefinitionBody("getNormals");
            waterwavesToNormal.getStatements().clear();
            waterwavesToNormal.getStatements().addAll(transformer.parseStatements(calcWaveNormal, "return normalize(" + normalMatrix + " * physics_waveData.normal);"));
            return;
        }
        if (calcWaveNormal == null && (pbrLighting = translationUnit.getFunctionDefinitionBody("PbrLighting")) != null) {
            pbrLighting.getStatements().addAll(0, transformer.parseStatements(pbrLighting, "vec3 physics_normal = -normalize(" + normalMatrix + " * physics_waveData.normal);"));
            root.process(root.identifierIndex.getStream("waterDX"), identifier -> {
                ASTNode parent = identifier.getParent();
                if (parent instanceof ReferenceExpression) {
                    parent.getParent().getParent().replaceByAndDelete(transformer.parseExpression((ASTNode)identifier, "physics_normal"));
                }
            });
            root.replaceReferenceExpressions(transformer, "matTBN", "mat3(1.0)");
            return;
        }
        if (calcWaveNormal == null && translationUnit.getFunctionDefinitionBody("EncodeArbitrary") != null) {
            translationUnit.prependMain((ASTParser)transformer, "vec3 physics_normal = normalize(" + normalMatrix + " * physics_waveData.normal) * 0.5 + 0.5;");
            root.replaceReferenceExpressions(transformer, "normalTex", "physics_normal");
            root.replaceReferenceExpressions(transformer, "vertexTBN", "mat3(1.0)");
            return;
        }
        if (calcWaveNormal == null) {
            ShaderInjection.printError();
            return;
        }
        calcWaveNormal.getStatements().clear();
        if (ignoreNormalMatrix) {
            calcWaveNormal.getStatements().addAll(transformer.parseStatements(calcWaveNormal, "return normalize(physics_waveData.normal);"));
        } else {
            calcWaveNormal.getStatements().addAll(transformer.parseStatements(calcWaveNormal, "return normalize(" + normalMatrix + " * physics_waveData.normal);"));
        }
    }

    private static void setVariable(Root root, SingleASTTransformer<JobParameters> transformer, String variable, String value) {
        root.process(root.identifierIndex.getStream(variable), identifier -> {
            ASTNode parent = identifier.getParent();
            if (parent instanceof DeclarationMember) {
                DeclarationMember declaration = (DeclarationMember)parent;
                declaration.getInitializer().getAncestor(ExpressionInitializer.class).setExpression(transformer.parseExpression(parent, value));
            }
        });
    }

    private static List<String> getOceanWaveInjection() {
        String asset = "assets/physicsmod/shaders/include/ocean.glsl";
        ObjectArrayList lines = new ObjectArrayList();
        Object all = "";
        int brackets = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isBlank()) continue;
                if (line.contains("{")) {
                    ++brackets;
                }
                if (line.contains("}")) {
                    --brackets;
                }
                all = (String)all + line;
                if (brackets != 0) continue;
                lines.add(all);
                all = "";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static enum ShaderPack {
        COMPLEMENTARY,
        COMPLEMENTARY_REIMAGINED,
        OTHER;

    }
}

