/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.liquid;

import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Pack;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidController;
import net.diebuddies.physics.liquid.SimpleTextureDimension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class WaterController
implements LiquidController {
    private BlockPos pos;
    private AABB aabb;
    private int density;
    private boolean continous;
    private int spawnAmount;
    private int spawnCorner;

    public WaterController(BlockPos pos, int density, boolean continous, int spawnAmount) {
        this.density = density;
        this.continous = continous;
        this.spawnAmount = spawnAmount;
        this.pos = pos;
        this.aabb = new AABB(pos);
    }

    @Override
    public void init(Liquid liquid) {
        SimpleTextureDimension dimension;
        liquid.blockPos = this.pos;
        liquid.density = this.density;
        liquid.damping = 0.0f;
        liquid.range = 1.5;
        liquid.sourceAlive = this.continous;
        liquid.gridSize = this.density;
        liquid.origin = new Vector3d((this.aabb.f_82288_ + this.aabb.f_82291_) * 0.5, (this.aabb.f_82289_ + this.aabb.f_82292_) * 0.5, (this.aabb.f_82290_ + this.aabb.f_82293_) * 0.5);
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(Blocks.f_49990_.m_49966_());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(Blocks.f_49990_.m_49966_());
        }
        int color = BiomeColors.m_108811_((BlockAndTintGetter)liquid.world.getWorld(), (BlockPos)this.pos);
        liquid.color = Pack.color((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(new ResourceLocation("minecraft:textures/block/water_flow.png"));
        if (texture instanceof SimpleTextureDimension && (dimension = (SimpleTextureDimension)texture).getWidth() != dimension.getHeight()) {
            liquid.textureScale.y = (float)dimension.getWidth() / (float)dimension.getHeight();
        }
        liquid.textureScale.mul(0.66666f);
        liquid.textureID = texture.m_117963_();
        double diameter = 1.0 / (double)liquid.density;
        double radius = diameter * 0.5;
        for (int i = 0; i < this.spawnAmount; ++i) {
            for (int x = 0; x < liquid.density; ++x) {
                for (int y = 0; y < liquid.density; ++y) {
                    for (int z = 0; z < liquid.density; ++z) {
                        double xo = diameter * (double)x + radius + this.aabb.f_82288_;
                        double yo = diameter * (double)y + radius + this.aabb.f_82289_;
                        double zo = diameter * (double)z + radius + this.aabb.f_82290_;
                        liquid.spawnParticle(radius, xo, yo, zo);
                    }
                }
            }
        }
    }

    @Override
    public void update(Liquid liquid, double diff) {
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(Blocks.f_49990_.m_49966_());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(Blocks.f_49990_.m_49966_());
        }
        if (liquid.sourceAlive) {
            double diameter = 1.0 / (double)liquid.density;
            double radius = diameter * 0.5;
            boolean x = (this.spawnCorner & 1) == 1;
            boolean y = (this.spawnCorner & 2) == 1;
            boolean z = (this.spawnCorner & 4) == 1;
            int amount = java.lang.Math.round(Math.remap(this.density, 3.0f, 7.0f, 1.0f, 4.0f));
            for (int i = 0; i < amount; ++i) {
                double xo = Math.clamp((double)x, radius, 1.0 - radius) + this.aabb.f_82288_;
                double yo = Math.clamp((double)y, radius, 1.0 - radius) + this.aabb.f_82289_;
                double zo = Math.clamp((double)z, radius, 1.0 - radius) + this.aabb.f_82290_;
                liquid.spawnParticle(radius, xo, yo, zo);
                ++this.spawnCorner;
                this.spawnCorner %= 8;
            }
        }
    }
}

