/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.Vector3i;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.opengl.VertexFormat;
import net.diebuddies.org.joml.Vector2f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.ConvexRigidBody;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsUpdate;
import net.diebuddies.physics.SphereRigidBody;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.vines.DynamicLoader;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.wind.WeatherDomain;
import net.diebuddies.util.DoublyLinkedList;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxJoint;
import physx.physics.PxActor;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

public class PhysicsWorld
implements PhysicsUpdate {
    public static final int TERRAIN = 1;
    public static final int DYNAMIC_OBJECT = 2;
    public static final int KINEMATIC_MOB = 4;
    public static final int ANCHOR = 8;
    public static final int PARTICLES = 16;
    public static final int DYNAMIC_BLOCKS_NO_COLLISION = 32;
    public static final int COLLIDE_NOTHING = 0;
    public static final int COLLIDE_ALL = 23;
    public static final int COLLIDE_ALL_MINUS_ENTITIES = 19;
    public static final int COLLIDE_ALL_MINUS_PARTICLES = 7;
    public static final int COLLIDE_ALL_MINUS_DYANMIC_OBJECTS = 21;
    private static final float FIXED_TIME_STEP = 0.025f;
    public static final int CHUNK_SIZE = 4;
    public static final int CHUNK_SIZE_ONE_BITS = 3;
    public static final int CHUNK_SIZE_NUM_BITS = Integer.bitCount(3);
    public static final int CHUNK_SIZE_RELATIVE_NUM_BITS = Integer.bitCount(3);
    private static final double LIQUID_REMOVAL_DISTANCE = 128.0;
    private static final double LIQUID_REMOVAL_DISTANCE_SQUARED = 16384.0;
    public static final int FREEZE_UPDATE_RAGDOLLS_EVERY_X_TICKS = 20;
    private List<DynamicRagdoll> freezeRagdolls = new ObjectArrayList();
    private Comparator<DynamicRagdoll> freezeComparator = new Comparator<DynamicRagdoll>(){

        @Override
        public int compare(DynamicRagdoll o1, DynamicRagdoll o2) {
            return Double.compare(o1.distanceToCamera, o2.distanceToCamera);
        }
    };
    private int ragdollFreezeRate = 20;
    private DynamicsWorld dynamicsWorld;
    private SnowWorld snowWorld;
    private OceanWorld oceanWorld;
    private SmokeDomain smokeDomain;
    private WeatherDomain weatherDomain;
    private List<Liquid> liquids;
    private DoublyLinkedList<IRigidBody> bodies;
    private DoublyLinkedList<Ragdoll> ragdolls;
    private Set<PhysicsEntity> queueForModelCreation;
    private Map<PxJoint, Tuple<IRigidBody, IRigidBody>> jointParents;
    private List<VerletSimulation> verletSimulations;
    private Level level;
    private Map<PxActor, IRigidBody> bodyLinks;
    private Set<Vector3i> loadedChunks;
    private Object2IntMap<Vector3i> loadedChunkEntities;
    private Map<Vector3i, List<IRigidBody>> chunkBodies;
    private Int2ObjectMap<IRigidBody> worldEntities = new Int2ObjectOpenHashMap();
    private IntSet lastEntityUpdates = new IntOpenHashSet();
    private IntSet tmpSet = new IntOpenHashSet();
    private double renderPercent;
    private List<Explosion> explosions = new ObjectArrayList();
    private Set<Vector3i> chunkUpdates = new ObjectLinkedOpenHashSet();
    private Vector3d offset;
    private long lastSeen;
    private boolean blocksChanged;
    private boolean loadedChunkEntitiesChanged = false;
    private ArenaBuffer modelVertexData;
    public VertexFormat format;
    public int modelVAO = -1;
    private Vector3d center = new Vector3d();

    public PhysicsWorld(Level level) {
        this.smokeDomain = new SmokeDomain(this);
        this.dynamicsWorld = new DynamicsWorld(this, level, 0.025f);
        this.snowWorld = new SnowWorld(level);
        this.oceanWorld = new OceanWorld(this, level);
        this.weatherDomain = new WeatherDomain(this);
        this.jointParents = new Object2ObjectOpenHashMap();
        this.level = level;
        this.ragdolls = new DoublyLinkedList();
        this.liquids = new ObjectArrayList();
        this.bodies = new DoublyLinkedList();
        this.queueForModelCreation = new ObjectLinkedOpenHashSet();
        this.bodyLinks = new Object2ObjectOpenHashMap();
        this.loadedChunks = new ObjectLinkedOpenHashSet();
        this.loadedChunkEntities = new Object2IntOpenHashMap();
        this.loadedChunkEntities.defaultReturnValue(0);
        this.chunkBodies = new Object2ObjectOpenHashMap();
        this.verletSimulations = new ObjectArrayList();
        this.offset = new Vector3d();
        this.lastSeen = System.nanoTime();
    }

    public ArenaBuffer getModelVertexData() {
        if (this.modelVertexData == null) {
            this.createGLObjects();
        }
        return this.modelVertexData;
    }

    public int getGPUMemoryUsage() {
        if (this.modelVertexData == null) {
            return 0;
        }
        return this.modelVertexData.getTotalSize();
    }

    private void createGLObjects() {
        this.modelVAO = GL32C.glGenVertexArrays();
        this.format = StarterClient.iris ? new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL, Data.TANGENT_SHADER, Data.MID_TEX_COORD_SHADER) : (StarterClient.optifabric ? new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL, Data.TANGENT_OPTIFINE, Data.MID_TEX_COORD_OPTIFINE) : new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL));
        this.modelVertexData = new ArenaBuffer(262144 * this.format.getStride());
    }

    public void bindForRendering() {
        if (this.modelVAO == -1) {
            this.createGLObjects();
        }
        StateTracker.bindVertexArray(this.modelVAO);
        this.modelVertexData.bind();
        this.format.bindAttributeFormat();
    }

    public void update(double diff) {
        this.snowWorld.update(diff);
        this.oceanWorld.update(diff);
        boolean willUpdate = this.dynamicsWorld.willUpdate(diff);
        if (this.dynamicsWorld.willUpdate(diff) && this.level instanceof ClientLevel) {
            PerformanceTracker.start("physics_tick_entities");
            ClientLevel clientLevel = (ClientLevel)this.level;
            this.tmpSet.clear();
            for (Entity entity : clientLevel.m_104735_()) {
                Object body;
                LivingEntity living;
                AABB boundingBox;
                if (!(entity instanceof LivingEntity) || (boundingBox = (living = (LivingEntity)entity).m_142469_()) == null || boundingBox.m_82392_() || living.m_5833_()) continue;
                this.center.set(boundingBox.f_82291_ + boundingBox.f_82288_, boundingBox.f_82292_ + boundingBox.f_82289_, boundingBox.f_82293_ + boundingBox.f_82290_).mul(0.5);
                if (!this.lastEntityUpdates.contains(living.m_142049_())) {
                    PhysicsEntity physicsEntity = new PhysicsEntity(PhysicsEntity.Type.MOB, null);
                    physicsEntity.physicsGroup = 4;
                    physicsEntity.physicsMask = 7;
                    physicsEntity.getTransformation().translate(this.center);
                    physicsEntity.getOldTransformation().translate(this.center);
                    body = null;
                    body = entity instanceof AbstractClientPlayer ? BoxRigidBody.createPlayer(physicsEntity, (float)(boundingBox.f_82291_ - boundingBox.f_82288_), (float)(boundingBox.f_82292_ - boundingBox.f_82289_), (float)(boundingBox.f_82293_ - boundingBox.f_82290_), true) : BoxRigidBody.create(physicsEntity, (float)(boundingBox.f_82291_ - boundingBox.f_82288_), (float)(boundingBox.f_82292_ - boundingBox.f_82289_), (float)(boundingBox.f_82293_ - boundingBox.f_82290_), 0.0f, 0.0f, 0.0f, true);
                    ((IRigidBody)body).setKinematic(true);
                    ((IRigidBody)body).setGravity(false);
                    this.dynamicsWorld.addActor(((IRigidBody)body).getRigidBody());
                    this.worldEntities.put(living.m_142049_(), body);
                }
                IRigidBody ibody = (IRigidBody)this.worldEntities.get(living.m_142049_());
                if (!ibody.destroyed) {
                    body = (PxRigidDynamic)ibody.getRigidBody();
                    try (MemoryStack mem = MemoryStack.stackPush();){
                        ((PxRigidDynamic)body).setKinematicTarget(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(this.center.x - this.offset.x), (float)(this.center.y - this.offset.y), (float)(this.center.z - this.offset.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
                    }
                }
                this.tmpSet.add(living.m_142049_());
            }
            this.lastEntityUpdates.removeAll((IntCollection)this.tmpSet);
            IntIterator it = this.lastEntityUpdates.iterator();
            while (it.hasNext()) {
                int id = it.nextInt();
                IRigidBody body = (IRigidBody)this.worldEntities.remove(id);
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
            IntSet tmp = this.lastEntityUpdates;
            this.lastEntityUpdates = this.tmpSet;
            this.tmpSet = tmp;
            PerformanceTracker.end("physics_tick_entities");
        }
        if (willUpdate) {
            PerformanceTracker.start("physics_tick_physx");
        }
        int updateCount = this.dynamicsWorld.update(this, diff);
        if (willUpdate) {
            PerformanceTracker.end("physics_tick_physx");
        }
        this.renderPercent = this.dynamicsWorld.getTime() / (double)this.dynamicsWorld.getFixedTimeStep();
        if (updateCount > 0) {
            PerformanceTracker.start("physics_tick");
            Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            float updateDiff = (float)updateCount * this.dynamicsWorld.getFixedTimeStep();
            Iterator<IRigidBody> it = this.bodies.iterator();
            while (it.hasNext()) {
                IRigidBody body = it.next();
                if (body.isDestroyed()) {
                    it.remove();
                    continue;
                }
                if (body.isKinematicOrFrozen()) continue;
                body.updateTransformations(this, updateDiff);
                PhysicsEntity entity = body.getEntity();
                if (entity.type != PhysicsEntity.Type.VINE) {
                    entity.time -= (double)updateDiff;
                }
                if (body.separateController || !(entity.time <= 0.0)) continue;
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
                if (body.getLastChunk() != null && !body.isKinematicOrFrozen()) {
                    this.removeLoadedChunkEntity(body.getLastChunk());
                }
                entity.spawnDeathAnimation(this);
                this.bodyLinks.remove(body.getRigidBody());
                it.remove();
            }
            if (this.ragdollFreezeRate <= 0) {
                this.freezeUpdate();
                this.ragdollFreezeRate = 20;
            }
            --this.ragdollFreezeRate;
            Iterator<Liquid> itL = this.liquids.iterator();
            while (itL.hasNext()) {
                Liquid liquid = itL.next();
                if (liquid.update(this.dynamicsWorld.getFixedTimeStep())) {
                    itL.remove();
                    liquid.destroy();
                    continue;
                }
                if (!(cameraPos.m_82531_((double)liquid.blockPos.m_123341_(), (double)liquid.blockPos.m_123342_(), (double)liquid.blockPos.m_123343_()) > 16384.0)) continue;
                liquid.remove(this);
                itL.remove();
                liquid.destroy();
            }
            Iterator<Explosion> itE = this.explosions.iterator();
            while (itE.hasNext()) {
                Explosion explosion = itE.next();
                if (explosion.tickDelay == 0) {
                    this.executeExplosion(explosion);
                    itE.remove();
                }
                --explosion.tickDelay;
            }
            Iterator<Ragdoll> itR = this.ragdolls.iterator();
            int ragdollSize = this.ragdolls.size();
            int mobRagdollCount = 0;
            for (int i = 0; i < ragdollSize; ++i) {
                Ragdoll ragdoll = itR.next();
                if (ragdoll.isKinematic()) continue;
                boolean destroyRagdoll = true;
                boolean isDespawning = false;
                List<IRigidBody> bodies = ragdoll.btBodies;
                int size = bodies.size();
                for (int j = 0; j < size; ++j) {
                    IRigidBody body = bodies.get(j);
                    PhysicsEntity entity = body.getEntity();
                    isDespawning |= entity.isDespawning();
                    if (entity.time >= 0.0) {
                        destroyRagdoll = false;
                        break;
                    }
                    entity.spawnDeathAnimation(this);
                }
                if (destroyRagdoll) {
                    itR.remove();
                    ragdoll.remove(this);
                    ragdoll.destroy();
                    continue;
                }
                if (ragdoll instanceof DynamicRagdoll || isDespawning) continue;
                ++mobRagdollCount;
            }
            if (mobRagdollCount > ConfigClient.mobRagdollLimit) {
                int amountToRemove = mobRagdollCount - ConfigClient.mobRagdollLimit;
                itR = this.ragdolls.iterator();
                for (int i = 0; i < amountToRemove; ++i) {
                    Ragdoll ragdoll = itR.next();
                    if (ragdoll instanceof DynamicRagdoll) {
                        --i;
                        continue;
                    }
                    List<IRigidBody> bodies = ragdoll.btBodies;
                    int size = bodies.size();
                    for (int j = 0; j < size; ++j) {
                        IRigidBody body = bodies.get(j);
                        PhysicsEntity entity = body.getEntity();
                        entity.startDespawnAnimation(this.level);
                    }
                }
            }
            PerformanceTracker.end("physics_tick");
        }
        this.chunkUpdates.clear();
    }

    @Override
    public void physicsUpdate(double diff) {
        this.checkChunksToUnload();
        this.smokeDomain.update(diff);
        this.weatherDomain.update(diff);
        for (IRigidBody body : this.bodies) {
            if (body.isKinematicOrFrozen() || body.isDestroyed()) continue;
            body.updatePhysics(this, diff, this.blocksChanged);
        }
        this.blocksChanged = false;
        this.checkLoadedChunks();
        this.loadedChunkEntitiesChanged = false;
    }

    private void freezeUpdate() {
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        this.freezeRagdolls.clear();
        for (Ragdoll r : this.ragdolls) {
            r.updatePhysics(this);
            if (!(r instanceof DynamicRagdoll)) continue;
            DynamicRagdoll dynamicRagdoll = (DynamicRagdoll)r;
            if (dynamicRagdoll.aabb == null || dynamicRagdoll.initFreeze) continue;
            dynamicRagdoll.updateCameraDistance(cameraPos);
            this.freezeRagdolls.add(dynamicRagdoll);
        }
        Collections.sort(this.freezeRagdolls, this.freezeComparator);
        for (int i = 0; i < this.freezeRagdolls.size(); ++i) {
            DynamicRagdoll ragdoll = this.freezeRagdolls.get(i);
            if (i < ConfigClient.maxLoadedDynamicBlocks) {
                if (ragdoll.isFrozen()) {
                    ragdoll.wakeUp();
                }
                ragdoll.setFrozen(false);
                continue;
            }
            ragdoll.setFrozen(true);
        }
    }

    private void checkLoadedChunks() {
        if (!this.loadedChunkEntitiesChanged) {
            return;
        }
        for (Object2IntMap.Entry entry : this.loadedChunkEntities.object2IntEntrySet()) {
            boolean wasLoaded;
            Vector3i chunk = (Vector3i)entry.getKey();
            int amount = entry.getIntValue();
            if (amount == 0 || this.loadedChunks.contains(chunk) || !(wasLoaded = this.loadChunk(chunk))) continue;
            this.loadedChunks.add(chunk);
        }
    }

    private void checkChunksToUnload() {
        if (!this.loadedChunkEntitiesChanged) {
            return;
        }
        Iterator<Vector3i> it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            Vector3i chunk = it.next();
            if (this.loadedChunkEntities.getInt((Object)chunk) > 0) continue;
            this.unloadChunk(chunk);
            it.remove();
        }
    }

    public void addLoadedChunkEntity(Vector3i chunk) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.addLoadedChunkEntityOffset(new Vector3i(chunk.x + x, chunk.y + y, chunk.z + z));
                }
            }
        }
    }

    private void addLoadedChunkEntityOffset(Vector3i loaded) {
        int amount = this.loadedChunkEntities.getInt((Object)loaded);
        this.loadedChunkEntities.put((Object)loaded, amount + 1);
        this.loadedChunkEntitiesChanged = true;
    }

    public void removeLoadedChunkEntity(Vector3i chunk) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.removeLoadedChunkEntityOffset(new Vector3i(chunk.x + x, chunk.y + y, chunk.z + z));
                }
            }
        }
    }

    public void removeLoadedChunkEntityOffset(Vector3i chunk) {
        int amount = this.loadedChunkEntities.getInt((Object)chunk);
        this.loadedChunkEntities.put((Object)chunk, amount - 1);
        this.loadedChunkEntitiesChanged = true;
    }

    private void unloadChunk(Vector3i chunkPos) {
        List<IRigidBody> bodies = this.chunkBodies.remove(chunkPos);
        if (bodies != null) {
            for (int i = 0; i < bodies.size(); ++i) {
                IRigidBody body = bodies.get(i);
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
        }
    }

    public void blockUpdate(BlockPos pos) {
        this.blocksChanged = true;
        BlockState state = this.level.m_8055_(pos);
        this.weatherDomain.blockUpdate(pos);
        for (int i = 0; i < this.liquids.size(); ++i) {
            this.liquids.get(i).blockUpdate(this, pos, state);
        }
        Ragdoll changed = null;
        for (Ragdoll ragdoll : this.ragdolls) {
            if (!ragdoll.blockUpdate(this, pos, state)) continue;
            changed = ragdoll;
            break;
        }
        int cx = pos.m_123341_() >> CHUNK_SIZE_NUM_BITS;
        int cy = pos.m_123342_() >> CHUNK_SIZE_NUM_BITS;
        int cz = pos.m_123343_() >> CHUNK_SIZE_NUM_BITS;
        int ax = pos.m_123341_() & 3;
        int ay = pos.m_123342_() & 3;
        int az = pos.m_123343_() & 3;
        this.updateChunk(cx, cy, cz);
        if (ax == 0) {
            this.updateChunk(cx - 1, cy, cz);
        }
        if (ay == 0) {
            this.updateChunk(cx, cy - 1, cz);
        }
        if (az == 0) {
            this.updateChunk(cx, cy, cz - 1);
        }
        if (ax == 3) {
            this.updateChunk(cx + 1, cy, cz);
        }
        if (ay == 3) {
            this.updateChunk(cx, cy + 1, cz);
        }
        if (az == 3) {
            this.updateChunk(cx, cy, cz + 1);
        }
    }

    private void updateChunk(int cx, int cy, int cz) {
        Vector3i chunkPos = new Vector3i(cx, cy, cz);
        if (this.chunkUpdates.contains(chunkPos)) {
            return;
        }
        this.chunkUpdates.add(chunkPos);
        if (this.loadedChunks.contains(chunkPos)) {
            this.unloadChunk(chunkPos);
            this.loadChunk(chunkPos);
        }
    }

    private boolean loadChunk(Vector3i chunkPos) {
        if (chunkPos.y < this.level.m_141937_() || chunkPos.y >= this.level.m_151558_() >> CHUNK_SIZE_NUM_BITS) {
            return true;
        }
        int chunkX = chunkPos.x >> CHUNK_SIZE_RELATIVE_NUM_BITS;
        int chunkZ = chunkPos.z >> CHUNK_SIZE_RELATIVE_NUM_BITS;
        if (this.level.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false) == null) {
            return false;
        }
        ObjectArrayList bodies = this.chunkBodies.get(chunkPos);
        if (bodies == null) {
            bodies = new ObjectArrayList();
            this.chunkBodies.put(chunkPos, (List<IRigidBody>)bodies);
        }
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    BlockPos pos = new BlockPos(chunkPos.x * 4 + x, chunkPos.y * 4 + y, chunkPos.z * 4 + z);
                    BlockState state = this.level.m_8055_(pos);
                    VoxelShape voxelShape = state.m_60812_((BlockGetter)this.level, pos);
                    if (voxelShape.m_83281_() || VineHelper.getSetting(state) != null || !this.areNeighboursEmpty(this.level, pos)) continue;
                    for (AABB aabb : voxelShape.m_83299_()) {
                        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.OTHER, null);
                        double width = aabb.f_82291_ - aabb.f_82288_;
                        double height = aabb.f_82292_ - aabb.f_82289_;
                        double depth = aabb.f_82293_ - aabb.f_82290_;
                        entity.getTransformation().translate((double)pos.m_123341_() + aabb.f_82288_ + width / 2.0 - this.offset.x, (double)pos.m_123342_() + aabb.f_82289_ + height / 2.0 - this.offset.y, (double)pos.m_123343_() + aabb.f_82290_ + depth / 2.0 - this.offset.z);
                        entity.physicsGroup = 1;
                        BoxRigidBody body = BoxRigidBody.create(entity, (float)width, (float)height, (float)depth, 0.0f, 0.0f, 0.0f, false);
                        this.dynamicsWorld.addActor(body.getRigidBody());
                        bodies.add(body);
                    }
                }
            }
        }
        return true;
    }

    private boolean areNeighboursEmpty(Level level, BlockPos pos) {
        return pos.m_123342_() >= level.m_151558_() || pos.m_123342_() <= level.m_141937_() || pos.m_123342_() < level.m_151558_() - 1 && this.isTranslucent(level, pos.m_7494_()) || pos.m_123342_() > level.m_141937_() && this.isTranslucent(level, pos.m_7495_()) || this.isTranslucent(level, pos.m_142127_()) || this.isTranslucent(level, pos.m_142126_()) || this.isTranslucent(level, pos.m_142128_()) || this.isTranslucent(level, pos.m_142125_());
    }

    private boolean isTranslucent(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return !Block.m_49916_((VoxelShape)state.m_60808_((BlockGetter)level, pos)) || state.m_60812_((BlockGetter)level, pos).m_83281_();
    }

    public void destroy() {
        VAO.storePreviouslyBoundState();
        if (this.level instanceof ClientLevel) {
            ((DynamicLoader)((ClientLevel)this.level).m_7726_()).setPhysicsMod(null);
        }
        this.snowWorld.destroy();
        this.oceanWorld.destroy();
        for (IRigidBody iRigidBody : this.bodies) {
            if (iRigidBody.separateController) continue;
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (IRigidBody iRigidBody : this.worldEntities.values()) {
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (Ragdoll ragdoll : this.ragdolls) {
            ragdoll.remove(this);
            ragdoll.destroy();
        }
        for (Liquid liquid : this.liquids) {
            liquid.destroy();
        }
        this.smokeDomain.destroy();
        for (Map.Entry entry : this.chunkBodies.entrySet()) {
            for (IRigidBody body : (List)entry.getValue()) {
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
        }
        if (this.modelVertexData != null) {
            this.modelVertexData.destroy();
        }
        if (this.modelVAO != -1) {
            GL32C.glDeleteVertexArrays((int)this.modelVAO);
        }
        for (VerletSimulation verletSimulation : this.getVerletSimulations()) {
            verletSimulation.destroyed = true;
        }
        this.getVerletSimulations().clear();
        this.dynamicsWorld.destroy();
        this.ragdolls.clear();
        this.chunkBodies.clear();
        this.loadedChunks.clear();
        this.bodies.clear();
        this.bodyLinks.clear();
        VAO.restorePreviouslyBoundState();
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle, @Nullable List<Mesh> brokenPhysicsBlock, @Nullable List<IRigidBody> result, boolean enforcePhysicsBoxes) {
        if (particle.noVolume) {
            return;
        }
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        for (int i = 0; i < brokenBlock.size(); ++i) {
            Mesh mesh = brokenBlock.get(i);
            PhysicsEntity broken = new PhysicsEntity(particle.type, particle.info);
            broken.models.get((int)0).texture = particle.models.get((int)0).texture;
            broken.models.get((int)0).textureID = particle.models.get((int)0).textureID;
            broken.color = particle.color;
            broken.backfaceCulling = particle.backfaceCulling;
            broken.shade = particle.shade;
            if (particle.min.equals(0.0, 0.0, 0.0) && particle.max.equals(1.0, 1.0, 1.0)) {
                broken.models.get((int)0).mesh = mesh;
                if (brokenPhysicsBlock != null) {
                    broken.models.get((int)0).physicsMesh = brokenPhysicsBlock.get(i);
                }
            } else {
                broken.models.get((int)0).mesh = this.scale(mesh, particle.min, particle.max);
                if (brokenPhysicsBlock != null) {
                    broken.models.get((int)0).physicsMesh = this.scalePositionOnly(brokenPhysicsBlock.get(i), particle.min, particle.max);
                    broken.models.get((int)0).physicsMesh.offset = new Vector3d(broken.models.get((int)0).mesh.offset);
                }
            }
            broken.getTransformation().set(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(broken.models.get((int)0).mesh.offset);
            broken.getOldTransformation().set(broken.getTransformation());
            broken.scale = particle.scale;
            broken.time = PhysicsWorld.calculateLifetime(particle);
            IRigidBody body = null;
            body = enforcePhysicsBoxes ? BoxRigidBody.create(broken, true) : ConvexRigidBody.create(broken, true);
            this.addBody(body);
            if (result != null) {
                result.add(body);
            }
            this.dynamicsWorld.addActor(body.getRigidBody());
            body.applyRandomSpawnForces();
        }
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle, List<IRigidBody> result) {
        this.addBlockParticle(brokenBlock, particle, null, result, false);
    }

    public void addBlockParticle(List<Mesh> brokenBlock, @Nullable List<Mesh> brokenPhysicsBlock, PhysicsEntity particle) {
        this.addBlockParticle(brokenBlock, particle, brokenPhysicsBlock, null, false);
    }

    public static double calculateLifetime(PhysicsEntity particle) {
        double time = 0.0;
        switch (particle.type) {
            case MOB: {
                time = particle.lifetime + (double)Math.random() * particle.lifetimeVariance;
                break;
            }
            case BLOCK: {
                time = particle.lifetime + (double)Math.random() * particle.lifetimeVariance;
                break;
            }
            case VINE: {
                time = ConfigClient.particleLifetimeVines + (double)Math.random() * ConfigClient.particleLifetimeVarianceVines;
                break;
            }
            case ITEM: {
                time = ConfigClient.particleLifetimeItems + (double)Math.random() * ConfigClient.particleLifetimeVarianceItems;
                break;
            }
            case PARTICLE: {
                time = ConfigClient.particleLifetimeParticles + (double)Math.random() * ConfigClient.particleLifetimeVarianceParticles;
                break;
            }
            case LIQUID: {
                time = ConfigClient.particleLifetimeLiquids + (double)Math.random() * ConfigClient.particleLifetimeVarianceLiquids;
                break;
            }
            case SMOKE: {
                time = ConfigClient.particleLifetimeSmoke + (double)Math.random() * ConfigClient.particleLifetimeVarianceSmoke;
                break;
            }
            default: {
                time = 4.0 + (double)Math.random() * 3.0;
            }
        }
        return java.lang.Math.max(particle.getDespawnSpeed(), time);
    }

    private Mesh scale(Mesh mesh, Vector3d min, Vector3d max) {
        Mesh scaled = new Mesh();
        List<Integer> sides = mesh.calculateFaceDirections();
        int count = 1;
        for (int i = 0; i < mesh.indices.size(); ++i) {
            net.diebuddies.org.joml.Vector3i index = mesh.indices.get(i);
            Vector3d pos = mesh.positions.get(index.x - 1);
            Vector2f uv = new Vector2f(mesh.uvs.get(index.y - 1));
            Vector3f normal = mesh.normals.get(index.z - 1);
            Integer side = sides.get(index.z - 1);
            double posX = Math.clamp(Math.remapClamp(pos.x + mesh.offset.x, -0.5, 0.5, min.x, max.x), 0.0, 1.0);
            double posY = Math.clamp(Math.remapClamp(pos.y + mesh.offset.y, -0.5, 0.5, min.y, max.y), 0.0, 1.0);
            double posZ = Math.clamp(Math.remapClamp(pos.z + mesh.offset.z, -0.5, 0.5, min.z, max.z), 0.0, 1.0);
            if (side == 4 || side == 5) {
                uv.set(posX, posZ);
            } else if (side == 1 || side == 3) {
                uv.set(1.0 - posZ, 1.0 - posY);
            } else if (side == 0 || side == 2) {
                uv.set(posX, 1.0 - posY);
            }
            if (mesh.colors.size() > 0) {
                scaled.colors.add(mesh.colors.getInt(index.x - 1));
            }
            scaled.indices.add(new net.diebuddies.org.joml.Vector3i(count));
            scaled.uvs.add(uv);
            scaled.normals.add(new Vector3f(normal));
            scaled.positions.add(new Vector3d(Math.remap(pos.x + 0.5 + mesh.offset.x, 0.0, 1.0, min.x, max.x) - 0.5, Math.remap(pos.y + 0.5 + mesh.offset.y, 0.0, 1.0, min.y, max.y) - 0.5, Math.remap(pos.z + 0.5 + mesh.offset.z, 0.0, 1.0, min.z, max.z) - 0.5));
            ++count;
        }
        if (mesh.tangents != null && StarterClient.iris || StarterClient.optifabric) {
            scaled.calculatePBRData(false);
        }
        scaled.calculateOffset(false);
        return scaled;
    }

    private Mesh scalePositionOnly(Mesh mesh, Vector3d min, Vector3d max) {
        Mesh scaled = new Mesh();
        for (int i = 0; i < mesh.indices.size(); ++i) {
            int index = mesh.indices.get((int)i).x - 1;
            Vector3d pos = mesh.positions.get(index);
            scaled.positions.add(new Vector3d(Math.remap(pos.x + 0.5 + mesh.offset.x, 0.0, 1.0, (double)((float)min.x), (double)((float)max.x)) - 0.5, Math.remap(pos.y + 0.5 + mesh.offset.y, 0.0, 1.0, (double)((float)min.y), (double)((float)max.y)) - 0.5, Math.remap(pos.z + 0.5 + mesh.offset.z, 0.0, 1.0, (double)((float)min.z), (double)((float)max.z)) - 0.5));
        }
        return scaled;
    }

    public void addRagdoll(Ragdoll ragdoll) {
        ragdoll.add(this);
        this.ragdolls.add(ragdoll);
    }

    public void removeRagdoll(Ragdoll ragdoll) {
        ragdoll.remove(this);
        this.ragdolls.remove(ragdoll);
        ragdoll.destroy();
    }

    public void addLiquid(Liquid liquid) {
        liquid.add(this);
        this.liquids.add(liquid);
    }

    public void removeLiquid(Liquid liquid) {
        liquid.remove(this);
        this.liquids.remove(liquid);
        liquid.destroy();
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle, PxRigidActor actor) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().set(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(particle.models.get((int)0).mesh.offset);
        particle.getOldTransformation().set(particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        IRigidBody body = null;
        body = particle.models.get((int)0).mesh == PhysicsMod.brokenBlock.get(0) && actor == null ? BoxRigidBody.create(particle, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, !particle.staticPhysics) : ConvexRigidBody.create(particle, actor, !particle.staticPhysics);
        this.addBody(body);
        if (actor == null) {
            this.dynamicsWorld.addActor(body.getRigidBody());
        }
        return body;
    }

    public IRigidBody addPhysicsSphere(PhysicsEntity particle, float radius) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().set(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z);
        if (particle.models != null) {
            particle.getTransformation().translate(particle.models.get((int)0).mesh.offset);
        }
        particle.getOldTransformation().set(particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        SphereRigidBody body = SphereRigidBody.create(particle, radius, true);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addSmokeSphere(PhysicsEntity particle, float radius) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().translateLocal(-this.offset.x, -this.offset.y, -this.offset.z);
        particle.getOldTransformation().set(particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        SphereRigidBody body = SphereRigidBody.createFastSphere(particle, radius, true, 0.0f, 0.0f, 0.95f, 0.01f);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addBlockParticle(child, null);
        }
        return this.addBlockParticle(particle, null);
    }

    private IRigidBody addSingleBlockParticleBox(PhysicsEntity particle) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().set(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(particle.models.get((int)0).mesh.offset);
        particle.getOldTransformation().set(particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        BoxRigidBody body = BoxRigidBody.createFromConvexWithOffset(particle, true);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addBlockParticleBox(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addSingleBlockParticleBox(child);
        }
        return this.addSingleBlockParticleBox(particle);
    }

    public DoublyLinkedList<IRigidBody> getBodies() {
        return this.bodies;
    }

    public void addBody(IRigidBody body) {
        this.queueForModelCreation.add(body.getEntity());
        this.bodies.add(body);
        this.bodyLinks.put(body.getRigidBody(), body);
    }

    public void removeBody(IRigidBody body) {
        this.bodies.remove(body);
        this.queueForModelCreation.remove(body.getEntity());
        this.bodyLinks.remove(body.getRigidBody());
    }

    public IRigidBody getBody(PxActor actor) {
        return this.bodyLinks.get(actor);
    }

    public Map<Vector3i, List<IRigidBody>> getChunkBodies() {
        return this.chunkBodies;
    }

    public double getRenderPercent() {
        return this.renderPercent;
    }

    public Set<PhysicsEntity> getQueueForModelCreation() {
        return this.queueForModelCreation;
    }

    public void applyExplosion(Explosion explosion) {
        this.explosions.add(explosion);
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void executeExplosion(Explosion explosion) {
        Vector3d tmp = new Vector3d();
        double explosionStrengthSquared = (double)explosion.strength * 2.0 * ((double)explosion.strength * 2.0);
        for (IRigidBody body : this.bodies) {
            double distanceSquared = explosion.position.distanceSquared(body.getEntity().getTransformation().getTranslation(tmp).add(this.offset));
            if (!(distanceSquared <= explosionStrengthSquared)) continue;
            double distance = java.lang.Math.sqrt(distanceSquared);
            Vector3d direction = body.getEntity().getTransformation().getTranslation(tmp).add(this.offset).sub(explosion.position).normalize();
            direction.y += 2.0;
            direction.normalize();
            double realStrength = 1.0 - Math.clamp(distance / ((double)explosion.strength * 2.0), 0.0, 1.0);
            realStrength *= 15.0;
            if (!(body.getRigidBody() instanceof PxRigidBody)) continue;
            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
            if (rigidBody instanceof PxRigidDynamic) {
                ((PxRigidDynamic)rigidBody).wakeUp();
            }
            PxVec3 v = rigidBody.getLinearVelocity();
            float vx = MemoryUtil.memGetFloat((long)v.getAddress());
            float vy = MemoryUtil.memGetFloat((long)(v.getAddress() + 4L));
            float vz = MemoryUtil.memGetFloat((long)(v.getAddress() + 8L));
            v.setX(vx + (float)(direction.x * realStrength));
            v.setY(vy + (float)(direction.y * realStrength));
            v.setZ(vz + (float)(direction.z * realStrength));
            rigidBody.setLinearVelocity(v);
        }
    }

    public void updateLastSeen() {
        this.lastSeen = System.nanoTime();
    }

    public boolean isActive() {
        return System.nanoTime() - this.lastSeen <= 5000000000L;
    }

    public Level getWorld() {
        return this.level;
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public DoublyLinkedList<Ragdoll> getRagdolls() {
        return this.ragdolls;
    }

    public void addVerletSimulation(int index, VerletSimulation simulation) {
        this.verletSimulations.add(index, simulation);
    }

    public void addVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.add(simulation);
    }

    public void removeVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.remove(simulation);
    }

    public List<VerletSimulation> getVerletSimulations() {
        return this.verletSimulations;
    }

    public List<Liquid> getLiquids() {
        return this.liquids;
    }

    public SnowWorld getSnowWorld() {
        return this.snowWorld;
    }

    public void setSnowWorld(SnowWorld snowWorld) {
        this.snowWorld = snowWorld;
    }

    public OceanWorld getOceanWorld() {
        return this.oceanWorld;
    }

    public void setOceanWorld(OceanWorld oceanWorld) {
        this.oceanWorld = oceanWorld;
    }

    public SmokeDomain getSmokeDomain() {
        return this.smokeDomain;
    }

    public Level getLevel() {
        return this.level;
    }

    public WeatherDomain getWeatherDomain() {
        return this.weatherDomain;
    }

    public void addJointParents(PxJoint joint, Tuple<IRigidBody, IRigidBody> tuple) {
        this.jointParents.put(joint, tuple);
    }

    public void removeJointParents(PxJoint joint) {
        this.jointParents.remove(joint);
    }

    public Tuple<IRigidBody, IRigidBody> getJointParents(PxJoint joint) {
        return this.jointParents.get(joint);
    }

    private static /* synthetic */ int lambda$blockUpdate$1(BlockPos a, BlockPos b) {
        return -Integer.compare(a.m_123342_(), b.m_123342_());
    }

    private static /* synthetic */ int lambda$blockUpdate$0(BlockPos a, BlockPos b) {
        return Integer.compare(a.m_123342_(), b.m_123342_());
    }
}

