/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigAnimations;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.math.Math;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Matrix4f;
import net.diebuddies.org.joml.Quaterniond;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.ParticleSpawn;
import net.diebuddies.physics.settings.blocks.BlockSetting;
import net.diebuddies.physics.settings.mobs.MobSetting;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class PhysicsEntity {
    private final Matrix4d transformation;
    private final Matrix4d oldTransformation;
    private final Matrix4f renderTransformation = new Matrix4f();
    private Quaterniond rotation;
    private Quaterniond oldRotation;
    public List<Model> models = new ObjectArrayList();
    public Type type;
    public double time;
    public final Vector3d min = new Vector3d(0.0);
    public final Vector3d max = new Vector3d(1.0);
    public final Vector3d pivot = new Vector3d();
    public double scale = 1.0;
    public int color = -1;
    public final Vector3d scalePhysics = new Vector3d(1.0);
    public final Vector3f enlargeHitbox = new Vector3f(1.0f);
    public int physicsGroup = 2;
    public int physicsMask = 23;
    public boolean noVolume;
    public boolean backfaceCulling = true;
    public boolean staticPhysics = false;
    public boolean shade = true;
    public Object info;
    public SoundType sound;
    public long lastSoundTime = 0L;
    public RenderLayer feature = null;
    private int cachedBrightness;
    private BlockPos.MutableBlockPos cachedBrightnessPos;
    public double lifetime;
    public double lifetimeVariance;
    private Animation animation;
    private boolean dead;
    private double boundingSphereRadius = -1.0;
    public List<PhysicsEntity> children = new ObjectArrayList();

    public PhysicsEntity(Type type, Object info) {
        this.info = info;
        this.animation = ConfigAnimations.DEFAULT_ANIMATION;
        if (info != null) {
            if (info instanceof BlockState) {
                BlockState state = (BlockState)info;
                this.sound = state.m_60734_().m_49962_(state);
                if (type == Type.BLOCK || type == Type.VINE) {
                    BlockSetting blockSetting = ConfigBlocks.getBlockSetting(state.m_60734_());
                    if (type != Type.VINE) {
                        this.scale = blockSetting.getScale();
                    }
                    this.animation = blockSetting.getAnimation();
                    this.lifetime = blockSetting.getLifetime();
                    this.lifetimeVariance = blockSetting.getLifetimeVariance();
                }
            } else if (info instanceof EntityType) {
                EntityType entityType = (EntityType)info;
                if (type == Type.MOB) {
                    MobSetting mobSetting = ConfigMobs.getMobSetting(entityType);
                    this.animation = mobSetting.getAnimation();
                    this.lifetime = mobSetting.getLifetime();
                    this.lifetimeVariance = mobSetting.getLifetimeVariance();
                }
            }
        }
        this.transformation = new Matrix4d();
        this.oldTransformation = new Matrix4d();
        this.models.add(new Model());
        this.type = type;
    }

    public Matrix4d getTransformation() {
        return this.transformation;
    }

    public Matrix4d getOldTransformation() {
        return this.oldTransformation;
    }

    public Matrix4f getRenderTransformation() {
        return this.renderTransformation;
    }

    public Quaterniond getRotation() {
        return this.rotation;
    }

    public Quaterniond getOldRotation() {
        return this.oldRotation;
    }

    public void setRotation(Quaterniond rotation) {
        this.rotation = rotation;
    }

    public void setOldRotation(Quaterniond oldRotation) {
        this.oldRotation = oldRotation;
    }

    public double getBoundingSphereRadius() {
        if (this.boundingSphereRadius < 0.0) {
            for (int i = 0; i < this.models.size(); ++i) {
                this.boundingSphereRadius = java.lang.Math.max(this.boundingSphereRadius, this.models.get((int)i).mesh.getRadius());
            }
            this.boundingSphereRadius *= java.lang.Math.max(this.scalePhysics.x, java.lang.Math.max(this.scalePhysics.y, this.scalePhysics.z)) * this.scale;
        }
        return this.boundingSphereRadius;
    }

    public void destroy() {
        this.destroyModels();
    }

    public void destroyModels() {
        if (this.models != null) {
            for (int i = 0; i < this.models.size(); ++i) {
                Model model = this.models.get(i);
                if (model.memorySegment == null) continue;
                model.memorySegment.free();
                model.memorySegment = null;
            }
        }
    }

    public int getLight(Level level, BlockPos.MutableBlockPos blockPos) {
        if (!StarterClient.disableLightingCache) {
            if (this.cachedBrightnessPos == null) {
                this.cachedBrightnessPos = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            } else if (this.cachedBrightnessPos.m_123341_() == blockPos.m_123341_() && this.cachedBrightnessPos.m_123342_() == blockPos.m_123342_() && this.cachedBrightnessPos.m_123343_() == blockPos.m_123343_()) {
                return this.cachedBrightness;
            }
        }
        BlockState bState = level.m_8055_((BlockPos)blockPos);
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        int brightness = 0;
        if (!bState.m_60815_()) {
            brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
        } else {
            bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y + 1, z));
            if (!bState.m_60815_()) {
                brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
            } else {
                bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y - 1, z));
                if (!bState.m_60815_()) {
                    brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                } else {
                    bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y, z - 1));
                    if (!bState.m_60815_()) {
                        brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                    } else {
                        bState = level.m_8055_((BlockPos)blockPos.m_122178_(x + 1, y, z));
                        if (!bState.m_60815_()) {
                            brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                        } else {
                            bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y, z + 1));
                            if (!bState.m_60815_()) {
                                brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                            } else {
                                bState = level.m_8055_((BlockPos)blockPos.m_122178_(x - 1, y, z));
                                if (!bState.m_60815_()) {
                                    brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                                }
                            }
                        }
                    }
                }
            }
        }
        blockPos.m_122178_(x, y, z);
        if (!StarterClient.disableLightingCache) {
            this.cachedBrightness = brightness;
            this.cachedBrightnessPos.m_122178_(x, y, z);
        }
        return brightness;
    }

    public void invalidateBrightness() {
        this.cachedBrightnessPos = null;
    }

    public BlockPos.MutableBlockPos getCachedBrightnessPos() {
        return this.cachedBrightnessPos;
    }

    public double getDespawnSpeed() {
        return this.animation.speed;
    }

    public void spawnDeathAnimation(PhysicsWorld world) {
        if (!this.dead) {
            Level level = world.getWorld();
            List<ParticleSpawn> particleSpawns = this.animation.particleSpawns;
            for (int i = 0; i < particleSpawns.size(); ++i) {
                ParticleSpawn particleSpawn = particleSpawns.get(i);
                if (particleSpawn.particle == null || !((double)Math.random() < particleSpawn.spawnChance)) continue;
                for (int j = 0; j < particleSpawn.amount; ++j) {
                    double halfSpread = particleSpawn.spread * 0.5;
                    double px = this.transformation.m30() + world.getOffset().x + (double)Math.random() * particleSpawn.spread - halfSpread;
                    double py = this.transformation.m31() + world.getOffset().y + (double)Math.random() * particleSpawn.spread - halfSpread;
                    double pz = this.transformation.m32() + world.getOffset().z + (double)Math.random() * particleSpawn.spread - halfSpread;
                    level.m_7106_(particleSpawn.particle, px, py, pz, particleSpawn.vx, particleSpawn.vy, particleSpawn.vz);
                }
                if (particleSpawn.sound == null) continue;
                float pitch = 0.85f * Math.random() * 0.3f;
                level.m_7785_(this.transformation.m30() + world.getOffset().x, this.transformation.m31() + world.getOffset().y, this.transformation.m32() + world.getOffset().z, particleSpawn.sound, SoundSource.HOSTILE, (float)particleSpawn.soundVolume, pitch, true);
            }
            this.dead = true;
        }
    }

    public void startDespawnAnimation(Level level) {
        if (this.time > this.animation.speed) {
            this.time = this.animation.speed;
        }
    }

    public boolean isDespawning() {
        return this.time <= this.animation.speed;
    }

    public float getDespawnScale(Level level) {
        if (this.time > this.animation.speed) {
            return 1.0f;
        }
        if (this.time <= 0.0) {
            return 0.0f;
        }
        return this.animation.getCurve().get((float)(this.time / this.animation.speed));
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public AnimationType getAnimationType() {
        return this.animation.despawnType;
    }

    public static enum Type {
        MOB,
        BLOCK,
        VINE,
        ITEM,
        PARTICLE,
        LIQUID,
        SMOKE,
        OTHER;

    }
}

