/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.dualcontouring.DualContouring3d;
import net.diebuddies.opengl.Pack;
import net.diebuddies.org.joml.Math;
import net.diebuddies.org.joml.Vector2f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.org.joml.Vector3i;
import net.diebuddies.org.joml.Vector4f;

public class Mesh {
    private static final Vector3f[] faceNormals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
    public List<Vector3d> positions = new ObjectArrayList();
    public List<Vector2f> uvs = new ObjectArrayList();
    public List<Vector3f> normals = new ObjectArrayList();
    public IntList colors;
    public ByteList sides;
    public List<Vector4f> tangents;
    public Vector2f midcoord;
    public List<Vector2f> midcoords;
    public List<Vector3i> indices = new ObjectArrayList();
    public List<Vector3i> indicesQuads = new ObjectArrayList();
    public Vector3d offset;
    public double radius = -1.0;

    public Mesh() {
        this.colors = new IntArrayList();
        this.sides = new ByteArrayList();
    }

    public void calculateOffset() {
        this.calculateOffset(false);
    }

    public void calculatePBRData(boolean defaultMidCoord) {
        int i;
        this.midcoords = new ObjectArrayList();
        this.midcoord = new Vector2f();
        this.tangents = new ObjectArrayList();
        for (int i2 = 0; i2 < this.normals.size(); ++i2) {
            this.tangents.add(new Vector4f());
        }
        Vector2f uvmin = new Vector2f(Float.MAX_VALUE);
        Vector2f uvmax = new Vector2f(-3.4028235E38f);
        Vector3d tmp1 = new Vector3d();
        Vector3d tmp2 = new Vector3d();
        for (i = 0; i < this.indices.size(); i += 3) {
            Vector3i i0 = this.indices.get(i);
            Vector3i i1 = this.indices.get(i + 1);
            Vector3i i2 = this.indices.get(i + 2);
            Vector3d v0 = this.positions.get(i0.x - 1);
            Vector3d v1 = this.positions.get(i1.x - 1);
            Vector3d v2 = this.positions.get(i2.x - 1);
            Vector2f uv0 = this.uvs.get(i0.y - 1);
            Vector2f uv1 = this.uvs.get(i1.y - 1);
            Vector2f uv2 = this.uvs.get(i2.y - 1);
            Vector4f t0 = this.tangents.get(i0.z - 1);
            Vector4f t1 = this.tangents.get(i1.z - 1);
            Vector4f t2 = this.tangents.get(i2.z - 1);
            Vector3f normal = this.normals.get(i0.z - 1);
            Vector3d edge1 = v1.sub(v0, tmp1);
            Vector3d edge2 = v2.sub(v0, tmp2);
            float deltaU1 = uv1.x - uv0.x;
            float deltaV2 = uv2.y - uv0.y;
            float deltaU2 = uv2.x - uv0.x;
            float deltaV1 = uv1.y - uv0.y;
            float fdenom = deltaU1 * deltaV2 - deltaU2 * deltaV1;
            float f = fdenom == 0.0f ? 1.0f : 1.0f / fdenom;
            float tangentx = f * (deltaV2 * (float)edge1.x - deltaV1 * (float)edge2.x);
            float tangenty = f * (deltaV2 * (float)edge1.y - deltaV1 * (float)edge2.y);
            float tangentz = f * (deltaV2 * (float)edge1.z - deltaV1 * (float)edge2.z);
            float tcoeff = DualContouring3d.rsqrt(tangentx * tangentx + tangenty * tangenty + tangentz * tangentz);
            tangentx *= tcoeff;
            tangenty *= tcoeff;
            float bitangentx = f * (-deltaU2 * (float)edge1.x + deltaU1 * (float)edge2.x);
            float bitangenty = f * (-deltaU2 * (float)edge1.y + deltaU1 * (float)edge2.y);
            float bitangentz = f * (-deltaU2 * (float)edge1.z + deltaU1 * (float)edge2.z);
            float bitcoeff = DualContouring3d.rsqrt(bitangentx * bitangentx + bitangenty * bitangenty + bitangentz * bitangentz);
            float pbitangentx = tangenty * normal.z - (tangentz *= tcoeff) * normal.y;
            float pbitangenty = tangentz * normal.x - tangentx * normal.z;
            float pbitangentz = tangentx * normal.y - tangenty * normal.x;
            float dot = (bitangentx *= bitcoeff) * pbitangentx + (bitangenty *= bitcoeff) * pbitangenty + (bitangentz *= bitcoeff) * pbitangentz;
            float tangentw = dot < 0.0f ? -1.0f : 1.0f;
            t0.set(tangentx, tangenty, tangentz, tangentw);
            t1.set(tangentx, tangenty, tangentz, tangentw);
            t2.set(tangentx, tangenty, tangentz, tangentw);
            uvmin.set(uv0);
            uvmin.min(uv1);
            uvmin.min(uv2);
            uvmax.set(uv0);
            uvmax.max(uv1);
            uvmax.max(uv2);
            if (defaultMidCoord) {
                this.midcoords.add(new Vector2f(0.5f));
                continue;
            }
            this.midcoords.add(new Vector2f(uvmin).add(uvmax).mul(0.5f));
        }
        for (i = 0; i < this.tangents.size(); ++i) {
        }
    }

    public void addColor(float r, float g, float b) {
        this.colors.add(Pack.color(r, g, b));
    }

    public void addColor(float r, float g, float b, float a) {
        this.colors.add(Pack.color(r, g, b, a));
    }

    public double getRadius(boolean reculalcate) {
        if (reculalcate) {
            this.radius = -1.0;
        }
        if (this.radius < 0.0) {
            for (int i = 0; i < this.positions.size(); ++i) {
                Vector3d position = this.positions.get(i);
                double radiusSquared = position.lengthSquared();
                if (!(radiusSquared > this.radius)) continue;
                this.radius = radiusSquared;
            }
            this.radius = java.lang.Math.sqrt(this.radius);
        }
        return this.radius;
    }

    public double getRadius() {
        return this.getRadius(false);
    }

    public void move(Vector3d position) {
        for (int i = 0; i < this.positions.size(); ++i) {
            this.positions.get(i).add(position);
        }
    }

    public void calculateOffset(boolean needsSides) {
        this.offset = new Vector3d();
        for (Vector3d position : this.positions) {
            this.offset.add(position);
        }
        this.offset.div(this.positions.size());
        for (Vector3d position : this.positions) {
            position.sub(this.offset);
            double radiusSquared = position.lengthSquared();
            if (!(radiusSquared > this.radius)) continue;
            this.radius = radiusSquared;
        }
        this.radius = java.lang.Math.sqrt(this.radius);
        if (needsSides) {
            for (int j = 0; j < this.normals.size(); ++j) {
                boolean hasSide = false;
                for (int i = 0; i < faceNormals.length; ++i) {
                    if (!((double)java.lang.Math.abs(Math.acos(this.normals.get(j).dot(Mesh.faceNormals[i].x, Mesh.faceNormals[i].y, Mesh.faceNormals[i].z))) < 0.01)) continue;
                    this.sides.add((byte)i);
                    hasSide = true;
                    break;
                }
                if (hasSide) continue;
                this.sides.add((byte)-1);
            }
        }
    }

    public List<Integer> calculateFaceDirections() {
        ObjectArrayList sides = new ObjectArrayList();
        for (int j = 0; j < this.normals.size(); ++j) {
            int maxComp;
            Vector3f normal = this.normals.get(j);
            double max = normal.get(maxComp = normal.maxComponent());
            if (max >= 0.0) {
                if (maxComp == 0) {
                    sides.add(1);
                    continue;
                }
                if (maxComp == 1) {
                    sides.add(4);
                    continue;
                }
                sides.add(0);
                continue;
            }
            if (maxComp == 0) {
                sides.add(3);
                continue;
            }
            if (maxComp == 1) {
                sides.add(5);
                continue;
            }
            sides.add(2);
        }
        return sides;
    }

    public boolean isEmpty() {
        return this.indices.size() == 0;
    }
}

