/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.guiphysics;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.jbox2d.common.Vec2;
import net.diebuddies.jbox2d.dynamics.Body;
import net.diebuddies.jbox2d.dynamics.BodyType;
import net.diebuddies.jbox2d.dynamics.World;
import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.org.joml.Math;
import net.diebuddies.physics.Box2DUtil;
import net.diebuddies.physics.settings.PhysicsSettingsScreen;
import net.diebuddies.physics.settings.gui.ScreenExtension;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractWidget.class})
public class MixinAbstractWidget
implements Animatable {
    @Shadow
    private int f_93618_;
    @Shadow
    private int f_93619_;
    @Shadow
    private int f_93620_;
    @Shadow
    private int f_93621_;
    @Unique
    private double positionX;
    @Unique
    private double positionY;
    @Unique
    private float rotation;
    @Unique
    private Body buttonBody;
    @Unique
    private float totalDelta;
    @Unique
    private boolean isSimActive;
    @Unique
    private float animX;
    @Unique
    private float animY;
    @Unique
    private float animWidth;
    @Unique
    private float animHeight;
    @Unique
    private List<Animator> animations;
    @Unique
    private float animRed = 1.0f;
    @Unique
    private float animGreen = 1.0f;
    @Unique
    private float animBlue = 1.0f;
    @Unique
    private float animAlpha = 1.0f;
    @Unique
    private float animDepth = -100.0f;
    @Unique
    private float renderPercent = 0.0f;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void constructor(int x, int y, int width, int height, Component component, CallbackInfo info) {
        this.animX = x;
        this.animY = y;
        this.animWidth = width;
        this.animHeight = height;
        this.animations = new ObjectArrayList();
    }

    @Unique
    private void physicsSetup() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null || screen instanceof PhysicsSettingsScreen) {
            return;
        }
        World world = ((ScreenExtension)screen).getPhysicsWorld();
        AbstractWidget widget = (AbstractWidget)this;
        this.buttonBody = Box2DUtil.createBox(world, widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_(), BodyType.DYNAMIC);
        this.buttonBody.setAngularVelocity(net.diebuddies.math.Math.random() * 10.0f - 5.0f);
        this.buttonBody.setLinearVelocity(new Vec2(net.diebuddies.math.Math.random() * 100.0f - 50.0f, net.diebuddies.math.Math.random() * 100.0f - 50.0f));
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void renderHead(PoseStack poseStack, int mouseX, int mouseY, float delta, CallbackInfo info) {
        this.renderPercent += delta;
        while (this.renderPercent >= 1.0f) {
            this.renderPercent -= 1.0f;
            for (Animator animator : this.animations) {
                animator.tick(this);
            }
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return;
        }
        World world = ((ScreenExtension)screen).getPhysicsWorld();
        if (world != null && (this.buttonBody == null || world != this.buttonBody.getWorld())) {
            this.physicsSetup();
        }
        if (this.buttonBody != null) {
            Vec2 pos = this.buttonBody.getPosition();
            this.rotation = this.buttonBody.getAngle();
            this.positionX = pos.x;
            this.positionY = pos.y;
            ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
            this.isSimActive = true;
        }
        if (world == null && this.isSimActive) {
            this.buttonBody = null;
            this.totalDelta += 0.05f * delta;
            AbstractWidget widget = (AbstractWidget)this;
            float posX = (float)((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0);
            float posY = (float)((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0);
            while (this.totalDelta > 0.004166667f) {
                this.rotation = Math.lerp(this.rotation, 0.0f, 0.05f);
                this.positionX = Math.lerp(this.positionX, (double)posX, (double)0.05f);
                this.positionY = Math.lerp(this.positionY, (double)posY, (double)0.05f);
                this.totalDelta -= 0.004166667f;
            }
            if (java.lang.Math.abs(this.positionX - (double)posX) < (double)0.1f && java.lang.Math.abs(this.positionX - (double)posX) < (double)0.1f && java.lang.Math.abs(this.rotation) < 0.005f) {
                this.isSimActive = false;
            }
        } else {
            this.totalDelta = 0.0f;
        }
        if (this.isAnimationActive()) {
            poseStack.m_85836_();
            this.applyTransformation(poseStack);
        }
        boolean cancelled = false;
        float tickAdjustedDelta = delta / 20.0f;
        for (Animator animator : this.animations) {
            cancelled |= animator.render(this, poseStack, mouseX, mouseY, this.renderPercent, tickAdjustedDelta);
        }
        if (cancelled) {
            if (this.isAnimationActive()) {
                poseStack.m_85849_();
                ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
            }
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderToolTip"}, cancellable=true)
    public void renderToolTip(PoseStack poseStack, int mouseX, int mouseY, CallbackInfo info) {
        boolean cancelled = false;
        for (Animator animator : this.animations) {
            cancelled |= animator.renderToolTip(this, poseStack, mouseX, mouseY, this.renderPercent);
        }
        if (cancelled) {
            info.cancel();
        }
    }

    @Unique
    private boolean isAnimationActive() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null || screen instanceof PhysicsSettingsScreen) {
            return false;
        }
        return this.buttonBody != null || this.isSimActive;
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void renderTail(PoseStack poseStack, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.isAnimationActive()) {
            poseStack.m_85849_();
            ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"clicked"}, cancellable=true)
    protected void clicked(double mouseX, double mouseY, CallbackInfoReturnable<Boolean> info) {
        if (this.isAnimationActive()) {
            AbstractWidget widget = (AbstractWidget)this;
            info.setReturnValue((Object)(widget.f_93623_ && widget.f_93624_ && this.isInside(mouseX, mouseY) ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isMouseOver"}, cancellable=true)
    public void isMouseOver(double mouseX, double mouseY, CallbackInfoReturnable<Boolean> info) {
        if (this.isAnimationActive()) {
            AbstractWidget widget = (AbstractWidget)this;
            info.setReturnValue((Object)(widget.f_93623_ && widget.f_93624_ && this.isInside(mouseX, mouseY) ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderButton"})
    public void renderButton(PoseStack poseStack, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.isAnimationActive()) {
            ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
        }
    }

    private void applyTransformation(PoseStack poseStack) {
        AbstractWidget widget = (AbstractWidget)this;
        poseStack.m_85837_(this.positionX - ((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0), this.positionY - ((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0), 0.0);
        poseStack.m_85837_((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0, (double)this.getAnimY() + (double)this.getAnimHeight() / 2.0, 0.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122270_(this.rotation));
        poseStack.m_85837_(-((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0), -((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0), 0.0);
    }

    @Override
    public boolean isInside(double mouseX, double mouseY) {
        if (this.isAnimationActive()) {
            PoseStack poseStack = new PoseStack();
            this.applyTransformation(poseStack);
            Vector4f trMouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            poseStack.m_85850_().m_85861_().m_27657_();
            trMouse.m_123607_(poseStack.m_85850_().m_85861_());
            return (double)trMouse.m_123601_() >= (double)this.getAnimX() && (double)trMouse.m_123615_() >= (double)this.getAnimY() && (double)trMouse.m_123601_() < (double)(this.getAnimX() + this.getAnimWidth()) && (double)trMouse.m_123615_() < (double)(this.getAnimY() + this.getAnimHeight());
        }
        return mouseX >= (double)this.getAnimX() && mouseY >= (double)this.getAnimY() && mouseX < (double)(this.getAnimX() + this.getAnimWidth()) && mouseY < (double)(this.getAnimY() + this.getAnimHeight());
    }

    @Override
    public Animatable addAnimator(Animator animator) {
        this.animations.add(animator);
        animator.init(this);
        return this;
    }

    @Override
    public Animatable addAnimator(int offset, Animator animator) {
        this.animations.add(offset, animator);
        animator.init(this);
        return this;
    }

    @Override
    public Animatable addAnimator(List<Animator> animators) {
        for (Animator animator : animators) {
            this.animations.add(animator);
            animator.init(this);
        }
        return this;
    }

    @Override
    public Animatable addAnimator(Animator ... animators) {
        for (Animator animator : animators) {
            this.animations.add(animator);
            animator.init(this);
        }
        return this;
    }

    @Override
    public List<Animator> getAnimators() {
        return this.animations;
    }

    @Override
    public <T extends Animator> T getAnimator(Class<T> clzz) {
        for (Animator animation : this.animations) {
            if (clzz != animation.getClass()) continue;
            return (T)animation;
        }
        return null;
    }

    @Override
    public Animatable removeAnimator(Animator animator) {
        this.animations.remove(animator);
        return this;
    }

    @Override
    public float getAnimX() {
        return this.animX;
    }

    @Override
    public Animatable setAnimX(float x) {
        this.animX = x;
        this.f_93620_ = (int)x;
        return this;
    }

    @Override
    public float getAnimY() {
        return this.animY;
    }

    @Override
    public Animatable setAnimY(float y) {
        this.animY = y;
        this.f_93621_ = (int)y;
        return this;
    }

    @Override
    public float getAnimWidth() {
        return this.animWidth;
    }

    @Override
    public Animatable setAnimWidth(float width) {
        this.animWidth = width;
        this.f_93618_ = (int)width;
        return this;
    }

    @Override
    public float getAnimHeight() {
        return this.animHeight;
    }

    @Override
    public Animatable setAnimHeight(float height) {
        this.animHeight = height;
        this.f_93619_ = (int)height;
        return this;
    }

    @Inject(at={@At(value="HEAD")}, method={"setWidth"})
    public void setWidth(int width, CallbackInfo info) {
        this.animWidth = width;
    }

    @Override
    public float getAnimRed() {
        return this.animRed;
    }

    @Override
    public Animatable setAnimRed(float red) {
        this.animRed = red;
        return this;
    }

    @Override
    public float getAnimGreen() {
        return this.animGreen;
    }

    @Override
    public Animatable setAnimGreen(float green) {
        this.animGreen = green;
        return this;
    }

    @Override
    public float getAnimBlue() {
        return this.animBlue;
    }

    @Override
    public Animatable setAnimBlue(float blue) {
        this.animBlue = blue;
        return this;
    }

    @Override
    public float getAnimAlpha() {
        return this.animAlpha;
    }

    @Override
    public Animatable setAnimAlpha(float alpha) {
        this.animAlpha = alpha;
        return this;
    }

    @Override
    public Animatable setAnimColor(float red, float green, float blue, float alpha) {
        this.animRed = red;
        this.animGreen = green;
        this.animBlue = blue;
        this.animAlpha = alpha;
        return this;
    }

    @Override
    public float getAnimDepth() {
        return this.animDepth;
    }

    @Override
    public Animatable setAnimDepth(float depth) {
        this.animDepth = depth;
        return this;
    }
}

