/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.forge;

import net.diebuddies.physics.PhysicsMod;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeRegistry.class})
public class MixinForgeRegistry {
    @Inject(at={@At(value="TAIL")}, method={"add(ILnet/minecraftforge/registries/IForgeRegistryEntry;Ljava/lang/String;)I"}, remap=false, cancellable=true)
    public void add(int id, IForgeRegistryEntry value, String owner, CallbackInfoReturnable<Integer> info) {
        String locId = value.getRegistryName().toString();
        if (this == ForgeRegistries.BLOCKS) {
            if (value instanceof Block) {
                Block block = (Block)value;
                PhysicsMod.registeredBlocks.put(block, locId);
                PhysicsMod.invRegisteredBlocks.put(locId, block);
            }
        } else if (this == ForgeRegistries.PARTICLE_TYPES) {
            if (value instanceof ParticleOptions) {
                ParticleOptions particle = (ParticleOptions)value;
                PhysicsMod.registeredParticles.put(locId, particle);
                PhysicsMod.invRegisteredParticles.put(particle, locId);
            }
        } else if (this == ForgeRegistries.SOUND_EVENTS && value instanceof SoundEvent) {
            SoundEvent sound = (SoundEvent)value;
            PhysicsMod.registeredSounds.put(locId, sound);
            PhysicsMod.invRegisteredSounds.put(sound, locId);
        }
    }
}

