/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Matrix4f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraLayer.class})
public class MixinElytraLayer {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private MultiBufferSource multiBufferSource;
    @Unique
    private PlayerLevelPacked tmp = new PlayerLevelPacked(null, null);

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    private void physicsmod$replaceElytra(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, LivingEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        if (entity instanceof AbstractClientPlayer) {
            boolean renderCloth;
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            this.physicsmod$removeOldSimulations();
            ItemStack itemStack = entity.m_6844_(EquipmentSlot.CHEST);
            if (!itemStack.m_150930_(Items.f_42741_)) {
                return;
            }
            boolean bl = renderCloth = Minecraft.m_91087_().f_91074_ != player;
            if (renderCloth && this.physicsmod$shouldRenderPhysicsElytra(player) && this.physicsmod$hasPhysicsElytra(player)) {
                this.physicsmod$renderPhysicsElytra(player, light);
                info.cancel();
            }
        }
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        Iterator<Map.Entry<PlayerLevelPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private void physicsmod$renderPhysicsElytra(AbstractClientPlayer player, int light) {
        Level level = player.m_20193_();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        this.tmp.e1 = player.m_36316_().getName();
        this.tmp.e2 = level;
        VerletSimulation simulation = this.simulations.get(this.tmp);
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        boolean renderFast = false;
        if (camera.m_90588_().m_123331_((Vec3i)player.m_142538_()) > (double)(ConfigClient.clothEntityRange * ConfigClient.clothEntityRange)) {
            renderFast = true;
        }
        Cloth cloth = ConfigCloth.getCategory((Entity)player, "Elytra");
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        EntityModel model = renderer.m_7200_();
        if (renderFast || !cloth.rules.isDynamic()) {
            ModelPart modelPart = ModelPartConstraint.getPart((Model)model, "body");
            if (cloth != null && modelPart != null) {
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (LivingEntity)player, modelPart, light));
            }
        } else {
            if (simulation == null) {
                boolean alwaysInstantlyUpdate;
                EntityModel entityModel;
                if (model instanceof EntityModel && !ModelPartConstraint.exists((EntityModel<LivingEntity>)(entityModel = model), "body")) {
                    return;
                }
                int quality = player == Minecraft.m_91087_().f_91074_ ? 90 : 45;
                simulation = new VerletSimulation(new Vector3d(ConfigClient.getGravity(level.m_46472_().m_135782_())), quality, 0.855);
                ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), (LivingEntity)player, "body", (Model)model);
                PoseStack modelMatrix = new PoseStack();
                ModelPartConstraint.entityTransformation(modelMatrix, simulation, (LivingEntity)player, (Model)model, 1.0f);
                modelPartConstraint.modelPartTransformation(modelMatrix);
                Matrix4d partTransformation = new Matrix4d();
                StarterClient.setMatrix(partTransformation, modelMatrix.m_85850_().m_85861_());
                simulation.getConstraints().clear();
                simulation.addConstraint(new OceanPhysicsDisplacementConstraint((Entity)player));
                simulation.addConstraint(modelPartConstraint);
                simulation.brightness = light;
                simulation.addCloth(cloth, cloth.getTexture((Entity)player), partTransformation, false);
                simulation.setOffset(new Vector3d(player.m_20185_(), player.m_20186_(), player.m_20189_()).add(simulation.getOffset()), false);
                simulation.setTransformation(partTransformation);
                simulation.setBufferTransformation(partTransformation);
                simulation.updateOffsets();
                PhysicsWorld physicsWorld = PhysicsMod.getInstance((Level)level).physicsWorld;
                modelPartConstraint.initAsyncData(physicsWorld, simulation);
                modelPartConstraint.changeInstantly = true;
                modelPartConstraint.updateAfter(0.0, simulation);
                simulation.downloadData();
                simulation.alwaysFetchInstantly = alwaysInstantlyUpdate = player == Minecraft.m_91087_().f_91074_;
                this.simulations.put(new PlayerLevelPacked(player.m_36316_().getName(), player.m_20193_()), simulation);
                if (alwaysInstantlyUpdate) {
                    physicsWorld.addVerletSimulation(0, simulation);
                } else {
                    physicsWorld.addVerletSimulation(simulation);
                }
            } else if (!simulation.destroyed) {
                simulation.active = true;
                simulation.brightness = light;
            }
            if (cloth != simulation.cloth) {
                simulation.destroyed = true;
            }
            if (StarterClient.optifabric) {
                PhysicsMod.optifineClothCompat.add(simulation);
            } else {
                simulation.renderSlow(player.m_20193_());
            }
        }
    }

    @Unique
    private boolean physicsmod$shouldRenderPhysicsElytra(AbstractClientPlayer player) {
        return !PhysicsMod.hudRendering && ConfigClient.capePhysics && player != null && !player.m_20145_() && !ConfigClient.clothForceArmor;
    }

    @Unique
    private boolean physicsmod$hasPhysicsElytra(AbstractClientPlayer player) {
        return ConfigCloth.hasCategory((Entity)player, "Elytra");
    }
}

