/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.org.joml.Matrix4f;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public class MixinCapeFeatureRenderer {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private AbstractClientPlayer player;
    @Unique
    private boolean renderedCape;
    @Unique
    private MultiBufferSource multiBufferSource;
    @Unique
    private PlayerLevelPacked tmp = new PlayerLevelPacked(null, null);

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void physicsmod$renderHead(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.player = player;
        this.renderedCape = false;
        this.multiBufferSource = multiBufferSource;
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    private void physicsmod$renderTail(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        boolean renderCloth;
        this.physicsmod$removeOldSimulations();
        boolean bl = renderCloth = Minecraft.m_91087_().f_91074_ != player;
        if (renderCloth && this.physicsmod$shouldRenderPhysicsCape(player) && !this.renderedCape && !this.physicsmod$hasPhysicsCape(player)) {
            this.physicsmod$renderPhysicsCape(player, light);
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    private void physicsmod$renderCloak(PlayerModel playerModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        boolean renderCloth;
        this.physicsmod$removeOldSimulations();
        boolean bl = renderCloth = Minecraft.m_91087_().f_91074_ != this.player;
        if (renderCloth && this.physicsmod$shouldRenderPhysicsCape(this.player)) {
            if (!this.physicsmod$hasPhysicsCape(this.player)) {
                ((PlayerModel)((CapeLayer)this).m_117386_()).m_103411_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
            }
        } else {
            ((PlayerModel)((CapeLayer)this).m_117386_()).m_103411_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        }
        this.renderedCape = true;
    }

    @Unique
    private boolean physicsmod$shouldRenderPhysicsCape(AbstractClientPlayer player) {
        return !PhysicsMod.hudRendering && ConfigClient.capePhysics && player != null && player.m_108555_() && !player.m_20145_() && this.physicsmod$hasMojangCape(player);
    }

    @Unique
    private boolean physicsmod$hasMojangCape(AbstractClientPlayer player) {
        return player.m_108561_() != null;
    }

    @Unique
    private boolean physicsmod$hasPhysicsCape(AbstractClientPlayer player) {
        return ConfigCloth.hasCategory((Entity)player, "Back");
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        Iterator<Map.Entry<PlayerLevelPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private void physicsmod$renderPhysicsCape(AbstractClientPlayer player, int light) {
    }
}

