/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.diebuddies.config.ConfigClient;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntityRenderer.class})
public abstract class MixinItemEntityRenderer
extends EntityRenderer<ItemEntity> {
    @Shadow
    @Final
    public ItemRenderer f_115019_;
    @Shadow
    @Final
    public Random f_115020_;

    protected MixinItemEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void render(ItemEntity itemEntity, float f, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, CallbackInfo info) {
        if (ConfigClient.hasItemPhysics()) {
            matrixStack.m_85836_();
            ItemStack itemStack = itemEntity.m_32055_();
            BakedModel bakedModel = this.f_115019_.m_174264_(itemStack, itemEntity.f_19853_, (LivingEntity)null, itemEntity.m_142049_());
            Vector3f translation = bakedModel.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111756_;
            boolean isBlock = bakedModel.m_7539_();
            float passedTimeMillis = tickDelta * 1.0f / 20.0f * 1000.0f * 0.1f;
            double rotationSpeed = 0.05 * (double)ConfigClient.itemRotationSpeed;
            if (itemEntity.m_20069_()) {
                rotationSpeed = 0.002;
            }
            if (itemEntity.m_20096_()) {
                if (!(isBlock & !(itemStack.m_150930_(Items.f_42713_) | itemStack.m_150930_(Items.f_151059_)))) {
                    itemEntity.f_146794_ = 0.0f;
                }
            } else {
                itemEntity.f_146794_ = (float)((double)itemEntity.f_146794_ + (double)passedTimeMillis * rotationSpeed);
            }
            int k = 1;
            if (itemStack.m_41613_() > 48) {
                k = 5;
            } else if (itemStack.m_41613_() > 32) {
                k = 4;
            } else if (itemStack.m_41613_() > 16) {
                k = 3;
            } else if (itemStack.m_41613_() > 1) {
                k = 2;
            }
            float offset = 0.05f;
            matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(itemEntity.f_31983_));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122270_((float)Math.toRadians(90.0) + itemEntity.f_146794_));
            if (!(itemStack.m_150930_(Items.f_42713_) | itemStack.m_150930_(Items.f_151059_))) {
                matrixStack.m_85837_((double)(-translation.m_122239_()), (double)(-translation.m_122260_()), (double)(-translation.m_122269_()));
            }
            if (!isBlock) {
                matrixStack.m_85837_(0.0, 0.0, (double)((float)(-(k - 1)) * offset));
            }
            if (!isBlock) {
                for (int i = 0; i < k; ++i) {
                    this.f_115019_.m_115143_(itemStack, ItemTransforms.TransformType.GROUND, false, matrixStack, vertexConsumerProvider, light, OverlayTexture.f_118083_, bakedModel);
                    matrixStack.m_85837_(0.0, 0.0, (double)offset);
                }
            } else {
                this.f_115019_.m_115143_(itemStack, ItemTransforms.TransformType.GROUND, false, matrixStack, vertexConsumerProvider, light, OverlayTexture.f_118083_, bakedModel);
            }
            matrixStack.m_85849_();
            super.m_7392_((Entity)itemEntity, f, tickDelta, matrixStack, vertexConsumerProvider, light);
            info.cancel();
        }
    }
}

