/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.org.joml.Vector2d;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.wind.WeatherDomain;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class WindSoundInstance
extends AbstractTickableSoundInstance {
    private float volumeTarget;
    private float pitchTarget;
    private float tmpVolume;

    public WindSoundInstance(SoundEvent soundEvent, SoundSource soundSource) {
        super(soundEvent, soundSource);
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119582_ = true;
        this.f_119573_ = 0.0f;
        this.volumeTarget = 0.0f;
        this.f_119574_ = 1.0f;
        this.pitchTarget = 1.0f;
    }

    public void m_7788_() {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        BlockPos camPos = camera.m_90588_();
        int camX = Mth.m_14107_((double)camera.m_90583_().f_82479_);
        int camY = Mth.m_14107_((double)camera.m_90583_().f_82480_);
        int camZ = Mth.m_14107_((double)camera.m_90583_().f_82481_);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            this.stopWind();
            return;
        }
        double distance = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, camPos.m_123341_(), camPos.m_123343_()) - camPos.m_123342_();
        if (distance > 0.0) {
            distance *= distance;
            int checkRange = 6;
            for (int zo = camZ - checkRange; zo <= camZ + checkRange; ++zo) {
                for (int xo = camX - checkRange; xo <= camX + checkRange; ++xo) {
                    int diffX = xo - camX;
                    int diffZ = zo - camZ;
                    if (diffX * diffX + diffZ * diffZ > 36) continue;
                    int rainToThisHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, xo, zo);
                    double dsquared = 0.0;
                    dsquared = rainToThisHeight <= camPos.m_123342_() ? Vector2d.distanceSquared(camPos.m_123341_(), camPos.m_123343_(), xo, zo) : Vector3d.distanceSquared(camPos.m_123341_(), camPos.m_123342_(), camPos.m_123343_(), xo, rainToThisHeight, zo);
                    if (!(dsquared < distance)) continue;
                    distance = dsquared;
                }
            }
            distance = java.lang.Math.sqrt(distance);
        } else {
            distance = 0.0;
        }
        WeatherDomain weatherDomain = PhysicsMod.getInstance((Level)level).getPhysicsWorld().getWeatherDomain();
        Vector3f windDirection = weatherDomain.getWindDirection(camX, camY, camZ);
        float distanceBasedVolume = 1.0f - Math.clamp((float)distance / 6.0f, 0.0f, 1.0f);
        float strengthBasedVolume = Math.clamp(weatherDomain.getWindStrengthFast() / 0.9f, 0.0f, 1.0f);
        this.pitchTarget = strengthBasedVolume > 0.3f ? 1.0f + java.lang.Math.max(0.0f, windDirection.length() - 0.4f) : 1.0f;
        if (strengthBasedVolume < 0.12f) {
            strengthBasedVolume = Math.remapClamp(java.lang.Math.max(0.0f, windDirection.length() - 0.3f), 0.0f, 0.3f, 0.0f, 0.08f);
        }
        this.volumeTarget = distanceBasedVolume * strengthBasedVolume;
        this.tmpVolume = net.diebuddies.org.joml.Math.lerp(this.tmpVolume, this.volumeTarget, 0.05f);
        this.f_119573_ = this.tmpVolume * ConfigClient.windVolume;
        this.f_119574_ = net.diebuddies.org.joml.Math.lerp(this.f_119574_, this.pitchTarget, 0.075f);
    }

    public boolean m_7784_() {
        return true;
    }

    public void stopWind() {
        this.m_119609_();
    }
}

