/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.diebuddies.org.joml.Matrix4d;
import net.diebuddies.org.joml.Vector2f;
import net.diebuddies.org.joml.Vector3d;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.org.joml.Vector3i;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.StarterClient;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderHelper {
    private static Matrix4d transformation = new Matrix4d();
    private static Matrix4d normalMatrix = new Matrix4d();
    private static Vector3d tmpPos = new Vector3d();
    private static Vector3f tmpNormal = new Vector3f();
    private static Random random = new Random();

    public static void renderMesh(Entity entity, float tickDelta, MultiBufferSource multiBufferSource, EntityRenderDispatcher entityRenderDispatcher, ResourceLocation texture, Mesh mesh, PoseStack poseStack, int light, int overlay, boolean shade) {
        VertexConsumer consumer = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)texture));
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        StarterClient.setMatrix(transformation, poseStack.m_85850_().m_85861_());
        int id = entity.m_142049_();
        float progress = (float)entity.f_19797_ + tickDelta;
        random.setSeed(id);
        transformation.rotateX(random.nextDouble() * Math.PI);
        transformation.rotateY(random.nextDouble() * Math.PI);
        transformation.rotateZ(random.nextDouble() * Math.PI + (double)progress * 0.5);
        transformation.normal(normalMatrix);
        if (!shade) {
            StarterClient.setMatrix(normalMatrix, poseStack.m_85850_().m_85864_());
        }
        for (int i = 0; i < mesh.indicesQuads.size(); ++i) {
            Vector3i index = mesh.indicesQuads.get(i);
            Vector3d position = mesh.positions.get(index.x - 1);
            Vector2f uv = mesh.uvs.get(index.y - 1);
            Vector3f normal = mesh.normals.get(index.z - 1);
            position = transformation.transformPosition(position, tmpPos);
            if (shade) {
                tmpNormal.set(normal.x, normal.y, normal.z);
            } else {
                tmpNormal.set(0.0, 1.0, 0.0);
            }
            normalMatrix.transformDirection(tmpNormal);
            if (mesh.colors.size() > 0) {
                int color = mesh.colors.getInt(index.x - 1);
                r = (float)(color & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color >> 16 & 0xFF) / 255.0f;
            }
            consumer.m_5954_((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, uv.x, uv.y, overlay, light, RenderHelper.tmpNormal.x, RenderHelper.tmpNormal.y, RenderHelper.tmpNormal.z);
        }
    }
}

