/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import net.diebuddies.math.Math;
import net.diebuddies.opengl.Pack;
import net.diebuddies.org.joml.Matrix4f;
import net.diebuddies.org.joml.Vector3f;
import net.diebuddies.org.joml.Vector4f;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;

public class ParticleSpawner {
    public static void spawnEatingPhysicsParticle(ItemStack itemStack, Level level, double x, double y, double z, double vx, double vy, double vz) {
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, level, null, 0).m_6160_();
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set(entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = sprite.m_118414_().m_117963_();
        entity.scale = (double)Math.random() * 0.06 + 0.04;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        model.hashCode = 1;
        entity.physicsGroup = 16;
        entity.physicsMask = 19;
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        if (body.getRigidBody() instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)vx, (float)vy * 1.3f + 1.0f, (float)vz);
                rigidBody.setLinearVelocity(velocity);
                PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                rigidBody.setAngularVelocity(avelocity);
            }
        }
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        model.customUVs = new Vector4f(sprite.m_118367_((double)(uo / 4.0f * 16.0f)), sprite.m_118367_((double)(uo / 4.0f * 16.0f)), sprite.m_118393_((double)(vo / 4.0f * 16.0f)), sprite.m_118393_((double)(vo / 4.0f * 16.0f)));
        float xScale = model.customUVs.y - model.customUVs.x;
        float yScale = model.customUVs.w - model.customUVs.z;
        model.textureMatrix = new Matrix4f().translate(model.customUVs.x, model.customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnSprintingPhysicsParticle(BlockState state, BlockPos pos, Level level, double x, double y, double z) {
        IRigidBody body;
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state);
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set(entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = sprite.m_118414_().m_117963_();
        entity.scale = (double)Math.random() * 0.06 + 0.11;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        model.hashCode = 1;
        entity.physicsGroup = 16;
        entity.physicsMask = 19;
        int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
        if (color == -1) {
            color = -1;
        }
        entity.color = color;
        if (state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_50440_) {
            entity.color = -1;
        }
        if ((body = mod.physicsWorld.addBlockParticle(entity)).getRigidBody() instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
            float strength = 3.0f;
            Vector3f speed = new Vector3f(0.0f, 0.3f, 0.0f);
            speed.x += (Math.random() - 0.5f) * 0.4f;
            speed.y += Math.random() * 0.4f;
            speed.z += (Math.random() - 0.5f) * 0.4f;
            speed.normalize();
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                rigidBody.setLinearVelocity(velocity);
                PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                rigidBody.setAngularVelocity(avelocity);
            }
        }
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        model.customUVs = new Vector4f(sprite.m_118367_((double)(uo / 4.0f * 16.0f)), sprite.m_118367_((double)((uo + 1.0f) / 4.0f * 16.0f)), sprite.m_118393_((double)(vo / 4.0f * 16.0f)), sprite.m_118393_((double)((vo + 1.0f) / 4.0f * 16.0f)));
        float xScale = model.customUVs.y - model.customUVs.x;
        float yScale = model.customUVs.w - model.customUVs.z;
        model.textureMatrix = new Matrix4f().translate(model.customUVs.x, model.customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnBloodPhysicsParticle(Level level, double x, double y, double z) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set(entity.getTransformation());
        Model model = entity.models.get(0);
        model.textureID = PhysicsMod.whiteTexture.getID();
        entity.scale = (double)Math.random() * 0.03 + 0.08;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        model.hashCode = 1;
        float bloodModifier = Math.random() * 0.2f + 0.8f;
        entity.color = Pack.color(0.1f * bloodModifier, 0.1f * bloodModifier, 0.77f * bloodModifier);
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        PxRigidActor pxRigidActor = body.getRigidBody();
        if (pxRigidActor instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)pxRigidActor;
            Vector3f speed = new Vector3f();
            speed.x = Math.random() - 0.5f;
            speed.y = Math.random() - 0.5f;
            speed.z = Math.random() - 0.5f;
            float strength = Math.random() * 2.0f + 1.0f;
            if (speed.lengthSquared() > 0.0f) {
                speed.normalize();
            }
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                rigidBody.setLinearVelocity(velocity);
                PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                rigidBody.setAngularVelocity(avelocity);
            }
        }
    }

    public static void spawnOceanPhysicsParticle(Level level, double x, double y, double z, double vx, double vz) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set(entity.getTransformation());
        Model model = entity.models.get(0);
        model.textureID = PhysicsMod.whiteTexture.getID();
        entity.scale = (double)Math.random() * 0.05 + 0.11;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        model.hashCode = 1;
        entity.physicsGroup = 16;
        entity.physicsMask = 19;
        entity.color = -1;
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        PxRigidActor pxRigidActor = body.getRigidBody();
        if (pxRigidActor instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)pxRigidActor;
            Vector3f speed = new Vector3f((float)vx, 0.0f, (float)vz);
            speed.x *= Math.random();
            speed.y = 0.0f;
            speed.z += Math.random();
            float strength = Math.random() * 2.0f + 1.0f;
            if (speed.lengthSquared() > 0.0f) {
                speed.normalize();
            }
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                rigidBody.setLinearVelocity(velocity);
                PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                rigidBody.setAngularVelocity(avelocity);
            }
        }
    }

    public static void spawnServerBlockPhysicsParticle(BlockState state, Level level, double x, double y, double z, double vx, double vy, double vz) {
        IRigidBody body;
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state);
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set(entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = sprite.m_118414_().m_117963_();
        entity.scale = (double)Math.random() * 0.06 + 0.11;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        model.hashCode = 1;
        entity.physicsGroup = 16;
        entity.physicsMask = 19;
        int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, new BlockPos(x, y, z), 0);
        if (color == -1) {
            color = -1;
        }
        entity.color = color;
        if (state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_50440_) {
            entity.color = -1;
        }
        if ((body = mod.physicsWorld.addBlockParticle(entity)).getRigidBody() instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
            float strength = 2.0f;
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)vx * strength, (float)vy * strength, (float)vz * strength);
                rigidBody.setLinearVelocity(velocity);
                PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                rigidBody.setAngularVelocity(avelocity);
            }
        }
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        model.customUVs = new Vector4f(sprite.m_118367_((double)(uo / 4.0f * 16.0f)), sprite.m_118367_((double)((uo + 1.0f) / 4.0f * 16.0f)), sprite.m_118393_((double)(vo / 4.0f * 16.0f)), sprite.m_118393_((double)((vo + 1.0f) / 4.0f * 16.0f)));
        float xScale = model.customUVs.y - model.customUVs.x;
        float yScale = model.customUVs.w - model.customUVs.z;
        model.textureMatrix = new Matrix4f().translate(model.customUVs.x, model.customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }
}

