/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.math;

import net.diebuddies.org.joml.Math;
import net.diebuddies.org.joml.Vector3d;

public class RayIntersection {
    public static IntersectionResult intersectAABB(Vector3d rayOrigin, Vector3d rayDir, Vector3d boxMin, Vector3d boxMax) {
        double rayDirInvX = 1.0 / rayDir.x;
        double rayDirInvY = 1.0 / rayDir.y;
        double rayDirInvZ = 1.0 / rayDir.z;
        double tx1 = (boxMin.x - rayOrigin.x) * rayDirInvX;
        double ty1 = (boxMin.y - rayOrigin.y) * rayDirInvY;
        double tz1 = (boxMin.z - rayOrigin.z) * rayDirInvZ;
        double tx2 = (boxMax.x - rayOrigin.x) * rayDirInvX;
        double ty2 = (boxMax.y - rayOrigin.y) * rayDirInvY;
        double tz2 = (boxMax.z - rayOrigin.z) * rayDirInvZ;
        double tmin = Math.max(Math.max(Math.min(tx1, tx2), Math.min(ty1, ty2)), Math.min(tz1, tz2));
        double tmax = Math.min(Math.min(Math.max(tx1, tx2), Math.max(ty1, ty2)), Math.max(tz1, tz2));
        if (tmax < 0.0 || tmin > tmax) {
            return new IntersectionResult(false, tmax);
        }
        if (!Double.isFinite(tmin)) {
            return new IntersectionResult(false, tmin);
        }
        return new IntersectionResult(true, tmin);
    }

    public static class IntersectionResult {
        public boolean hit;
        public double fraction;

        public IntersectionResult(boolean hit, double fraction) {
            this.hit = hit;
            this.fraction = fraction;
        }
    }
}

