/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import net.diebuddies.minecraft.weather.DustParticle;
import net.diebuddies.minecraft.weather.RainParticle;
import net.diebuddies.minecraft.weather.SnowParticle;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.ocean.ExplosionOceanSplashParticle;
import net.diebuddies.physics.ocean.OceanSplashParticle;
import net.diebuddies.physics.ocean.SmallOceanSplashParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WeatherParticlesRegistry {
    public static final ResourceLocation RAIN_RESOURCE = new ResourceLocation("physicsmod", "rain");
    public static final ResourceLocation SNOW_RESOURCE = new ResourceLocation("physicsmod", "snow");
    public static final ResourceLocation DUST_RESOURCE = new ResourceLocation("physicsmod", "dust");
    public static final ResourceLocation SPLASH_RESOURCE = new ResourceLocation("physicsmod", "splash");
    public static final ResourceLocation SPLASH_SMALL_RESOURCE = new ResourceLocation("physicsmod", "splash_small");
    public static final ResourceLocation SPLASH_EXPLOSION_RESOURCE = new ResourceLocation("physicsmod", "splash_explosion");

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register(WeatherParticlesRegistry.class);
    }

    @SubscribeEvent
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        particleEngine.m_107378_((ParticleType)WeatherEffects.PHYSICS_RAIN, RainParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)WeatherEffects.PHYSICS_SNOW, SnowParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)WeatherEffects.PHYSICS_DUST, DustParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)WeatherEffects.PHYSICS_SPLASH, OceanSplashParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)WeatherEffects.PHYSICS_SPLASH_SMALL, SmallOceanSplashParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)WeatherEffects.PHYSICS_SPLASH_EXPLOSION, ExplosionOceanSplashParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        WeatherEffects.WIND_SOUND_EVENT.setRegistryName(WeatherEffects.WIND_SOUND_ID);
        event.getRegistry().register((IForgeRegistryEntry)WeatherEffects.WIND_SOUND_EVENT);
        WeatherEffects.SPLASH_SOUND_EVENT.setRegistryName(WeatherEffects.SPLASH_SOUND_ID);
        event.getRegistry().register((IForgeRegistryEntry)WeatherEffects.SPLASH_SOUND_EVENT);
    }

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        WeatherEffects.PHYSICS_RAIN.setRegistryName(RAIN_RESOURCE);
        WeatherEffects.PHYSICS_SNOW.setRegistryName(SNOW_RESOURCE);
        WeatherEffects.PHYSICS_DUST.setRegistryName(DUST_RESOURCE);
        WeatherEffects.PHYSICS_SPLASH.setRegistryName(SPLASH_RESOURCE);
        WeatherEffects.PHYSICS_SPLASH_SMALL.setRegistryName(SPLASH_SMALL_RESOURCE);
        WeatherEffects.PHYSICS_SPLASH_EXPLOSION.setRegistryName(SPLASH_EXPLOSION_RESOURCE);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ParticleType[]{WeatherEffects.PHYSICS_RAIN, WeatherEffects.PHYSICS_SNOW, WeatherEffects.PHYSICS_DUST, WeatherEffects.PHYSICS_SPLASH, WeatherEffects.PHYSICS_SPLASH_SMALL, WeatherEffects.PHYSICS_SPLASH_EXPLOSION});
    }
}

