/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.cst.transform;

import io.github.douira.glsl_transformer_physics.GLSLParser;
import io.github.douira.glsl_transformer_physics.GLSLParserBaseListener;
import io.github.douira.glsl_transformer_physics.basic.EnhancedParser;
import io.github.douira.glsl_transformer_physics.cst.node.Directive;
import io.github.douira.glsl_transformer_physics.cst.print.EmptyTerminalNode;
import io.github.douira.glsl_transformer_physics.cst.transform.CSTInjectionPoint;
import io.github.douira.glsl_transformer_physics.cst.transform.ExecutionPlanner;
import io.github.douira.glsl_transformer_physics.cst.transform.lifecycle.ActivatableLifecycleUser;
import io.github.douira.glsl_transformer_physics.job_parameter.JobParameters;
import io.github.douira.glsl_transformer_physics.tree.ExtendedContext;
import io.github.douira.glsl_transformer_physics.tree.TreeMember;
import io.github.douira.glsl_transformer_physics.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import physics.org.antlr.v4.runtime.tree.ParseTree;
import physics.org.antlr.v4.runtime.tree.pattern.ParseTreeMatch;
import physics.org.antlr.v4.runtime.tree.pattern.ParseTreePattern;
import physics.org.antlr.v4.runtime.tree.xpath.XPath;

public abstract class TransformationPhaseBase<T extends JobParameters>
extends GLSLParserBaseListener
implements ActivatableLifecycleUser<T> {
    private ExecutionPlanner<T> planner;
    private Supplier<Boolean> activation;
    private boolean initialized = false;

    @Override
    public TransformationPhaseBase<T> activation(Supplier<Boolean> activation) {
        this.activation = activation;
        return this;
    }

    @Override
    public boolean isActive() {
        return ConfigUtil.withDefault(this.activation, Boolean.valueOf(true));
    }

    @Override
    public ExecutionPlanner<T> getPlanner() {
        return this.planner;
    }

    @Override
    public void setPlanner(ExecutionPlanner<T> parent) {
        this.planner = parent;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized() {
        this.initialized = true;
    }

    protected static List<ParseTree> getSiblings(TreeMember node) {
        ExtendedContext parent = node.getParent();
        return parent == null ? null : parent.children;
    }

    protected static void replaceNode(TreeMember removeNode, String newContent, Function<GLSLParser, ExtendedContext> parseMethod) {
        TransformationPhaseBase.replaceNode(removeNode, TransformationPhaseBase.createLocalRoot(newContent, removeNode.getParent(), parseMethod));
    }

    protected static int replaceNode(TreeMember removeNode, TreeMember newNode) {
        ExtendedContext parent = removeNode.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("The root node may not be removed!");
        }
        newNode.setPreviousNode(removeNode);
        List children = parent.children;
        int index = children.indexOf(removeNode);
        newNode.setParent(parent);
        children.set(index, newNode);
        removeNode.processRemoval();
        return index;
    }

    protected static int removeNode(TreeMember removeNode) {
        return TransformationPhaseBase.replaceNode(removeNode, new EmptyTerminalNode());
    }

    protected XPath compilePath(String xpath) {
        return new XPath(this.getParser(), xpath);
    }

    protected ParseTreePattern compilePattern(String pattern, int rootRule) {
        return this.getParser().compileParseTreePattern(pattern, rootRule, this.getLexer());
    }

    protected static List<ParseTreeMatch> findAndMatch(ParseTree tree, XPath xpath, ParseTreePattern pattern) {
        Collection<ParseTree> subtrees = xpath.evaluate(tree);
        ArrayList<ParseTreeMatch> matches = new ArrayList<ParseTreeMatch>();
        for (ParseTree sub : subtrees) {
            ParseTreeMatch match = pattern.match(sub);
            if (!match.succeeded()) continue;
            matches.add(match);
        }
        return matches;
    }

    protected static <RuleType extends ExtendedContext> RuleType createLocalRoot(String str, ExtendedContext parent, Function<GLSLParser, RuleType> parseMethod) {
        EnhancedParser parser = EnhancedParser.getInternalInstance();
        RuleType node = parser.parse(str, parent, parseMethod);
        ((ExtendedContext)node).makeLocalRoot(parser.getTokenStream());
        return node;
    }

    private int getInjectionIndex(CSTInjectionPoint location) {
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        int injectIndex = -1;
        if (location == CSTInjectionPoint.BEFORE_VERSION) {
            injectIndex = rootNode.getChildIndexLike(GLSLParser.VersionStatementContext.class);
            if (injectIndex == rootNode.getChildCount()) {
                injectIndex = 0;
            }
        } else if (location == CSTInjectionPoint.END) {
            injectIndex = rootNode.getChildCount();
        } else {
            ExtendedContext eChild;
            GLSLParser.ExternalDeclarationContext externalDeclaration;
            ParseTree parseTree;
            while (!((parseTree = rootNode.getChild(++injectIndex)) instanceof GLSLParser.ExternalDeclarationContext && (parseTree = (externalDeclaration = (GLSLParser.ExternalDeclarationContext)parseTree).getChild(0)) instanceof ExtendedContext && location.checkChildRelevant((eChild = (ExtendedContext)parseTree).getClass()) || injectIndex >= rootNode.getChildCount())) {
            }
        }
        return injectIndex;
    }

    protected void injectNode(CSTInjectionPoint location, ParseTree newNode) {
        this.getRootNode().addChild(this.getInjectionIndex(location), newNode);
    }

    protected void injectNodes(CSTInjectionPoint location, Deque<ParseTree> newNodes) {
        int injectIndex = this.getInjectionIndex(location);
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        newNodes.descendingIterator().forEachRemaining(newNode -> rootNode.addChild(injectIndex, (ParseTree)newNode));
    }

    protected void injectNodes(CSTInjectionPoint location, ParseTree ... newNodes) {
        int injectIndex = this.getInjectionIndex(location);
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        for (int i = newNodes.length - 1; i >= 0; --i) {
            rootNode.addChild(injectIndex, newNodes[i]);
        }
    }

    protected void injectExternalDeclaration(CSTInjectionPoint location, String str) {
        this.injectNode(location, TransformationPhaseBase.createLocalRoot(str, this.getRootNode(), GLSLParser::externalDeclaration));
    }

    protected void injectExternalDeclarations(CSTInjectionPoint location, String ... str) {
        ParseTree[] nodes = new ParseTree[str.length];
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        for (int i = 0; i < str.length; ++i) {
            nodes[i] = TransformationPhaseBase.createLocalRoot(str[i], rootNode, GLSLParser::externalDeclaration);
        }
        this.injectNodes(location, nodes);
    }

    protected void injectDefine(CSTInjectionPoint location, String content) {
        this.injectNode(location, new Directive(Directive.DirectiveType.DEFINE, content));
    }
}

