/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.cst.transform;

import io.github.douira.glsl_transformer_physics.GLSLParser;
import io.github.douira.glsl_transformer_physics.cst.transform.TransformationPhaseBase;
import io.github.douira.glsl_transformer_physics.cst.traversal.PartialParseTreeListener;
import io.github.douira.glsl_transformer_physics.job_parameter.JobParameters;
import io.github.douira.glsl_transformer_physics.tree.ExtendedContext;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public abstract class TransformationPhase<T extends JobParameters>
extends TransformationPhaseBase<T>
implements PartialParseTreeListener {
    private boolean walkFinishedNotified = false;
    protected Set<Class<? extends ExtendedContext>> walkIntoRules;
    protected int maximumWalkDepth = -1;

    protected abstract boolean canWalk();

    protected boolean checkBeforeWalk(GLSLParser.TranslationUnitContext ctx) {
        return false;
    }

    protected void runAfterWalk(GLSLParser.TranslationUnitContext ctx) {
    }

    @Override
    public TransformationPhase<T> activation(Supplier<Boolean> activation) {
        super.activation((Supplier)activation);
        return this;
    }

    protected void walkFinished() {
        if (this.walkFinishedNotified) {
            return;
        }
        this.walkFinishedNotified = true;
        this.getPlanner().removeCurrentPhaseFromWalk();
    }

    void resetWalkFinishState() {
        this.walkFinishedNotified = false;
    }

    @Override
    public boolean isDeepEnough(ExtendedContext node, int depth) {
        int maximumWalkDepth = this.getMaximumWalkDepth();
        Set<Class<ExtendedContext>> walkIntoRules = this.getWalkIntoRules();
        return maximumWalkDepth != -1 && depth >= maximumWalkDepth || walkIntoRules != null && !walkIntoRules.contains(node.getClass());
    }

    @Override
    public boolean canStop() {
        return this.maximumWalkDepth >= 0 || this.walkIntoRules != null;
    }

    public void setWalkIntoRules(Set<Class<? extends ExtendedContext>> walkIntoRules) {
        this.walkIntoRules = walkIntoRules;
    }

    protected Set<Class<? extends ExtendedContext>> getWalkIntoRules() {
        return this.walkIntoRules;
    }

    public void addWalkIntoRule(Class<? extends ExtendedContext> walkIntoRule) {
        if (this.walkIntoRules == null) {
            this.walkIntoRules = new HashSet<Class<? extends ExtendedContext>>();
        }
        this.walkIntoRules.add(walkIntoRule);
    }

    protected int getMaximumWalkDepth() {
        return this.maximumWalkDepth;
    }

    public void setMaximumWalkDepth(int maximumWalkDepth) {
        this.maximumWalkDepth = maximumWalkDepth;
    }

    public void unlimitedWalkDepth() {
        this.maximumWalkDepth = Integer.MAX_VALUE;
    }
}

