/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.query.index;

import io.github.douira.glsl_transformer_physics.ast.query.index.DuplicatorTrie;
import io.github.douira.glsl_transformer_physics.ast.query.index.InfixQueryable;
import io.github.douira.glsl_transformer_physics.ast.query.index.InvertedInfixQueryable;
import io.github.douira.glsl_transformer_physics.ast.query.index.PrefixQueryable;
import io.github.douira.glsl_transformer_physics.ast.query.index.SuffixQueryable;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PermutermTrie<E>
extends DuplicatorTrie<Set<E>>
implements PrefixQueryable<E>,
SuffixQueryable<E>,
InfixQueryable<E>,
InvertedInfixQueryable<E> {
    public PermutermTrie() {
    }

    public PermutermTrie(Map<? extends String, ? extends Set<E>> m) {
        super(m);
    }

    public PermutermTrie(char marker) {
        super(marker);
    }

    public PermutermTrie(Map<? extends String, ? extends Set<E>> m, char marker) {
        super(m, marker);
    }

    @Override
    protected void iterateKeyVariations(String key, Consumer<String> consumer) {
        int length = key.length();
        for (int i = 0; i <= length; ++i) {
            consumer.accept(key.substring(i) + this.marker + key.substring(0, i));
        }
    }

    @Override
    protected String prepareKey(Object k) {
        return super.prepareKey(k) + this.marker;
    }

    @Override
    public Stream<Set<E>> prefixQuery(String prefix) {
        return this.distinctPrefixQuery(this.marker + this.sanitizeKey(prefix));
    }

    @Override
    public Stream<Set<E>> suffixQuery(String suffix) {
        return this.distinctPrefixQuery(this.sanitizeKey(suffix) + this.marker);
    }

    @Override
    public Stream<Set<E>> infixQuery(String infix) {
        return this.distinctPrefixQuery(this.sanitizeKey(infix));
    }

    @Override
    public Stream<Set<E>> invertedInfixQuery(String prefix, String suffix) {
        return this.distinctPrefixQuery(this.sanitizeKey(suffix) + this.marker + this.sanitizeKey(prefix));
    }
}

