/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.query;

import io.github.douira.glsl_transformer_physics.ast.node.Identifier;
import io.github.douira.glsl_transformer_physics.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer_physics.ast.node.expression.Expression;
import io.github.douira.glsl_transformer_physics.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer_physics.ast.query.index.IdentifierIndex;
import io.github.douira.glsl_transformer_physics.ast.query.index.NodeIndex;
import io.github.douira.glsl_transformer_physics.ast.query.match.HintedMatcher;
import io.github.douira.glsl_transformer_physics.ast.query.match.Matcher;
import io.github.douira.glsl_transformer_physics.ast.transform.ASTParser;
import io.github.douira.glsl_transformer_physics.util.Passthrough;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Root {
    public final NodeIndex nodeIndex;
    public final IdentifierIndex<?> identifierIndex;
    private static Deque<Root> activeBuildRoots = new ArrayDeque<Root>();
    private List<? extends ASTNode> nodeList;
    private boolean activity;

    public Root(NodeIndex nodeIndex, IdentifierIndex<?> identifierIndex) {
        this.nodeIndex = nodeIndex;
        this.identifierIndex = identifierIndex;
    }

    public Root() {
        this(new NodeIndex(), IdentifierIndex.withPrefix());
    }

    public static Root getActiveBuildRoot() {
        return activeBuildRoots.peekFirst();
    }

    protected static final synchronized <R> R withActiveBuildRoot(Root instance, Function<Root, R> rootConsumer) {
        activeBuildRoots.push(instance);
        try {
            R r = rootConsumer.apply(instance);
            return r;
        }
        finally {
            activeBuildRoots.pop();
        }
    }

    public static synchronized <NodeType extends ASTNode> NodeType indexNodes(Root instance, Supplier<NodeType> builder) {
        return (NodeType)Root.withActiveBuildRoot(instance, root -> {
            ASTNode result = (ASTNode)builder.get();
            root.registerNode(result);
            return result;
        });
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(Supplier<NodeType> builder) {
        return Root.indexNodes(new Root(), builder);
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(ASTNode parentTreeMember, Supplier<NodeType> builder) {
        return Root.indexNodes(parentTreeMember.getRoot(), builder);
    }

    public static synchronized void indexBuildSession(Root instance, Runnable session) {
        Root.withActiveBuildRoot(instance, root -> {
            session.run();
            return null;
        });
    }

    public static void indexBuildSession(Runnable session) {
        Root.indexBuildSession(new Root(), session);
    }

    public static void indexBuildSession(ASTNode treeMember, Runnable session) {
        Root.indexBuildSession(treeMember.getRoot(), session);
    }

    public static synchronized <NodeType extends ASTNode> void indexSeparateTrees(Root instance, Consumer<Passthrough<NodeType>> registererConsumer) {
        Root.withActiveBuildRoot(instance, root -> {
            registererConsumer.accept(Passthrough.of(root::registerNode));
            return null;
        });
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(new Root(), registerer);
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(ASTNode treeMember, Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(treeMember.getRoot(), registerer);
    }

    public void registerNode(ASTNode node) {
        this.nodeIndex.add(node);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.add(identifier);
        }
    }

    public void unregisterNode(ASTNode node) {
        this.nodeIndex.remove(node);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.remove(identifier);
        }
    }

    public void unregisterIdentifierRename(Identifier identifier) {
        this.identifierIndex.remove(identifier);
    }

    public void registerIdentifierRename(Identifier identifier) {
        this.identifierIndex.add(identifier);
    }

    private void ensureEmptyNodeList() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<ASTNode>();
        } else {
            this.nodeList.clear();
        }
    }

    public boolean rename(String oldName, String newName) {
        return this.identifierIndex.rename(oldName, newName);
    }

    public <T extends ASTNode> boolean process(Stream<? extends T> targets, Consumer<? super T> replacer) {
        this.ensureEmptyNodeList();
        if (targets == null) {
            return false;
        }
        List<? extends ASTNode> typedList = this.nodeList;
        targets.forEach(typedList::add);
        boolean activity = false;
        for (ASTNode aSTNode : typedList) {
            if (aSTNode == null) continue;
            replacer.accept(aSTNode);
            activity = true;
        }
        return activity;
    }

    public boolean process(String name, Consumer<Identifier> replacer) {
        return this.process(this.identifierIndex.getStream(name), replacer);
    }

    public void replaceReferenceExpressions(ASTParser t, String name, String expression) {
        this.replaceReferenceExpressions(t, this.identifierIndex.getStream(name), expression);
    }

    public boolean replaceReferenceExpressionsReport(ASTParser t, String name, String expression) {
        return this.replaceReferenceExpressionsReport(t, this.identifierIndex.getStream(name), expression);
    }

    public void replaceReferenceExpressions(ASTParser t, Stream<Identifier> targets, String expression) {
        this.process(targets, (? super T identifier) -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            parent.replaceByAndDelete(t.parseExpression((ASTNode)identifier, expression));
        });
    }

    public boolean replaceReferenceExpressionsReport(ASTParser t, Stream<Identifier> targets, String expression) {
        this.activity = false;
        this.process(targets, (? super T identifier) -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            parent.replaceByAndDelete(t.parseExpression((ASTNode)identifier, expression));
            this.activity = true;
        });
        return this.activity;
    }

    public boolean replaceExpressions(ASTParser t, Stream<? extends Expression> targets, String expression) {
        return this.process(targets, (? super T node) -> node.replaceByAndDelete(t.parseExpression((ASTNode)node, expression)));
    }

    public static boolean replaceExpressionsConcurrent(ASTParser t, List<? extends Expression> targets, String expression) {
        for (Expression expression2 : targets) {
            expression2.replaceByAndDelete(t.parseExpression((ASTNode)expression2, expression));
        }
        return !targets.isEmpty();
    }

    public <T extends ASTNode> boolean processMatches(ASTParser t, Stream<? extends ASTNode> matchTargetChildren, Matcher<T> matcher, Consumer<? super T> replacer) {
        Class matchClass = matcher.getPatternClass();
        return this.process(matchTargetChildren.map(node -> node.getAncestor(matchClass)).distinct().filter(matcher::matches), replacer);
    }

    public <T extends ASTNode> boolean processMatches(ASTParser t, HintedMatcher<T> hintedMatcher, Consumer<? super T> replacer) {
        return this.processMatches(t, this.identifierIndex.getStream(hintedMatcher.getHint()), hintedMatcher, replacer);
    }

    public <T extends Expression> boolean replaceExpressionMatches(ASTParser t, Stream<? extends ASTNode> matchTargetChildren, Matcher<T> matcher, String expression) {
        Class matchClass = matcher.getPatternClass();
        return this.replaceExpressions(t, matchTargetChildren.map(node -> (Expression)node.getAncestor(matchClass)).distinct().filter(matcher::matches), expression);
    }

    public <T extends Expression> boolean replaceExpressionMatches(ASTParser t, HintedMatcher<T> hintedMatcher, String expression) {
        return this.replaceExpressionMatches(t, this.identifierIndex.getStream(hintedMatcher.getHint()), hintedMatcher, expression);
    }
}

