/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.print.token;

import io.github.douira.glsl_transformer_physics.GLSLLexer;
import io.github.douira.glsl_transformer_physics.ast.print.TokenRole;
import io.github.douira.glsl_transformer_physics.ast.print.token.PrintToken;
import io.github.douira.glsl_transformer_physics.cst.token_filter.TokenChannel;
import java.util.HashMap;
import java.util.Map;

public class ParserToken
extends PrintToken {
    private static final Map<Integer, String> missingTokenStrings = new HashMap<Integer, String>(){
        {
            this.put(268, "invariant");
            this.put(13, "invariant");
            this.put(231, "(");
            this.put(277, "(");
            this.put(232, ")");
            this.put(278, ")");
            this.put(255, "#\n");
            this.put(1, ":");
            this.put(276, ":");
        }
    };
    public final int tokenType;

    public ParserToken(TokenChannel channel, TokenRole role, int tokenType) {
        super(channel, role);
        this.tokenType = tokenType;
    }

    public ParserToken(TokenRole role, int tokenType) {
        super(role);
        this.tokenType = tokenType;
    }

    public ParserToken(TokenChannel channel, int tokenType) {
        super(channel);
        this.tokenType = tokenType;
    }

    public ParserToken(int tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public String getContent() {
        String literalName = GLSLLexer.VOCABULARY.getLiteralName(this.tokenType);
        if (literalName == null) {
            String replacement = missingTokenStrings.get(this.tokenType);
            if (replacement != null) {
                return replacement;
            }
            throw new IllegalStateException("Can't create a parser token for a token type that doesn't have a defined literal name!");
        }
        return literalName.substring(1, literalName.length() - 1);
    }
}

