/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import xaero.common.MinimapLogs;
import xaero.common.misc.Misc;

public class RadarUtils {
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    public static boolean hostileException(Entity e) {
        if (e instanceof Piglin) {
            return ((Piglin)e).m_6162_();
        }
        return false;
    }

    public static boolean isTamed(Entity e, Player p) {
        if (e instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)e;
            if (tameable.m_21824_() && p.m_142081_().equals(tameable.m_142504_())) {
                return true;
            }
        } else if (e instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)e;
            if (horse.m_30614_() && p.m_142081_().equals(horse.m_30615_())) {
                return true;
            }
        } else if (e instanceof Fox) {
            Fox fox = (Fox)e;
            if (FOX_TRUSTED_UUID_SECONDARY != null && p.m_142081_().equals(((Optional)fox.m_20088_().m_135370_(FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            if (FOX_TRUSTED_UUID_MAIN != null && p.m_142081_().equals(((Optional)fox.m_20088_().m_135370_(FOX_TRUSTED_UUID_MAIN)).orElse(null))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHostile(Entity e) {
        return Minecraft.m_91087_().f_91073_.m_46791_() != Difficulty.PEACEFUL && !RadarUtils.hostileException(e) && (e instanceof Monster || e instanceof Enemy || e.m_5720_() == SoundSource.HOSTILE);
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = Misc.getFieldReflection(Fox.class, "f_28439_");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        try {
            foxTrustMainField = Misc.getFieldReflection(Fox.class, "f_28440_");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (foxTrustSecondaryField != null) {
            try {
                boolean accessibleBU = foxTrustSecondaryField.isAccessible();
                foxTrustSecondaryField.setAccessible(true);
                FOX_TRUSTED_UUID_SECONDARY = (EntityDataAccessor)foxTrustSecondaryField.get(null);
                foxTrustSecondaryField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (foxTrustMainField != null) {
            try {
                boolean accessibleBU = foxTrustMainField.isAccessible();
                foxTrustMainField.setAccessible(true);
                FOX_TRUSTED_UUID_MAIN = (EntityDataAccessor)foxTrustMainField.get(null);
                foxTrustMainField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }
}

