/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn.capabilities;

import de.maxhenkel.better_respawn.Main;
import de.maxhenkel.better_respawn.capabilities.RespawnPosition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnPointCapabilityProvider
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    private final RespawnPosition respawnPosition;

    public SpawnPointCapabilityProvider(RespawnPosition respawnPosition) {
        this.respawnPosition = respawnPosition;
    }

    public SpawnPointCapabilityProvider() {
        this(new RespawnPosition());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals(Main.RESPAWN_CAPABILITY)) {
            return LazyOptional.of(() -> this.respawnPosition);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.respawnPosition.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.respawnPosition.deserializeNBT(nbt);
    }
}

