/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn.capabilities;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class RespawnPosition
implements INBTSerializable<CompoundTag> {
    private Map<ResourceLocation, BlockPos> posmap = new HashMap<ResourceLocation, BlockPos>();

    public void copyFrom(RespawnPosition respawnPosition) {
        this.posmap = respawnPosition.posmap;
    }

    public BlockPos getPos(Level world) {
        return this.posmap.get(world.m_46472_().m_135782_());
    }

    public void setPos(Level world, BlockPos pos) {
        this.posmap.put(world.m_46472_().m_135782_(), pos);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag spawnList = new ListTag();
        this.posmap.forEach((dim, pos) -> {
            if (pos != null) {
                CompoundTag data = new CompoundTag();
                data.m_128359_("Dim", dim.toString());
                data.m_128405_("SpawnX", pos.m_123341_());
                data.m_128405_("SpawnY", pos.m_123342_());
                data.m_128405_("SpawnZ", pos.m_123343_());
                spawnList.add((Object)data);
            }
        });
        compound.m_128365_("Spawns", (Tag)spawnList);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        nbt.m_128437_("Spawns", 10).forEach(e -> {
            CompoundTag data = (CompoundTag)e;
            this.posmap.put(new ResourceLocation(data.m_128461_("Dim")), new BlockPos(data.m_128451_("SpawnX"), data.m_128451_("SpawnY"), data.m_128451_("SpawnZ")));
        });
    }

    public String toString() {
        return "RespawnPosition{" + this.posmap + "}";
    }
}

