/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn;

import de.maxhenkel.better_respawn.Main;
import de.maxhenkel.better_respawn.capabilities.RespawnPosition;
import de.maxhenkel.better_respawn.capabilities.SpawnPointCapabilityProvider;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RespawnEvents {
    private static final int FIND_SPAWN_ATTEMPTS = 16;
    private static final ResourceLocation RESPAWN_CAPABILITY_ID = new ResourceLocation("better_respawn", "respawn_location");
    private final Random random = new Random();

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        BlockPos respawnPos;
        Optional vec3d;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.m_183503_().m_6042_().m_63961_()) {
            return;
        }
        BlockPos bedLocation = player.m_8961_();
        if (bedLocation != null && (vec3d = Player.m_36130_((ServerLevel)player.m_183503_(), (BlockPos)bedLocation, (float)0.0f, (boolean)false, (boolean)false)).isPresent()) {
            Vec3 spawn = (Vec3)vec3d.get();
            if (player.m_142538_().m_123333_(new Vec3i(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_)) <= (Integer)Main.SERVER_CONFIG.bedRange.get()) {
                Main.LOGGER.info("Player {} is within the range of its respawn block", (Object)player.m_7755_().m_6111_());
                return;
            }
        }
        if ((respawnPos = this.findValidRespawnLocation(player.m_183503_(), player.m_142538_())) == null) {
            return;
        }
        player.m_9158_(player.f_19853_.m_46472_(), respawnPos, 0.0f, true, false);
        Main.LOGGER.info("Set temporary respawn location to [{}, {}, {}]", (Object)respawnPos.m_123341_(), (Object)respawnPos.m_123342_(), (Object)respawnPos.m_123343_());
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        ServerPlayer player;
        block7: {
            block6: {
                Entity entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) break block6;
                player = (ServerPlayer)entity;
                if (event.getEntity().m_6084_()) break block7;
            }
            return;
        }
        RespawnPosition respawnPosition = (RespawnPosition)player.getCapability(Main.RESPAWN_CAPABILITY).orElse(null);
        if (respawnPosition == null) {
            Main.LOGGER.error("Player {} has no respawn location capability", (Object)player.m_7755_().m_6111_());
            return;
        }
        BlockPos respawn = respawnPosition.getPos(event.getWorld());
        player.m_9158_(event.getWorld().m_46472_(), respawn, 0.0f, false, false);
        if (respawn == null) {
            Main.LOGGER.info("Setting the players respawn position back to world spawn");
        } else {
            Main.LOGGER.info("Setting the players respawn position back to [{}, {}, {}]", (Object)respawn.m_123341_(), (Object)respawn.m_123342_(), (Object)respawn.m_123343_());
        }
    }

    @SubscribeEvent
    public void onSetSpawn(PlayerSetSpawnEvent event) {
        if (event.isForced()) {
            return;
        }
        BlockPos newSpawn = event.getNewSpawn();
        if (newSpawn != null) {
            event.getPlayer().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition -> respawnPosition.setPos(event.getPlayer().f_19853_, newSpawn));
            Main.LOGGER.info("Updating the respawn location of player {} to [{}, {}, {}]", (Object)event.getPlayer().m_7755_().m_6111_(), (Object)newSpawn.m_123341_(), (Object)newSpawn.m_123342_(), (Object)newSpawn.m_123343_());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition -> event.getPlayer().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition1 -> {
            respawnPosition1.copyFrom((RespawnPosition)respawnPosition);
            Main.LOGGER.info("Copying respawn location capability of player {}", (Object)event.getPlayer().m_7755_().m_6111_());
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public void onPlayerCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer) && !((Entity)event.getObject()).getCapability(Main.RESPAWN_CAPABILITY).isPresent()) {
            event.addCapability(RESPAWN_CAPABILITY_ID, (ICapabilityProvider)new SpawnPointCapabilityProvider());
            Main.LOGGER.info("Attaching respawn capability to player");
        }
    }

    @Nullable
    public BlockPos findValidRespawnLocation(ServerLevel world, BlockPos deathLocation) {
        int min = (Integer)Main.SERVER_CONFIG.minRespawnDistance.get();
        int max = (Integer)Main.SERVER_CONFIG.maxRespawnDistance.get();
        BlockPos pos = null;
        for (int i = 0; i < 16 && pos == null; ++i) {
            Main.LOGGER.info("Searching for respawn location - Attempt {}/{}", (Object)(i + 1), (Object)16);
            pos = PlayerRespawnLogic.m_183932_((ServerLevel)world, (ChunkPos)new ChunkPos(new BlockPos(this.getRandomRange(deathLocation.m_123341_(), min, max), 0, this.getRandomRange(deathLocation.m_123343_(), min, max))));
        }
        if (pos == null) {
            Main.LOGGER.info("Found no valid respawn location after {} attempts", (Object)16);
        } else {
            Main.LOGGER.info("Found valid respawn location: [{}, {}, {}]", (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        return pos;
    }

    private int getRandomRange(int actual, int minDistance, int maxDistance) {
        return actual + (this.random.nextBoolean() ? -1 : 1) * (minDistance + this.random.nextInt(maxDistance - minDistance));
    }
}

