/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import dev.sapphic.armorsoundtweak.ArmorSoundTweak;
import dev.sapphic.armorsoundtweak.EquipmentTicker;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import top.theillusivec4.curios.api.CuriosApi;

final class CuriosTicker
extends EquipmentTicker {
    CuriosTicker() {
    }

    static void register() {
        MinecraftForge.EVENT_BUS.addListener((Consumer)new CuriosTicker());
    }

    private static IItemHandler getEquippedCurios(Player player) {
        return (IItemHandler)CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).orElse((Object)((IItemHandlerModifiable)EmptyHandler.INSTANCE));
    }

    @Override
    protected Iterable<ItemStack> getEquipment(Player player) {
        IItemHandler handler = CuriosTicker.getEquippedCurios(player);
        ArrayList<ItemStack> curios = new ArrayList<ItemStack>(handler.getSlots());
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            curios.add(handler.getStackInSlot(slot).m_41777_());
        }
        return curios;
    }

    @Override
    protected void playEquipSound(Player player, Item item) {
        if (!ArmorSoundTweak.config().allowsCurios()) {
            return;
        }
        CuriosApi.getCuriosHelper().getCurio(new ItemStack((ItemLike)item)).map(curio -> curio.getEquipSound(null)).ifPresentOrElse(sound -> player.m_6330_(sound.soundEvent(), SoundSource.NEUTRAL, sound.volume(), sound.pitch()), () -> player.m_6330_(SoundEvents.f_11675_, SoundSource.NEUTRAL, 1.0f, 1.0f));
    }
}

